/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.DialectException;
import com.af.v4.system.common.datasource.dialects.StrUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class GuessDialectUtils {
    private static final Map<DataSource, Dialect> dataSourceDialectCache = new ConcurrentHashMap<DataSource, Dialect>();

    public static Dialect guessDialect(Connection jdbcConnection) {
        int minorVersion;
        int majorVersion;
        String databaseName;
        String driverName;
        try {
            DatabaseMetaData meta = jdbcConnection.getMetaData();
            driverName = meta.getDriverName();
            databaseName = meta.getDatabaseProductName();
            majorVersion = meta.getDatabaseMajorVersion();
            minorVersion = meta.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            return (Dialect)DialectException.throwEX(e);
        }
        return GuessDialectUtils.guessDialect(driverName, databaseName, majorVersion, minorVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dialect guessDialect(DataSource dataSource) {
        Dialect result = dataSourceDialectCache.get(dataSource);
        if (result != null) {
            return result;
        }
        Connection con = null;
        try {
            con = dataSource.getConnection();
            result = GuessDialectUtils.guessDialect(con);
            if (result == null) {
                Dialect dialect = (Dialect)DialectException.throwEX("Can not get dialect from DataSource, please submit this bug.");
                return dialect;
            }
            dataSourceDialectCache.put(dataSource, result);
            Dialect dialect = result;
            return dialect;
        }
        catch (SQLException e) {
            Dialect dialect = (Dialect)DialectException.throwEX(e);
            return dialect;
        }
        finally {
            try {
                if (con != null && !con.isClosed()) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        DialectException.throwEX(e);
                    }
                }
            }
            catch (SQLException e) {
                DialectException.throwEX(e);
            }
        }
    }

    public static Dialect guessDialect(String driverName) {
        return GuessDialectUtils.guessDialect(driverName, null, 0, 0);
    }

    public static Dialect guessDialect(String driverName, String databaseName, Object ... majorVersionMinorVersion) {
        int majorVersion = 0;
        int minorVersion = 0;
        for (int i = 0; i < majorVersionMinorVersion.length; ++i) {
            if (i == 0) {
                majorVersion = (Integer)majorVersionMinorVersion[i];
            }
            if (i != 1) continue;
            minorVersion = (Integer)majorVersionMinorVersion[i];
        }
        if ("MySQL".equals(databaseName)) {
            if (majorVersion < 5) {
                return Dialect.MySQLDialect;
            }
            if (majorVersion == 5) {
                if (minorVersion < 5) {
                    return Dialect.MySQL5Dialect;
                }
                if (minorVersion < 7) {
                    return Dialect.MySQL55Dialect;
                }
                return Dialect.MySQL57Dialect;
            }
            if (majorVersion == 8) {
                return Dialect.MySQL8Dialect;
            }
            return Dialect.MySQLDialect;
        }
        if ("PostgreSQL".equals(databaseName)) {
            if (majorVersion == 9) {
                if (minorVersion >= 4) {
                    return Dialect.PostgreSQL94Dialect;
                }
                if (minorVersion >= 2) {
                    return Dialect.PostgreSQL92Dialect;
                }
                return Dialect.PostgreSQL9Dialect;
            }
            if (majorVersion == 8 && minorVersion >= 2) {
                return Dialect.PostgreSQL82Dialect;
            }
            return Dialect.PostgreSQL81Dialect;
        }
        if (databaseName.startsWith("Microsoft SQL Server")) {
            switch (majorVersion) {
                case 8: {
                    return Dialect.SQLServerDialect;
                }
                case 9: {
                    return Dialect.SQLServer2005Dialect;
                }
                case 10: {
                    return Dialect.SQLServer2008Dialect;
                }
                case 11: 
                case 12: 
                case 13: {
                    return Dialect.SQLServer2012Dialect;
                }
            }
            if (majorVersion < 8) {
                return Dialect.SQLServerDialect;
            }
            return Dialect.SQLServer2012Dialect;
        }
        if (StrUtils.containsIgnoreCase(databaseName, "Oracle")) {
            switch (majorVersion) {
                case 12: {
                    return Dialect.Oracle12cDialect;
                }
                case 10: 
                case 11: {
                    return Dialect.Oracle10gDialect;
                }
                case 9: {
                    return Dialect.Oracle9iDialect;
                }
                case 8: {
                    return Dialect.Oracle8iDialect;
                }
            }
            return Dialect.Oracle12cDialect;
        }
        if (StrUtils.containsIgnoreCase(databaseName, "sqlite")) {
            return Dialect.SQLiteDialect;
        }
        if (StrUtils.startsWithIgnoreCase(databaseName, "DM")) {
            return Dialect.DamengDialect;
        }
        return null;
    }
}

