package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;

import java.security.SecureRandom;
import java.sql.Connection;

/**
 * Generate any length UUID String based on radix 36, use 0-9 a-z characters
 * <br/>
 * Default length is 20;
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class UUIDAnyGenerator implements IdGenerator {

    private static final SecureRandom random = new SecureRandom();
    private static final char[] ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();

    private final String name;
    private Integer length;

    /**
     * Build a give length UUID Generator
     */
    public UUIDAnyGenerator(String name, Integer length) {
        this.name = name;
        this.length = length;
    }

    public static String getAnyLengthRadix36UUID(Integer length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i++) {
            sb.append(ALPHABET[random.nextInt(32)]);
        }
        return sb.toString();
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.UUID_ANY;
    }

    @Override
    public String getIdGenName() {
        return name;
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        return getAnyLengthRadix36UUID(length);
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public IdGenerator newCopy() {
        return new UUIDAnyGenerator(name, length);
    }

    // getter & setter
    public Integer getLength() {
        return length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

}
