package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;

import java.sql.Connection;

/**
 * Interface for all ID generators
 *
 * @version 1.0.0
 * @since 1.0
 */

public interface IdGenerator {

    /**
     * Get the next ID generated by implementation of IdGenerator
     *
     * @param con      Connection which used get next ID, note this connection will not be closed in method call
     * @param dialect  The Dialect
     * @param dataType The {@link Type} of a column
     * @return id generated by IdGenerator
     */
    Object getNextID(Connection con, Dialect dialect, Type dataType);

    /**
     * Return GenerationType
     */
    GenerationType getGenerationType();

    /**
     * Return a unique Id Generator name in this TableModel
     */
    String getIdGenName();

    /**
     * Return a newCopy (Deep Clone) instance
     */
    IdGenerator newCopy();

    /**
     * If depends on AutoIdGenerator, for example SortedUUIDGenerator depends on
     * AutoIdGenerator to create start numbers
     */
    Boolean dependOnAutoIdGenerator();

}
