/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.StrUtils;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;
import com.af.v4.system.common.datasource.dialects.id.IdGenerator;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.UUID;

public class UUID26Generator
implements IdGenerator {
    public static final UUID26Generator INSTANCE = new UUID26Generator();

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.UUID26;
    }

    @Override
    public String getIdGenName() {
        return "UUID26";
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        return UUID26Generator.getUUID26();
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }

    public static String getUUID26() {
        String uuidHex = UUID.randomUUID().toString().replace("-", "");
        BigInteger b = new BigInteger(uuidHex, 16);
        StringBuilder s = new StringBuilder(b.toString(36));
        while (s.length() < 26) {
            s.append(StrUtils.getRandomChar());
        }
        return s.toString();
    }
}

