/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.DialectException;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;
import com.af.v4.system.common.datasource.dialects.id.AutoIdGenerator;
import com.af.v4.system.common.datasource.dialects.id.IdGenerator;
import com.af.v4.system.common.datasource.dialects.id.UUIDAnyGenerator;
import java.sql.Connection;

public record SortedUUIDGenerator(String name, int sortedLength, int uuidLength) implements IdGenerator
{
    @Override
    public GenerationType getGenerationType() {
        return GenerationType.SORTED_UUID;
    }

    @Override
    public String getIdGenName() {
        return this.name;
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return true;
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        String s = String.valueOf(AutoIdGenerator.INSTANCE.getNextID(con, dialect, dataType));
        if (s.length() > this.sortedLength - 1) {
            throw new DialectException("SortedLength should set bigger than auto generated ID length");
        }
        return "1" + "0".repeat(Math.max(0, this.sortedLength - s.length() - 1)) + s + UUIDAnyGenerator.getAnyLengthRadix36UUID(this.uuidLength);
    }

    @Override
    public IdGenerator newCopy() {
        return new SortedUUIDGenerator(this.name, this.sortedLength, this.uuidLength);
    }
}

