package com.af.v4.system.common.datasource.dialects;

/**
 * SQL语法预处理器接口
 * 用于处理数据库方言间的语法差异，在函数转换之前执行
 * 
 * @author framework
 * @since 2.12.55
 */
public interface SqlSyntaxProcessor {
    
    /**
     * 处理SQL语句，进行语法转换
     * 
     * @param dialect 目标数据库方言
     * @param sql 原始SQL语句
     * @return 转换后的SQL语句
     */
    String process(Dialect dialect, String sql);
    
    /**
     * 检查是否能处理该SQL语句
     * 
     * @param sql 待检查的SQL语句
     * @return true如果能处理，false否则
     */
    boolean canHandle(String sql);
    
    /**
     * 获取处理器的优先级，数字越小优先级越高
     * 
     * @return 优先级数值
     */
    default int getPriority() {
        return 100;
    }
    
    /**
     * 获取处理器名称
     * 
     * @return 处理器名称
     */
    default String getName() {
        return this.getClass().getSimpleName();
    }
}