/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.Type;
import java.util.Map;

public class DialectTypeMappingTemplate {
    protected static void initTypeMappingTemplates() {
        Map<Type, String> m = Dialect.SQLiteDialect.typeMappings;
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BINARY, "blob");
        m.put(Type.BIT, "boolean");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "decimal");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float($p)");
        m.put(Type.INTEGER, "integer");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "blob");
        m.put(Type.LONGVARCHAR, "longvarchar");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "datetime");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.VARBINARY, "blob");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.MySQLDialect.typeMappings;
        m.put(Type.BINARY, "binary($p)");
        m.put(Type.BIT, "bit");
        m.put(Type.LONGBLOB, "longblob");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "bit");
        m.put(Type.CHAR, "char($p)");
        m.put(Type.CLOB, "longtext");
        m.put(Type.DATE, "date");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
        m.put(Type.LONGVARCHAR, "longtext");
        m.put(Type.NCLOB, "longtext");
        m.put(Type.NUMERIC, "decimal($p,$s)");
        m.put(Type.TIME, "time");
        m.put(Type.DATETIME, "datetime");
        m.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");
        m.put(Type.DECIMAL, "decimal($p,$s)");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.MEDIUMINT, "MEDIUMINT");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.BIGINT, "bigint");
        m.put(Type.YEAR, "year($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.INT, "INT");
        m.put(Type.TINYBLOB, "TINYBLOB");
        m.put(Type.TINYTEXT, "TINYTEXT");
        m.put(Type.TEXT, "TEXT");
        m.put(Type.MEDIUMBLOB, "MEDIUMBLOB");
        m.put(Type.MEDIUMTEXT, "MEDIUMTEXT");
        m.put(Type.LONGTEXT, "LONGTEXT");
        m.put(Type.JSON, "JSON");
        m = Dialect.MySQL5Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m = Dialect.MySQL55Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m = Dialect.MySQL57Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m.put(Type.TIMESTAMP, "datetime(6)");
        m = Dialect.MySQL57InnoDBDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m.put(Type.TIMESTAMP, "datetime(6)");
        m = Dialect.MySQL5InnoDBDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m = Dialect.MySQLInnoDBDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m = Dialect.MySQLMyISAMDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m = Dialect.MySQL8Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m.put(Type.TIMESTAMP, "datetime(6)");
        m = Dialect.OracleDialect.typeMappings;
        m.put(Type.BIGINT, "number(19,0)");
        m.put(Type.BIT, "number(1,0)");
        m.put(Type.BLOB, "blob");
        m.put(Type.CHAR, "char($l)");
        m.put(Type.CLOB, "clob");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "number($p,$s)");
        m.put(Type.DOUBLE, "double");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "number($l,0)");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar2($l)");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "number($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "number(5,0)");
        m.put(Type.TIME, "date");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "number(3,0)");
        m.put(Type.VARBINARY, "raw($l)<2000|long raw");
        m.put(Type.BINARY_FLOAT, "BINARY_FLOAT");
        m.put(Type.BINARY_DOUBLE, "BINARY_DOUBLE");
        m.put(Type.DOUBLE_PRECISION, "DOUBLE PRECISION");
        m.put(Type.TIMESTAMP_WITH_TIME_ZONE, "TIMESTAMP WITH TIME ZONE");
        m.put(Type.TIMESTAMP_WITH_LOCAL_TIME_ZONE, "TIMESTAMP WITH LOCAL TIME ZONE");
        m.put(Type.INTERVAL_YEAR_TO_MONTH, "INTERVAL YEAR($l) TO MONTH");
        m.put(Type.INTERVAL_DAY_TO_SECOND, "INTERVAL DAY($p) TO SECOND($s)");
        m.put(Type.VARCHAR2, "varchar2($l)");
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m.put(Type.VARCHAR, "varchar($l char)<4000|long");
        m = Dialect.Oracle10gDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.CHAR, "char($l char)");
        m.put(Type.LONGNVARCHAR, "nvarchar2($l)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m.put(Type.NVARCHAR, "nvarchar2($l)");
        m.put(Type.TIMESTAMP, "timestamp");
        m = Dialect.Oracle12cDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.CHAR, "char($l char)");
        m.put(Type.LONGNVARCHAR, "nvarchar2($l)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m.put(Type.NVARCHAR, "nvarchar2($l)");
        m.put(Type.TIMESTAMP, "timestamp");
        m = Dialect.Oracle8iDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m = Dialect.Oracle9Dialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);
        m.put(Type.CHAR, "char($l char)");
        m.put(Type.TIMESTAMP, "timestamp");
        m = Dialect.Oracle9iDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.CHAR, "char($l char)");
        m.put(Type.LONGNVARCHAR, "nvarchar2($l)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m.put(Type.NVARCHAR, "nvarchar2($l)");
        m.put(Type.TIMESTAMP, "timestamp");
        m = Dialect.PostgreSQLDialect.typeMappings;
        m.put(Type.BIGINT, "int8");
        m.put(Type.BINARY, "bytea");
        m.put(Type.BIT, "bool");
        m.put(Type.BLOB, "oid");
        m.put(Type.BOOLEAN, "boolean");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "text");
        m.put(Type.DATE, "date");
        m.put(Type.DECIMAL, "numeric($p, $s)");
        m.put(Type.DOUBLE, "float8");
        m.put(Type.FLOAT, "float4");
        m.put(Type.INTEGER, "int4");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "bytea");
        m.put(Type.LONGVARCHAR, "text");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p, $s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "int2");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.TINYINT, "int2");
        m.put(Type.VARBINARY, "bytea");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.PostgresPlusDialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m = Dialect.PostgreSQL81Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m = Dialect.PostgreSQL82Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m = Dialect.PostgreSQL9Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m = Dialect.PostgreSQL91Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m = Dialect.PostgreSQL92Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m = Dialect.PostgreSQL93Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m = Dialect.PostgreSQL94Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m = Dialect.PostgreSQL95Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);
        m.put(Type.JAVA_OBJECT, "json");
        m = Dialect.SQLServerDialect.typeMappings;
        m.put(Type.BIGINT, "numeric(19,0)");
        m.put(Type.BINARY, "binary($l)");
        m.put(Type.BIT, "tinyint");
        m.put(Type.BLOB, "image");
        m.put(Type.BOOLEAN, "bit");
        m.put(Type.CHAR, "char(1)");
        m.put(Type.CLOB, "text");
        m.put(Type.DATE, "datetime");
        m.put(Type.DECIMAL, "numeric($p,$s)");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "int");
        m.put(Type.JAVA_OBJECT, "N/A");
        m.put(Type.LONGNVARCHAR, "nvarchar($l)");
        m.put(Type.LONGVARBINARY, "image");
        m.put(Type.LONGVARCHAR, "text");
        m.put(Type.NCHAR, "nchar($l)");
        m.put(Type.NCLOB, "nclob");
        m.put(Type.NUMERIC, "numeric($p,$s)");
        m.put(Type.NVARCHAR, "nvarchar($l)");
        m.put(Type.REAL, "real");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.TIME, "datetime");
        m.put(Type.TIMESTAMP, "datetime");
        m.put(Type.TINYINT, "smallint");
        m.put(Type.VARBINARY, "varbinary($l)<8000|image");
        m.put(Type.VARCHAR, "varchar($l)");
        m = Dialect.SQLServer2005Dialect.typeMappings;
        m.putAll(Dialect.SQLServerDialect.typeMappings);
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "varbinary(MAX)");
        m.put(Type.CLOB, "varchar(MAX)");
        m.put(Type.LONGVARBINARY, "varbinary(MAX)");
        m.put(Type.LONGVARCHAR, "varchar(MAX)");
        m.put(Type.NCLOB, "nvarchar(MAX)");
        m.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
        m.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
        m = Dialect.SQLServer2008Dialect.typeMappings;
        m.putAll(Dialect.SQLServerDialect.typeMappings);
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "varbinary(MAX)");
        m.put(Type.CLOB, "varchar(MAX)");
        m.put(Type.DATE, "date");
        m.put(Type.LONGVARBINARY, "varbinary(MAX)");
        m.put(Type.LONGVARCHAR, "varchar(MAX)");
        m.put(Type.NCLOB, "nvarchar(MAX)");
        m.put(Type.NVARCHAR, "nvarchar($l)<4000|nvarchar(MAX)");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "datetime2");
        m.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
        m.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
        m = Dialect.SQLServer2012Dialect.typeMappings;
        m.putAll(Dialect.SQLServerDialect.typeMappings);
        m.put(Type.BIGINT, "bigint");
        m.put(Type.BIT, "bit");
        m.put(Type.BLOB, "varbinary(MAX)");
        m.put(Type.CLOB, "varchar(MAX)");
        m.put(Type.DATE, "date");
        m.put(Type.LONGVARBINARY, "varbinary(MAX)");
        m.put(Type.LONGVARCHAR, "varchar(MAX)");
        m.put(Type.NCLOB, "nvarchar(MAX)");
        m.put(Type.NVARCHAR, "nvarchar($l)<4000|nvarchar(MAX)");
        m.put(Type.TIME, "time");
        m.put(Type.TIMESTAMP, "datetime2");
        m.put(Type.VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
        m.put(Type.VARCHAR, "varchar($l)<8000|varchar(MAX)");
    }

    protected static void initTypeConvertMapping() {
        Map<String, String> m = Dialect.SQLiteDialect.typeConvertMapping;
        m = Dialect.MySQLDialect.typeConvertMapping;
        m.put("mi", "minute");
        m.put("yy", "year");
        m.put("hh", "hour");
        m.put("mm", "month");
        m.put("ww", "week");
        m.put("dd", "day");
        m = Dialect.OracleDialect.typeConvertMapping;
        m = Dialect.PostgreSQLDialect.typeConvertMapping;
        m = Dialect.SQLServerDialect.typeConvertMapping;
    }
}

