/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;
import com.af.v4.system.common.datasource.dialects.id.IdGenerator;
import com.af.v4.system.common.datasource.dialects.id.SequenceIdGenerator;
import com.af.v4.system.common.datasource.dialects.id.TableIdGenerator;
import java.sql.Connection;

public class AutoIdGenerator
implements IdGenerator {
    public static final AutoIdGenerator INSTANCE = new AutoIdGenerator();
    private static final String JDIALECTS_AUTOID_NAME = "jdia_autoid";
    private static final String JDIALECTS_AUTOID_TABLE = "jdia_table_autoid";
    public static final TableIdGenerator TABLE_AUTOID_INSTANCE = new TableIdGenerator("jdia_autoid", "jdia_table_autoid", "idcolumn", "valuecolumn", "next_val", 1, 50);
    private static final String JDIALECTS_AUTOID_SEQUENCE = "jdia_seq_autoid";
    public static final SequenceIdGenerator SEQ_AUTOID_INSTANCE = new SequenceIdGenerator("jdia_autoid", "jdia_seq_autoid", 1, 1);

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.AUTO;
    }

    @Override
    public String getIdGenName() {
        return JDIALECTS_AUTOID_NAME;
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return true;
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        if (dialect.ddlFeatures.supportBasicOrPooledSequence()) {
            return SEQ_AUTOID_INSTANCE.getNextID(con, dialect, dataType);
        }
        return TABLE_AUTOID_INSTANCE.getNextID(con, dialect, dataType);
    }

    public IdGenerator getSequenceOrTableIdGenerator(Dialect dialect) {
        if (dialect.ddlFeatures.supportBasicOrPooledSequence()) {
            return SEQ_AUTOID_INSTANCE;
        }
        return TABLE_AUTOID_INSTANCE;
    }
}

