package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;

import java.sql.Connection;
import java.util.concurrent.locks.ReentrantLock;

/**
 * This TimeStampGenerator return a long type value based on computer's current
 * time
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class TimeStampIdGenerator implements IdGenerator {
    public static final TimeStampIdGenerator INSTANCE = new TimeStampIdGenerator();
    private static long count = 1;
    private static final ReentrantLock LOCK = new ReentrantLock();

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.TIMESTAMP;
    }

    @Override
    public String getIdGenName() {
        return "TimeStampId";
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        return getNextID();
    }

    public static Object getNextID() {
        LOCK.lock();
        try {
            if (count > 999999)
                count = 1;
            return System.currentTimeMillis() * 1000000 + count++;
        } finally {
            LOCK.unlock();
        }
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }
}
