/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.SqlSyntaxProcessor;
import com.af.v4.system.common.datasource.dialects.StrUtils;
import java.util.regex.Pattern;

public class WithRecursiveProcessor
implements SqlSyntaxProcessor {
    private static final Pattern WITH_CTE_PATTERN = Pattern.compile("(?:^|\\s|\\n)WITH\\s*(?:/\\*.*?\\*/\\s*)?(?:RECURSIVE\\s*(?:/\\*.*?\\*/\\s*)?)?\\s*\\w+\\s*(?:/\\*.*?\\*/\\s*)?AS\\s*\\(", 34);
    private static final Pattern UNION_ALL_PATTERN = Pattern.compile("UNION\\s+ALL", 2);

    @Override
    public String process(Dialect dialect, String sql) {
        if (!this.canHandle(sql)) {
            return sql;
        }
        boolean isRecursive = this.isRecursiveCTE(sql);
        boolean hasRecursive = StrUtils.containsIgnoreCase(sql, "RECURSIVE");
        if (dialect.isPostgresFamily() || dialect.isMySqlFamily()) {
            if (isRecursive && !hasRecursive) {
                return sql.replaceAll("(?i)((?:^|\\s|\\n)WITH)(\\s*(?:/\\*.*?\\*/\\s*)?)(\\w+)", "$1 RECURSIVE $3");
            }
            return sql;
        }
        if (hasRecursive) {
            return sql.replaceAll("(?i)((?:^|\\s|\\n)WITH)(\\s*(?:/\\*.*?\\*/\\s*)?)RECURSIVE(\\s*(?:/\\*.*?\\*/\\s*)?)", "$1$2$3");
        }
        return sql;
    }

    @Override
    public boolean canHandle(String sql) {
        if (sql == null || sql.trim().isEmpty()) {
            return false;
        }
        boolean hasWithCte = WITH_CTE_PATTERN.matcher(sql).find();
        if (hasWithCte) {
            Pattern tableHintPattern = Pattern.compile("FROM\\s+\\w+\\s+with\\s*\\(", 2);
            boolean hasTableHint = tableHintPattern.matcher(sql).find();
            return !hasTableHint;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public String getName() {
        return "WithRecursiveProcessor";
    }

    private boolean isRecursiveCTE(String sql) {
        int unionIndex;
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        String sqlLower = sql.toLowerCase();
        if (!UNION_ALL_PATTERN.matcher(sql).find()) {
            return false;
        }
        String[] parts = sqlLower.split("\\s+");
        String cteName = null;
        for (int i = 0; i < parts.length - 2; ++i) {
            if (!"with".equals(parts[i])) continue;
            int nameIndex = i + 1;
            if (nameIndex < parts.length && "recursive".equals(parts[nameIndex])) {
                nameIndex = i + 2;
            }
            if (nameIndex >= parts.length || "as".equals(parts[nameIndex])) continue;
            cteName = parts[nameIndex];
            break;
        }
        if (cteName != null && (unionIndex = sqlLower.indexOf("union all")) > 0) {
            String afterUnion = sqlLower.substring(unionIndex);
            return afterUnion.contains(" " + cteName + " ") || afterUnion.contains(" " + cteName + ",") || afterUnion.contains("from " + cteName) || afterUnion.contains("join " + cteName);
        }
        return false;
    }
}

