package com.af.v4.system.common.datasource.dialects;

/**
 * DialectType is a enum list all dialects, if customized dialect, use
 * "Customized" type.
 *
 * @since 1.7.0
 */
@SuppressWarnings("all")
public enum DialectType {
    // 这个类没啥用，主要用于方便使用case遍历
    OracleDialect, Oracle9Dialect, MySQL55Dialect, MySQL57Dialect, MySQL57InnoDBDialect, MySQL5Dialect, MySQL5InnoDBDialect, MySQL8Dialect, MySQLDialect, MySQLInnoDBDialect, MySQLMyISAMDialect, Oracle10gDialect, Oracle12cDialect, Oracle8iDialect, Oracle9iDialect, PostgresPlusDialect, PostgreSQL81Dialect, PostgreSQL82Dialect, PostgreSQL91Dialect, PostgreSQL92Dialect, PostgreSQL93Dialect, PostgreSQL94Dialect, PostgreSQL95Dialect, PostgreSQL9Dialect, PostgreSQLDialect, SQLServer2005Dialect, SQLServer2008Dialect, SQLServer2012Dialect, SQLServer2016Dialect, SQLServerDialect, SQLiteDialect,

    // 未兼容 的数据库
    Customized, DerbyDialect, DamengDialect, GBaseDialect, AccessDialect, CobolDialect, DbfDialect, ExcelDialect, ParadoxDialect, TextDialect, XMLDialect, Cache71Dialect, CUBRIDDialect, DataDirectOracle9Dialect, DB2390Dialect, DB2390V8Dialect, DB2400Dialect, DB297Dialect, DB2Dialect, DerbyTenFiveDialect, DerbyTenSevenDialect, DerbyTenSixDialect, FirebirdDialect, FrontBaseDialect, H2Dialect, HANAColumnStoreDialect, HANARowStoreDialect, HSQLDialect, Informix10Dialect, InformixDialect, Ingres10Dialect, Ingres9Dialect, IngresDialect, InterbaseDialect, JDataStoreDialect, MariaDB102Dialect, MariaDB103Dialect, MariaDB10Dialect, MariaDB53Dialect, MariaDBDialect, MckoiDialect, MimerSQLDialect, PointbaseDialect, ProgressDialect, RDMSOS2200Dialect, SAPDBDialect, Sybase11Dialect, SybaseAnywhereDialect, SybaseASE157Dialect, SybaseASE15Dialect, SybaseDialect, Teradata14Dialect, TeradataDialect, TimesTenDialect;

    public static DialectType getDialectType(Dialect d) {
        DialectType diaType = null;
        try {
            diaType = DialectType.valueOf(d.getName());
        } catch (Exception e) {
            diaType = DialectType.Customized;
        }
        return diaType;
    }
}
