/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects;

import com.af.v4.system.common.datasource.dialects.DDLCreateUtils;
import com.af.v4.system.common.datasource.dialects.DDLDropUtils;
import com.af.v4.system.common.datasource.dialects.DDLFeatures;
import com.af.v4.system.common.datasource.dialects.DialectException;
import com.af.v4.system.common.datasource.dialects.DialectFunctionTemplate;
import com.af.v4.system.common.datasource.dialects.DialectFunctionTranslator;
import com.af.v4.system.common.datasource.dialects.DialectPaginationTemplate;
import com.af.v4.system.common.datasource.dialects.DialectTypeMappingTemplate;
import com.af.v4.system.common.datasource.dialects.ReservedDBWords;
import com.af.v4.system.common.datasource.dialects.StrUtils;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.model.ColumnModel;
import com.af.v4.system.common.datasource.dialects.model.TableModel;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dialect {
    public static final Dialect OracleDialect = new Dialect("OracleDialect");
    public static final Dialect Oracle9Dialect = new Dialect("Oracle9Dialect");
    public static final Dialect Oracle10gDialect = new Dialect("Oracle10gDialect");
    public static final Dialect Oracle12cDialect = new Dialect("Oracle12cDialect");
    public static final Dialect Oracle8iDialect = new Dialect("Oracle8iDialect");
    public static final Dialect Oracle9iDialect = new Dialect("Oracle9iDialect");
    public static final Dialect SQLiteDialect = new Dialect("SQLiteDialect");
    public static final Dialect MySQLDialect = new Dialect("MySQLDialect");
    public static final Dialect MySQL5InnoDBDialect = new Dialect("MySQL5InnoDBDialect");
    public static final Dialect MySQL57InnoDBDialect = new Dialect("MySQL57InnoDBDialect");
    public static final Dialect MySQLInnoDBDialect = new Dialect("MySQLInnoDBDialect");
    public static final Dialect MySQLMyISAMDialect = new Dialect("MySQLMyISAMDialect");
    public static final Dialect MySQL55Dialect = new Dialect("MySQL55Dialect");
    public static final Dialect MySQL57Dialect = new Dialect("MySQL57Dialect");
    public static final Dialect MySQL5Dialect = new Dialect("MySQL5Dialect");
    public static final Dialect MySQL8Dialect = new Dialect("MySQL8Dialect");
    public static final Dialect PostgreSQLDialect = new Dialect("PostgreSQLDialect");
    public static final Dialect PostgresPlusDialect = new Dialect("PostgresPlusDialect");
    public static final Dialect PostgreSQL9Dialect = new Dialect("PostgreSQL9Dialect");
    public static final Dialect PostgreSQL10Dialect = new Dialect("PostgreSQL10Dialect");
    public static final Dialect PostgreSQL81Dialect = new Dialect("PostgreSQL81Dialect");
    public static final Dialect PostgreSQL82Dialect = new Dialect("PostgreSQL82Dialect");
    public static final Dialect PostgreSQL91Dialect = new Dialect("PostgreSQL91Dialect");
    public static final Dialect PostgreSQL92Dialect = new Dialect("PostgreSQL92Dialect");
    public static final Dialect PostgreSQL93Dialect = new Dialect("PostgreSQL93Dialect");
    public static final Dialect PostgreSQL94Dialect = new Dialect("PostgreSQL94Dialect");
    public static final Dialect PostgreSQL95Dialect = new Dialect("PostgreSQL95Dialect");
    public static final Dialect SQLServerDialect = new Dialect("SQLServerDialect");
    public static final Dialect SQLServer2005Dialect = new Dialect("SQLServer2005Dialect");
    public static final Dialect SQLServer2008Dialect = new Dialect("SQLServer2008Dialect");
    public static final Dialect SQLServer2012Dialect = new Dialect("SQLServer2012Dialect");
    public static final Dialect SQLServer2016Dialect = new Dialect("SQLServer2016Dialect");
    public static final Dialect DamengDialect = new Dialect("DamengDialect");
    public static final Dialect ClickhouseDialect = new Dialect("ClickhouseDialect");
    public static Dialect[] dialects = new Dialect[]{OracleDialect, Oracle9Dialect, MySQL55Dialect, MySQL57Dialect, MySQL57InnoDBDialect, MySQL5Dialect, MySQL5InnoDBDialect, MySQL8Dialect, MySQLDialect, MySQLInnoDBDialect, MySQLMyISAMDialect, Oracle10gDialect, Oracle12cDialect, Oracle8iDialect, Oracle9iDialect, PostgresPlusDialect, PostgreSQL81Dialect, PostgreSQL82Dialect, PostgreSQL91Dialect, PostgreSQL92Dialect, PostgreSQL93Dialect, PostgreSQL94Dialect, PostgreSQL95Dialect, PostgreSQL9Dialect, PostgreSQLDialect, SQLServer2005Dialect, SQLServer2008Dialect, SQLServer2012Dialect, SQLServer2016Dialect, SQLServerDialect, SQLiteDialect, DamengDialect};
    private static Boolean globalAllowReservedWords = false;
    private static final Logger logger = LoggerFactory.getLogger(Dialect.class);
    private static Boolean globalAllowShowSql = false;
    private static String globalSqlFunctionPrefix = null;
    public static final String NOT_SUPPORT = "NOT_SUPPORT";
    private static final String SKIP_ROWS = "$SKIP_ROWS";
    private static final String PAGESIZE = "$PAGESIZE";
    private static final String TOTAL_ROWS = "$TOTAL_ROWS";
    private static final String DISTINCT_TAG = "($DISTINCT)";
    public String sqlTemplate;
    public String topLimitTemplate;
    public String name;
    public Map<Type, String> typeMappings = new EnumMap<Type, String>(Type.class);
    public Map<String, String> typeConvertMapping = new HashMap<String, String>();
    public Map<String, String> functions = new HashMap<String, String>();
    public DDLFeatures ddlFeatures = new DDLFeatures();

    public Dialect() {
        this.name = this.getClass().getSimpleName();
    }

    public Dialect(String name) {
        this.name = name;
    }

    @Deprecated
    public static Dialect[] values() {
        return dialects;
    }

    private void checkIfReservedWord(String word, String ... tableName) {
        if (ReservedDBWords.isReservedWord(word)) {
            String inTable = tableName.length > 0 ? "In table " + tableName[0] + ", " : "";
            String reservedForDB = ReservedDBWords.reservedForDB(word);
            if (ReservedDBWords.isReservedWord(this, word)) {
                if (globalAllowReservedWords.booleanValue()) {
                    logger.warn(inTable + "\"" + word + "\" is a reserved word of \"" + reservedForDB + "\", should not use it as table, column, unique or index name");
                } else {
                    DialectException.throwEX(inTable + "\"" + word + "\" is a reserved word of \"" + reservedForDB + "\", should not use it as table, column, unique or index name. if you really want use this reserved word, call Dialect.setGlobalAllowReservedWords() at application starting.");
                }
            } else {
                logger.warn(inTable + "\"" + word + "\" is a reserved word of other database \"" + reservedForDB + "\", not recommend be used as table, column, unique or index name");
            }
        }
    }

    public String checkReservedWords(String ... words) {
        if (words == null || words.length == 0) {
            return null;
        }
        for (String word : words) {
            this.checkIfReservedWord(word, new String[0]);
        }
        return words[0];
    }

    public String checkNotEmptyReservedWords(String word, String type, String tableName) {
        if (StrUtils.isEmpty(word)) {
            DialectException.throwEX(type + " can not be empty");
        }
        this.checkIfReservedWord(word, tableName);
        return word;
    }

    public String translateToDDLType(ColumnModel col) {
        Type type = col.getColumnType();
        String value = this.typeMappings.get((Object)type);
        if (StrUtils.isEmpty(value) || "N/A".equals(value) || "n/a".equals(value)) {
            DialectException.throwEX("Type \"" + String.valueOf((Object)type) + "\" is not supported by dialect \"" + String.valueOf(this) + "\"");
        }
        if (value.contains("|")) {
            String[] typeTempls;
            for (String templ : typeTempls = StrUtils.split("|", value)) {
                if (templ.contains("<")) {
                    String[] limitType = StrUtils.split("<", templ);
                    if (col.getLength() <= 0 || col.getLength() > Integer.parseInt(limitType[1])) continue;
                    return this.replacePlaceHolders(type, limitType[0], col);
                }
                return this.replacePlaceHolders(type, templ, col);
            }
            return (String)DialectException.throwEX("Type \"" + String.valueOf((Object)type) + "\" is not supported by dialect \"" + String.valueOf(this) + "\" of template:" + value);
        }
        if (value.contains("$")) {
            return this.replacePlaceHolders(type, value, col);
        }
        return value;
    }

    private String replacePlaceHolders(Type type, String value, ColumnModel col) {
        String newValue = StrUtils.replace(value, "$l", String.valueOf(col.getLength()));
        if (newValue.contains("$p")) {
            newValue = StrUtils.replace(newValue, "$p", String.valueOf(col.getPrecision()));
        }
        if (newValue.contains("$s")) {
            newValue = StrUtils.replace(newValue, "$s", String.valueOf(col.getScale()));
        }
        return newValue;
    }

    private static String aTopLimitSqlExample(String template) {
        String result = StrUtils.replaceIgnoreCase(template, "$SQL", "select * from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, "$BODY", "* from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, " ($DISTINCT)", "");
        result = StrUtils.replaceIgnoreCase(result, SKIP_ROWS, "0");
        result = StrUtils.replaceIgnoreCase(result, PAGESIZE, "10");
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS, "10");
        return result;
    }

    public String trans(String ... sql) {
        StringBuilder sb = new StringBuilder();
        for (String str : sql) {
            sb.append(str);
        }
        return DialectFunctionTranslator.instance.doTranslate(this, sb.toString());
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return this.name.equals(((Dialect)obj).name);
    }

    public boolean isFamily(String databaseName) {
        return StrUtils.startsWithIgnoreCase(this.toString(), databaseName);
    }

    public boolean isMySqlFamily() {
        return this.isFamily("MySQL");
    }

    public boolean isOracleFamily() {
        return this.isFamily("Oracle");
    }

    public boolean isSQLServerFamily() {
        return this.isFamily("SQLServer");
    }

    public boolean isPostgresFamily() {
        return this.isFamily("Postgres");
    }

    public String[] toCreateDDL(TableModel ... tables) {
        return DDLCreateUtils.toCreateDDL(this, tables);
    }

    public String[] toDropDDL(TableModel ... tables) {
        return DDLDropUtils.toDropDDL(this, tables);
    }

    public String[] toAddColumnDDL(ColumnModel ... columnModels) {
        return DDLCreateUtils.toAddColumnDDL(this, columnModels);
    }

    public String[] toModifyColumnDDL(ColumnModel ... columnModels) {
        return DDLCreateUtils.toModifyColumnDDL(this, columnModels);
    }

    public String[] toDropColumnDDL(ColumnModel ... columnModels) {
        return DDLDropUtils.toDropColumnDDL(this, columnModels);
    }

    public String[] toDropAndCreateDDL(TableModel ... tables) {
        String[] drop = DDLDropUtils.toDropDDL(this, tables);
        String[] create = DDLCreateUtils.toCreateDDL(this, tables);
        return StrUtils.joinStringArray(drop, create);
    }

    public String dropTableDDL(String tableName) {
        return this.ddlFeatures.dropTableString.replaceFirst("_TABLENAME", tableName);
    }

    public String dropSequenceDDL(String sequenceName) {
        if (DDLFeatures.isValidDDLTemplate(this.ddlFeatures.dropSequenceStrings)) {
            return StrUtils.replace(this.ddlFeatures.dropSequenceStrings, "_SEQNAME", sequenceName);
        }
        return (String)DialectException.throwEX("Dialect \"" + String.valueOf(this) + "\" does not support drop sequence ddl, on sequence \"" + sequenceName + "\"");
    }

    public String dropFKeyDDL(String tableName, String fkeyName) {
        if (DDLFeatures.isValidDDLTemplate(this.ddlFeatures.dropForeignKeyString)) {
            return "alter table " + tableName + " " + this.ddlFeatures.dropForeignKeyString + " " + fkeyName;
        }
        return (String)DialectException.throwEX("Dialect \"" + String.valueOf(this) + "\" does not support drop foreign key, on foreign key \"" + fkeyName + "\"");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DDLFeatures getDdlFeatures() {
        return this.ddlFeatures;
    }

    public static Boolean getGlobalAllowShowSql() {
        return globalAllowShowSql;
    }

    public static String getGlobalSqlFunctionPrefix() {
        return globalSqlFunctionPrefix;
    }

    static {
        DialectTypeMappingTemplate.initTypeMappingTemplates();
        DialectTypeMappingTemplate.initTypeConvertMapping();
        DialectFunctionTemplate.initFunctionTemplates();
        DialectPaginationTemplate.initPaginTemplates();
        DDLFeatures.initDDLFeatures();
        DialectFunctionTemplate.initExtraFunctionTemplates();
    }
}

