/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.DialectType;
import com.af.v4.system.common.datasource.dialects.StrUtils;

public class DDLFeatures {
    public static final String NOT_SUPPORT = "NOT_SUPPORT";
    protected String addColumnString;
    protected String addColumnSuffixString;
    protected String columnSuffixString;
    protected String modifyColumnString;
    protected String addForeignKeyConstraintString;
    protected String addFKeyRefPkeyString;
    protected String addPrimaryKeyConstraintString;
    protected String columnComment;
    protected String createCatalogCommand;
    protected String createMultisetTableString;
    protected String createPooledSequenceStrings;
    protected String createSchemaCommand;
    protected String createSequenceStrings;
    protected String createTableString;
    protected String currentSchemaCommand;
    protected String dropCatalogCommand;
    protected String dropColumnString;
    protected String dropForeignKeyString;
    protected String dropSchemaCommand;
    protected String dropSequenceStrings;
    protected String dropTableString;
    protected Boolean hasAlterTable;
    protected Boolean hasDataTypeInIdentityColumn;
    protected String identityColumnString;
    protected String identityColumnStringBigINT;
    protected String identitySelectString;
    protected String identitySelectStringBigINT;
    protected Boolean needDropConstraintsBeforeDropTable;
    protected String nullColumnString;
    protected Boolean requiresParensForTupleDistinctCounts;
    protected String selectSequenceNextValString;
    protected String sequenceNextValString;
    protected Boolean supportsColumnCheck;
    protected Boolean supportsCommentOn;
    protected Boolean supportsIdentityColumns;
    protected Boolean supportsIfExistsAfterConstraintName;
    protected String openQuote;
    protected String closeQuote;
    protected Boolean supportsIfExistsAfterTableName;
    protected Boolean supportsIfExistsBeforeConstraintName;
    protected Boolean supportsIfExistsBeforeTableName;
    protected Boolean supportsInsertSelectIdentity;
    protected Boolean supportsPooledSequences;
    protected Boolean supportsSequences;
    protected Boolean supportsTableCheck;
    protected String tableTypeString;

    protected static void initDDLFeatures() {
        for (Dialect d : Dialect.dialects) {
            DDLFeatures.initDDLFeatures(d);
        }
    }

    protected static boolean isValidDDLTemplate(String featureValue) {
        return !StrUtils.isEmpty(featureValue) && !NOT_SUPPORT.equals(featureValue);
    }

    public static DDLFeatures createDefaultDDLFeatures() {
        DDLFeatures ddl = new DDLFeatures();
        ddl.addColumnString = "add";
        ddl.addColumnSuffixString = "";
        ddl.columnSuffixString = NOT_SUPPORT;
        ddl.modifyColumnString = "modify ";
        ddl.addFKeyRefPkeyString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
        ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
        ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
        ddl.closeQuote = "\"";
        ddl.columnComment = "";
        ddl.createCatalogCommand = NOT_SUPPORT;
        ddl.createMultisetTableString = "create table";
        ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by 33";
        ddl.createSchemaCommand = "create schema _SCHEMANAME";
        ddl.createSequenceStrings = "create sequence _SEQ";
        ddl.createTableString = "create table";
        ddl.currentSchemaCommand = NOT_SUPPORT;
        ddl.dropCatalogCommand = NOT_SUPPORT;
        ddl.dropColumnString = "drop column";
        ddl.dropForeignKeyString = " drop constraint ";
        ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
        ddl.dropSequenceStrings = "drop sequence _SEQNAME";
        ddl.dropTableString = "drop table _TABLENAME cascade constraints";
        ddl.hasAlterTable = true;
        ddl.hasDataTypeInIdentityColumn = true;
        ddl.identityColumnString = NOT_SUPPORT;
        ddl.identityColumnStringBigINT = NOT_SUPPORT;
        ddl.identitySelectString = NOT_SUPPORT;
        ddl.identitySelectStringBigINT = NOT_SUPPORT;
        ddl.needDropConstraintsBeforeDropTable = false;
        ddl.nullColumnString = "";
        ddl.openQuote = "\"";
        ddl.requiresParensForTupleDistinctCounts = false;
        ddl.selectSequenceNextValString = "_SEQNAME.nextval";
        ddl.sequenceNextValString = "select _SEQNAME.nextval from dual";
        ddl.supportsColumnCheck = true;
        ddl.supportsCommentOn = true;
        ddl.supportsIdentityColumns = false;
        ddl.supportsIfExistsAfterConstraintName = false;
        ddl.supportsIfExistsBeforeConstraintName = false;
        ddl.supportsPooledSequences = true;
        ddl.supportsSequences = true;
        ddl.supportsTableCheck = true;
        ddl.tableTypeString = "";
        return ddl;
    }

    protected static void initDDLFeatures(Dialect dia) {
        DDLFeatures ddl;
        dia.ddlFeatures = ddl = DDLFeatures.createDefaultDDLFeatures();
        switch (DialectType.getDialectType(dia)) {
            case SQLiteDialect: {
                ddl.addColumnString = "add column";
                ddl.addFKeyRefPkeyString = NOT_SUPPORT;
                ddl.addForeignKeyConstraintString = NOT_SUPPORT;
                ddl.addPrimaryKeyConstraintString = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.dropForeignKeyString = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = false;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "integer";
                ddl.identityColumnStringBigINT = "integer";
                ddl.identitySelectString = "select last_insert_rowid()";
                ddl.identitySelectStringBigINT = "select last_insert_rowid()";
                ddl.selectSequenceNextValString = NOT_SUPPORT;
                ddl.sequenceNextValString = NOT_SUPPORT;
                ddl.supportsIdentityColumns = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case MySQLDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.dropColumnString = NOT_SUPPORT;
                ddl.columnSuffixString = NOT_SUPPORT;
                ddl.modifyColumnString = NOT_SUPPORT;
                ddl.addFKeyRefPkeyString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.closeQuote = "`";
                ddl.columnComment = " comment '_COMMENT'";
                ddl.createTableString = "create table if not exists";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.identitySelectStringBigINT = "select last_insert_id()";
                ddl.openQuote = "`";
                ddl.selectSequenceNextValString = NOT_SUPPORT;
                ddl.sequenceNextValString = NOT_SUPPORT;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                ddl.tableTypeString = " type=MyISAM";
                break;
            }
            case MySQL5Dialect: {
                ddl.addColumnString = "add column";
                ddl.addFKeyRefPkeyString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.closeQuote = "`";
                ddl.columnComment = " comment '_COMMENT'";
                ddl.createTableString = "create table if not exists";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.identitySelectStringBigINT = "select last_insert_id()";
                ddl.openQuote = "`";
                ddl.selectSequenceNextValString = NOT_SUPPORT;
                ddl.sequenceNextValString = NOT_SUPPORT;
                ddl.supportsColumnCheck = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                ddl.tableTypeString = " engine=MyISAM";
                break;
            }
            case MySQL55Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.dropColumnString = "alter table";
                ddl.columnSuffixString = NOT_SUPPORT;
                ddl.modifyColumnString = NOT_SUPPORT;
                ddl.addFKeyRefPkeyString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.closeQuote = "`";
                ddl.columnComment = " comment '_COMMENT'";
                ddl.createTableString = "create table if not exists";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.identitySelectStringBigINT = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.openQuote = "`";
                ddl.selectSequenceNextValString = NOT_SUPPORT;
                ddl.sequenceNextValString = NOT_SUPPORT;
                ddl.supportsColumnCheck = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                ddl.tableTypeString = " engine=InnoDB";
                break;
            }
            case MySQL57Dialect: 
            case MySQL57InnoDBDialect: 
            case MySQL5InnoDBDialect: 
            case MySQL8Dialect: {
                ddl.addColumnString = "add column";
                ddl.addFKeyRefPkeyString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.closeQuote = "`";
                ddl.columnComment = " comment '_COMMENT'";
                ddl.createTableString = "create table if not exists";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.identitySelectStringBigINT = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.openQuote = "`";
                ddl.selectSequenceNextValString = NOT_SUPPORT;
                ddl.sequenceNextValString = NOT_SUPPORT;
                ddl.supportsColumnCheck = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                ddl.tableTypeString = " engine=InnoDB";
                break;
            }
            case MySQLInnoDBDialect: {
                ddl.addColumnString = "add column";
                ddl.addFKeyRefPkeyString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.closeQuote = "`";
                ddl.columnComment = " comment '_COMMENT'";
                ddl.createTableString = "create table if not exists";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.identitySelectStringBigINT = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.openQuote = "`";
                ddl.selectSequenceNextValString = NOT_SUPPORT;
                ddl.sequenceNextValString = NOT_SUPPORT;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                ddl.tableTypeString = " type=InnoDB";
                break;
            }
            case MySQLMyISAMDialect: {
                ddl.addColumnString = "add column";
                ddl.addFKeyRefPkeyString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.closeQuote = "`";
                ddl.columnComment = " comment '_COMMENT'";
                ddl.createTableString = "create table if not exists";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.identitySelectStringBigINT = "select last_insert_id()";
                ddl.openQuote = "`";
                ddl.selectSequenceNextValString = NOT_SUPPORT;
                ddl.sequenceNextValString = NOT_SUPPORT;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                ddl.tableTypeString = " type=MyISAM";
                break;
            }
            case OracleDialect: 
            case Oracle9Dialect: {
                break;
            }
            case Oracle10gDialect: 
            case Oracle9iDialect: 
            case Oracle8iDialect: {
                ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by  33";
                ddl.currentSchemaCommand = "SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL";
                break;
            }
            case Oracle12cDialect: {
                ddl.createPooledSequenceStrings = "create sequence _SEQ start with 11 increment by  33";
                ddl.currentSchemaCommand = "SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL";
                ddl.identityColumnString = "generated as identity";
                ddl.identityColumnStringBigINT = "generated as identity";
                ddl.supportsIdentityColumns = true;
                break;
            }
            case PointbaseDialect: {
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME cascade";
                ddl.selectSequenceNextValString = NOT_SUPPORT;
                ddl.sequenceNextValString = NOT_SUPPORT;
                ddl.supportsCommentOn = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case PostgreSQLDialect: 
            case PostgresPlusDialect: 
            case PostgreSQL82Dialect: {
                ddl.addColumnString = "add column";
                ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME cascade";
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.identitySelectStringBigINT = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.requiresParensForTupleDistinctCounts = true;
                ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
                ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
                ddl.supportsIdentityColumns = true;
                break;
            }
            case PostgreSQL81Dialect: {
                ddl.addColumnString = "add column";
                ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
                ddl.dropTableString = "drop table _TABLENAME cascade";
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.identitySelectStringBigINT = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.requiresParensForTupleDistinctCounts = true;
                ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
                ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
                ddl.supportsIdentityColumns = true;
                break;
            }
            case PostgreSQL9Dialect: 
            case PostgreSQL95Dialect: 
            case PostgreSQL94Dialect: 
            case PostgreSQL93Dialect: 
            case PostgreSQL92Dialect: 
            case PostgreSQL91Dialect: {
                ddl.addColumnString = "add column";
                ddl.createPooledSequenceStrings = "create sequence _SEQ start 11 increment 33";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME cascade";
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.identitySelectStringBigINT = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.requiresParensForTupleDistinctCounts = true;
                ddl.selectSequenceNextValString = "nextval ('_SEQNAME')";
                ddl.sequenceNextValString = "select nextval ('_SEQNAME')";
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsBeforeConstraintName = true;
                break;
            }
            case SQLServerDialect: 
            case SQLServer2008Dialect: 
            case SQLServer2005Dialect: {
                ddl.closeQuote = "]";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.currentSchemaCommand = "SELECT SCHEMA_NAME()";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.identityColumnString = "identity not null";
                ddl.identityColumnStringBigINT = "identity not null";
                ddl.identitySelectString = "select @@identity";
                ddl.identitySelectStringBigINT = "select @@identity";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.openQuote = "[";
                ddl.selectSequenceNextValString = NOT_SUPPORT;
                ddl.sequenceNextValString = NOT_SUPPORT;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case SQLServer2012Dialect: {
                ddl.closeQuote = "]";
                ddl.currentSchemaCommand = "SELECT SCHEMA_NAME()";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.identityColumnString = "identity not null";
                ddl.identityColumnStringBigINT = "identity not null";
                ddl.identitySelectString = "select @@identity";
                ddl.identitySelectStringBigINT = "select @@identity";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.openQuote = "[";
                ddl.selectSequenceNextValString = "next value for _SEQNAME";
                ddl.sequenceNextValString = "select next value for _SEQNAME";
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                break;
            }
        }
    }

    public boolean supportBasicOrPooledSequence() {
        return this.supportsSequences != false || this.supportsPooledSequences != false;
    }

    public String getAddColumnString() {
        return this.addColumnString;
    }

    public void setAddColumnString(String addColumnString) {
        this.addColumnString = addColumnString;
    }

    public String getAddColumnSuffixString() {
        return this.addColumnSuffixString;
    }

    public void setAddColumnSuffixString(String addColumnSuffixString) {
        this.addColumnSuffixString = addColumnSuffixString;
    }

    public String getAddForeignKeyConstraintString() {
        return this.addForeignKeyConstraintString;
    }

    public void setAddForeignKeyConstraintString(String addForeignKeyConstraintString) {
        this.addForeignKeyConstraintString = addForeignKeyConstraintString;
    }

    public String getAddFKeyRefPkeyString() {
        return this.addFKeyRefPkeyString;
    }

    public void setAddFKeyRefPkeyString(String addFKeyRefPkeyString) {
        this.addFKeyRefPkeyString = addFKeyRefPkeyString;
    }

    public String getAddPrimaryKeyConstraintString() {
        return this.addPrimaryKeyConstraintString;
    }

    public void setAddPrimaryKeyConstraintString(String addPrimaryKeyConstraintString) {
        this.addPrimaryKeyConstraintString = addPrimaryKeyConstraintString;
    }

    public String getColumnComment() {
        return this.columnComment;
    }

    public void setColumnComment(String columnComment) {
        this.columnComment = columnComment;
    }

    public String getCreateCatalogCommand() {
        return this.createCatalogCommand;
    }

    public void setCreateCatalogCommand(String createCatalogCommand) {
        this.createCatalogCommand = createCatalogCommand;
    }

    public String getCreateMultisetTableString() {
        return this.createMultisetTableString;
    }

    public void setCreateMultisetTableString(String createMultisetTableString) {
        this.createMultisetTableString = createMultisetTableString;
    }

    public String getCreatePooledSequenceStrings() {
        return this.createPooledSequenceStrings;
    }

    public void setCreatePooledSequenceStrings(String createPooledSequenceStrings) {
        this.createPooledSequenceStrings = createPooledSequenceStrings;
    }

    public String getCreateSchemaCommand() {
        return this.createSchemaCommand;
    }

    public void setCreateSchemaCommand(String createSchemaCommand) {
        this.createSchemaCommand = createSchemaCommand;
    }

    public String getCreateSequenceStrings() {
        return this.createSequenceStrings;
    }

    public void setCreateSequenceStrings(String createSequenceStrings) {
        this.createSequenceStrings = createSequenceStrings;
    }

    public String getCreateTableString() {
        return this.createTableString;
    }

    public void setCreateTableString(String createTableString) {
        this.createTableString = createTableString;
    }

    public String getCurrentSchemaCommand() {
        return this.currentSchemaCommand;
    }

    public void setCurrentSchemaCommand(String currentSchemaCommand) {
        this.currentSchemaCommand = currentSchemaCommand;
    }

    public String getDropCatalogCommand() {
        return this.dropCatalogCommand;
    }

    public void setDropCatalogCommand(String dropCatalogCommand) {
        this.dropCatalogCommand = dropCatalogCommand;
    }

    public String getDropForeignKeyString() {
        return this.dropForeignKeyString;
    }

    public void setDropForeignKeyString(String dropForeignKeyString) {
        this.dropForeignKeyString = dropForeignKeyString;
    }

    public String getDropSchemaCommand() {
        return this.dropSchemaCommand;
    }

    public void setDropSchemaCommand(String dropSchemaCommand) {
        this.dropSchemaCommand = dropSchemaCommand;
    }

    public String getDropSequenceStrings() {
        return this.dropSequenceStrings;
    }

    public void setDropSequenceStrings(String dropSequenceStrings) {
        this.dropSequenceStrings = dropSequenceStrings;
    }

    public String getDropTableString() {
        return this.dropTableString;
    }

    public void setDropTableString(String dropTableString) {
        this.dropTableString = dropTableString;
    }

    public Boolean getHasAlterTable() {
        return this.hasAlterTable;
    }

    public void setHasAlterTable(Boolean hasAlterTable) {
        this.hasAlterTable = hasAlterTable;
    }

    public Boolean getHasDataTypeInIdentityColumn() {
        return this.hasDataTypeInIdentityColumn;
    }

    public void setHasDataTypeInIdentityColumn(Boolean hasDataTypeInIdentityColumn) {
        this.hasDataTypeInIdentityColumn = hasDataTypeInIdentityColumn;
    }

    public String getIdentityColumnString() {
        return this.identityColumnString;
    }

    public void setIdentityColumnString(String identityColumnString) {
        this.identityColumnString = identityColumnString;
    }

    public String getIdentityColumnStringBigINT() {
        return this.identityColumnStringBigINT;
    }

    public void setIdentityColumnStringBigINT(String identityColumnStringBigINT) {
        this.identityColumnStringBigINT = identityColumnStringBigINT;
    }

    public String getIdentitySelectString() {
        return this.identitySelectString;
    }

    public void setIdentitySelectString(String identitySelectString) {
        this.identitySelectString = identitySelectString;
    }

    public String getIdentitySelectStringBigINT() {
        return this.identitySelectStringBigINT;
    }

    public void setIdentitySelectStringBigINT(String identitySelectStringBigINT) {
        this.identitySelectStringBigINT = identitySelectStringBigINT;
    }

    public Boolean getNeedDropConstraintsBeforeDropTable() {
        return this.needDropConstraintsBeforeDropTable;
    }

    public void setNeedDropConstraintsBeforeDropTable(Boolean needDropConstraintsBeforeDropTable) {
        this.needDropConstraintsBeforeDropTable = needDropConstraintsBeforeDropTable;
    }

    public String getNullColumnString() {
        return this.nullColumnString;
    }

    public void setNullColumnString(String nullColumnString) {
        this.nullColumnString = nullColumnString;
    }

    public Boolean getRequiresParensForTupleDistinctCounts() {
        return this.requiresParensForTupleDistinctCounts;
    }

    public void setRequiresParensForTupleDistinctCounts(Boolean requiresParensForTupleDistinctCounts) {
        this.requiresParensForTupleDistinctCounts = requiresParensForTupleDistinctCounts;
    }

    public String getSelectSequenceNextValString() {
        return this.selectSequenceNextValString;
    }

    public void setSelectSequenceNextValString(String selectSequenceNextValString) {
        this.selectSequenceNextValString = selectSequenceNextValString;
    }

    public String getSequenceNextValString() {
        return this.sequenceNextValString;
    }

    public void setSequenceNextValString(String sequenceNextValString) {
        this.sequenceNextValString = sequenceNextValString;
    }

    public Boolean getSupportsColumnCheck() {
        return this.supportsColumnCheck;
    }

    public void setSupportsColumnCheck(Boolean supportsColumnCheck) {
        this.supportsColumnCheck = supportsColumnCheck;
    }

    public Boolean getSupportsCommentOn() {
        return this.supportsCommentOn;
    }

    public void setSupportsCommentOn(Boolean supportsCommentOn) {
        this.supportsCommentOn = supportsCommentOn;
    }

    public Boolean getSupportsIdentityColumns() {
        return this.supportsIdentityColumns;
    }

    public void setSupportsIdentityColumns(Boolean supportsIdentityColumns) {
        this.supportsIdentityColumns = supportsIdentityColumns;
    }

    public Boolean getSupportsIfExistsAfterConstraintName() {
        return this.supportsIfExistsAfterConstraintName;
    }

    public void setSupportsIfExistsAfterConstraintName(Boolean supportsIfExistsAfterConstraintName) {
        this.supportsIfExistsAfterConstraintName = supportsIfExistsAfterConstraintName;
    }

    public String getOpenQuote() {
        return this.openQuote;
    }

    public void setOpenQuote(String openQuote) {
        this.openQuote = openQuote;
    }

    public String getCloseQuote() {
        return this.closeQuote;
    }

    public void setCloseQuote(String closeQuote) {
        this.closeQuote = closeQuote;
    }

    public Boolean getSupportsIfExistsAfterTableName() {
        return this.supportsIfExistsAfterTableName;
    }

    public void setSupportsIfExistsAfterTableName(Boolean supportsIfExistsAfterTableName) {
        this.supportsIfExistsAfterTableName = supportsIfExistsAfterTableName;
    }

    public Boolean getSupportsIfExistsBeforeConstraintName() {
        return this.supportsIfExistsBeforeConstraintName;
    }

    public void setSupportsIfExistsBeforeConstraintName(Boolean supportsIfExistsBeforeConstraintName) {
        this.supportsIfExistsBeforeConstraintName = supportsIfExistsBeforeConstraintName;
    }

    public Boolean getSupportsIfExistsBeforeTableName() {
        return this.supportsIfExistsBeforeTableName;
    }

    public void setSupportsIfExistsBeforeTableName(Boolean supportsIfExistsBeforeTableName) {
        this.supportsIfExistsBeforeTableName = supportsIfExistsBeforeTableName;
    }

    public Boolean getSupportsInsertSelectIdentity() {
        return this.supportsInsertSelectIdentity;
    }

    public void setSupportsInsertSelectIdentity(Boolean supportsInsertSelectIdentity) {
        this.supportsInsertSelectIdentity = supportsInsertSelectIdentity;
    }

    public Boolean getSupportsPooledSequences() {
        return this.supportsPooledSequences;
    }

    public void setSupportsPooledSequences(Boolean supportsPooledSequences) {
        this.supportsPooledSequences = supportsPooledSequences;
    }

    public Boolean getSupportsSequences() {
        return this.supportsSequences;
    }

    public void setSupportsSequences(Boolean supportsSequences) {
        this.supportsSequences = supportsSequences;
    }

    public Boolean getSupportsTableCheck() {
        return this.supportsTableCheck;
    }

    public void setSupportsTableCheck(Boolean supportsTableCheck) {
        this.supportsTableCheck = supportsTableCheck;
    }

    public String getTableTypeString() {
        return this.tableTypeString;
    }

    public void setTableTypeString(String tableTypeString) {
        this.tableTypeString = tableTypeString;
    }
}

