/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.config;

import com.af.v4.system.common.core.exception.CheckedException;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.utils.StringUtils;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.config.AfDataSourceConfig;
import com.af.v4.system.common.datasource.provider.DataSourceProvider;
import com.af.v4.system.common.datasource.wrapper.AfDataSourceWrapper;
import com.zaxxer.hikari.HikariDataSource;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Configuration
@ConfigurationProperties(prefix="db")
@Component
public class DynamicDataSourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicDataSourceConfig.class);
    private List<AfDataSourceConfig> dataSourceList;
    private List<String> subClass;
    private Integer minimumIdle;
    private Integer maximumPoolSize;
    private Integer connectionTimeout;
    private Integer idleTimeout;
    private Integer maxLifetime;

    @Bean
    @Primary
    public DynamicDataSource routingDataSource() {
        if (Optional.ofNullable(this.dataSourceList).isEmpty()) {
            throw new CheckedException("\u670d\u52a1\u542f\u52a8\u5931\u8d25\uff1a\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u52a0\u8f7d\u4e86nacos\u914d\u7f6e");
        }
        LinkedHashMap<String, AfDataSourceWrapper> targetDataSources = new LinkedHashMap<String, AfDataSourceWrapper>(this.dataSourceList.size());
        StringBuilder dataSourcePrintList = new StringBuilder();
        this.dataSourceList.forEach(item -> {
            if (!StringUtils.isEmpty((String)item.getRedirect())) {
                AfDataSourceWrapper targetWrapper = (AfDataSourceWrapper)targetDataSources.get(item.getRedirect());
                if (targetWrapper != null) {
                    targetDataSources.put(item.getName(), targetWrapper);
                    dataSourcePrintList.append(item.getName()).append(" -> ").append(item.getRedirect()).append(", ");
                    return;
                }
                LOGGER.error("\u65e0\u6548\u7684\u6570\u636e\u6e90\u91cd\u5b9a\u5411\uff1a{}", (Object)item.getRedirect());
                throw new ServiceException("\u65e0\u6548\u7684\u6570\u636e\u6e90\u91cd\u5b9a\u5411", Integer.valueOf(506));
            }
            dataSourcePrintList.append(item.getName()).append(", ");
            Supplier<HikariDataSource> dataSource = () -> DataSourceProvider.create(item, this.minimumIdle, this.maximumPoolSize, this.connectionTimeout, this.idleTimeout, this.maxLifetime);
            targetDataSources.put(item.getName(), new AfDataSourceWrapper(dataSource, (AfDataSourceConfig)item));
        });
        if (dataSourcePrintList.length() >= 2) {
            dataSourcePrintList.delete(dataSourcePrintList.length() - 2, dataSourcePrintList.length());
        }
        LOGGER.info("\u8bc6\u522b\u5230\u7684\u6570\u636e\u6e90\uff1a[{}]", (Object)dataSourcePrintList);
        return new DynamicDataSource(targetDataSources);
    }

    public List<AfDataSourceConfig> getDataSourceList() {
        return this.dataSourceList;
    }

    public void setDataSourceList(List<AfDataSourceConfig> dataSourceList) {
        this.dataSourceList = dataSourceList;
    }

    public List<String> getSubClass() {
        return this.subClass;
    }

    public void setSubClass(List<String> subClass) {
        this.subClass = subClass;
    }

    public Integer getMinimumIdle() {
        return this.minimumIdle;
    }

    public void setMinimumIdle(Integer minimumIdle) {
        this.minimumIdle = minimumIdle;
    }

    public Integer getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(Integer maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Integer getMaxLifetime() {
        return this.maxLifetime;
    }

    public void setMaxLifetime(Integer maxLifetime) {
        this.maxLifetime = maxLifetime;
    }
}

