package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;

import java.sql.Connection;
import java.util.UUID;

/**
 * Generate a JDK 36 letters random UUID generated by
 * UUID.randomUUID().toString(), for example:</br>
 * d3ad36c0-c6c2-495c-a414-b9cc4a0a7a93
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class UUID36Generator implements IdGenerator {
    public static final UUID36Generator INSTANCE = new UUID36Generator();

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.UUID36;
    }

    @Override
    public String getIdGenName() {
        return "UUID36";
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        return UUID.randomUUID().toString();
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }

}
