package com.af.v4.system.common.datasource.dialects;

import java.util.Map;

import static com.af.v4.system.common.datasource.dialects.Type.*;

/**
 * 原本项目中ddlsql使用类型的转换
 */
@SuppressWarnings("all")
public class DialectTypeMappingTemplate {

    protected static void initTypeMappingTemplates() {

        //================SQLiteDialect family===============
        Map<Type, String> m = Dialect.SQLiteDialect.typeMappings;
        m.put(BIGINT, "bigint");
        m.put(BINARY, "blob");
        m.put(BIT, "boolean");
        m.put(BLOB, "blob");
        m.put(BOOLEAN, "boolean");
        m.put(CHAR, "char");
        m.put(CLOB, "clob");
        m.put(DATE, "date");
        m.put(DECIMAL, "decimal");
        m.put(DOUBLE, "double precision");
        m.put(FLOAT, "float($p)");
        m.put(INTEGER, "integer");
        m.put(JAVA_OBJECT, "N/A");
        m.put(LONGNVARCHAR, "nvarchar($l)");
        m.put(LONGVARBINARY, "blob");
        m.put(LONGVARCHAR, "longvarchar");
        m.put(NCHAR, "nchar($l)");
        m.put(NCLOB, "nclob");
        m.put(NUMERIC, "numeric($p,$s)");
        m.put(NVARCHAR, "nvarchar($l)");
        m.put(REAL, "real");
        m.put(SMALLINT, "smallint");
        m.put(TIME, "time");
        m.put(TIMESTAMP, "datetime");
        m.put(TINYINT, "tinyint");
        m.put(VARBINARY, "blob");
        m.put(VARCHAR, "varchar($l)");

        //================MySQLDialect family===============
        m = Dialect.MySQLDialect.typeMappings;
        m.put(Type.BINARY, "binary($p)");
        m.put(Type.BIT, "bit");
        m.put(Type.LONGBLOB, "longblob");
        m.put(Type.BLOB, "blob");
        m.put(Type.BOOLEAN, "bit");
        m.put(Type.CHAR, "char($p)");
        m.put(Type.CLOB, "longtext");
        m.put(Type.DATE, "date");
        m.put(Type.DOUBLE, "double precision");
        m.put(Type.FLOAT, "float");
        m.put(Type.INTEGER, "integer");
        m.put(Type.LONGVARBINARY, "mediumblob<16777215|longblob");
        m.put(Type.LONGVARCHAR, "longtext");
        m.put(Type.NCLOB, "longtext");
        m.put(Type.NUMERIC, "decimal($p,$s)");
        m.put(Type.TIME, "time");
        m.put(Type.DATETIME, "datetime");
        m.put(Type.VARBINARY, "tinyblob<255|blob<65535|mediumblob<16777215|longblob");

        m.put(DECIMAL, "decimal($p,$s)");
        m.put(Type.SMALLINT, "smallint");
        m.put(Type.MEDIUMINT, "MEDIUMINT");
        m.put(Type.TINYINT, "tinyint");
        m.put(Type.BIGINT, "bigint");
        m.put(Type.YEAR, "year($l)");
        m.put(Type.VARCHAR, "varchar($l)");
        m.put(Type.TIMESTAMP, "timestamp");
        m.put(Type.INT, "INT");
        m.put(Type.TINYBLOB, "TINYBLOB");
        m.put(Type.TINYTEXT, "TINYTEXT");
        m.put(Type.TEXT, "TEXT");
        m.put(Type.MEDIUMBLOB, "MEDIUMBLOB");
        m.put(Type.MEDIUMTEXT, "MEDIUMTEXT");
        m.put(Type.LONGTEXT, "LONGTEXT");
        m.put(Type.JSON, "JSON");

        m = Dialect.MySQL5Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);//extends from MySQLDialect

        m = Dialect.MySQL55Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);//extends from MySQLDialect

        m = Dialect.MySQL57Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);//extends from MySQLDialect
        m.put(JAVA_OBJECT, "json");
        m.put(TIMESTAMP, "datetime(6)");

        m = Dialect.MySQL57InnoDBDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);//extends from MySQLDialect
        m.put(JAVA_OBJECT, "json");
        m.put(TIMESTAMP, "datetime(6)");

        m = Dialect.MySQL5InnoDBDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);//extends from MySQLDialect

        m = Dialect.MySQLInnoDBDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);//extends from MySQLDialect

        m = Dialect.MySQLMyISAMDialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);//extends from MySQLDialect

        m = Dialect.MySQL8Dialect.typeMappings;
        m.putAll(Dialect.MySQLDialect.typeMappings);//extends from MySQLDialect
        m.put(JAVA_OBJECT, "json");
        m.put(TIMESTAMP, "datetime(6)");

        //================OracleDialect family===============
        m = Dialect.OracleDialect.typeMappings;
        m.put(BIGINT, "number(19,0)");
        m.put(BIT, "number(1,0)");
        m.put(BLOB, "blob");
        m.put(CHAR, "char($l)");
        m.put(CLOB, "clob");
        m.put(DATE, "date");
        m.put(DECIMAL, "number($p,$s)");
        m.put(DOUBLE, "double");
        m.put(FLOAT, "float");
        m.put(INTEGER, "number($l,0)");
        m.put(JAVA_OBJECT, "N/A");
        m.put(LONGNVARCHAR, "nvarchar2($l)");
        m.put(NCHAR, "nchar($l)");
        m.put(NCLOB, "nclob");
        m.put(NUMERIC, "number($p,$s)");
        m.put(NVARCHAR, "nvarchar($l)");
        m.put(REAL, "real");
        m.put(SMALLINT, "number(5,0)");
        m.put(TIME, "date");
        m.put(TIMESTAMP, "timestamp");
        m.put(TINYINT, "number(3,0)");
        m.put(VARBINARY, "raw($l)<2000|long raw");
        //add new
        m.put(Type.BINARY_FLOAT, "BINARY_FLOAT");
        m.put(Type.BINARY_DOUBLE, "BINARY_DOUBLE");
        m.put(Type.DOUBLE_PRECISION, "DOUBLE PRECISION");
        m.put(Type.TIMESTAMP_WITH_TIME_ZONE, "TIMESTAMP WITH TIME ZONE");
        m.put(Type.TIMESTAMP_WITH_LOCAL_TIME_ZONE, "TIMESTAMP WITH LOCAL TIME ZONE");
        m.put(Type.INTERVAL_YEAR_TO_MONTH, "INTERVAL YEAR($l) TO MONTH");
        m.put(Type.INTERVAL_DAY_TO_SECOND, "INTERVAL DAY($p) TO SECOND($s)");
        m.put(Type.VARCHAR2, "varchar2($l)");
        m.put(Type.BINARY, "raw($l)<2000|long raw");
        m.put(Type.BOOLEAN, "number(1,0)");
        m.put(Type.LONGVARBINARY, "long raw");
        m.put(Type.LONGVARCHAR, "long");
        m.put(Type.VARCHAR, "varchar($l char)<4000|long");

        m = Dialect.Oracle10gDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);//extends from OracleDialect
        m.put(BINARY, "raw($l)<2000|long raw");
        m.put(BOOLEAN, "number(1,0)");
        m.put(CHAR, "char($l char)");
        m.put(LONGNVARCHAR, "nvarchar2($l)");
        m.put(LONGVARBINARY, "long raw");
        m.put(LONGVARCHAR, "long");
        m.put(NVARCHAR, "nvarchar2($l)");
        m.put(TIMESTAMP, "timestamp");

        m = Dialect.Oracle12cDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);//extends from OracleDialect
        m.put(BINARY, "raw($l)<2000|long raw");
        m.put(BOOLEAN, "number(1,0)");
        m.put(CHAR, "char($l char)");
        m.put(LONGNVARCHAR, "nvarchar2($l)");
        m.put(LONGVARBINARY, "long raw");
        m.put(LONGVARCHAR, "long");
        m.put(NVARCHAR, "nvarchar2($l)");
        m.put(TIMESTAMP, "timestamp");

        m = Dialect.Oracle8iDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);//extends from OracleDialect
        m.put(BINARY, "raw($l)<2000|long raw");
        m.put(BOOLEAN, "number(1,0)");
        m.put(LONGVARBINARY, "long raw");
        m.put(LONGVARCHAR, "long");

        m = Dialect.Oracle9Dialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);//extends from OracleDialect
        m.put(CHAR, "char($l char)");
        m.put(TIMESTAMP, "timestamp");

        m = Dialect.Oracle9iDialect.typeMappings;
        m.putAll(Dialect.OracleDialect.typeMappings);//extends from OracleDialect
        m.put(BINARY, "raw($l)<2000|long raw");
        m.put(BOOLEAN, "number(1,0)");
        m.put(CHAR, "char($l char)");
        m.put(LONGNVARCHAR, "nvarchar2($l)");
        m.put(LONGVARBINARY, "long raw");
        m.put(LONGVARCHAR, "long");
        m.put(NVARCHAR, "nvarchar2($l)");
        m.put(TIMESTAMP, "timestamp");

        //================PostgreSQLDialect family===============
        m = Dialect.PostgreSQLDialect.typeMappings;
        m.put(BIGINT, "int8");
        m.put(BINARY, "bytea");
        m.put(BIT, "bool");
        m.put(BLOB, "oid");
        m.put(BOOLEAN, "boolean");
        m.put(CHAR, "char(1)");
        m.put(CLOB, "text");
        m.put(DATE, "date");
        m.put(DECIMAL, "numeric($p, $s)");
        m.put(DOUBLE, "float8");
        m.put(FLOAT, "float4");
        m.put(INTEGER, "int4");
        m.put(JAVA_OBJECT, "N/A");
        m.put(LONGNVARCHAR, "nvarchar($l)");
        m.put(LONGVARBINARY, "bytea");
        m.put(LONGVARCHAR, "text");
        m.put(NCHAR, "nchar($l)");
        m.put(NCLOB, "nclob");
        m.put(NUMERIC, "numeric($p, $s)");
        m.put(NVARCHAR, "nvarchar($l)");
        m.put(REAL, "real");
        m.put(SMALLINT, "int2");
        m.put(TIME, "time");
        m.put(TIMESTAMP, "timestamp");
        m.put(TINYINT, "int2");
        m.put(VARBINARY, "bytea");
        m.put(VARCHAR, "varchar($l)");

        m = Dialect.PostgresPlusDialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);//extends from PostgreSQLDialect

        m = Dialect.PostgreSQL81Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);//extends from PostgreSQLDialect

        m = Dialect.PostgreSQL82Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);//extends from PostgreSQLDialect

        m = Dialect.PostgreSQL9Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);//extends from PostgreSQLDialect

        m = Dialect.PostgreSQL91Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);//extends from PostgreSQLDialect

        m = Dialect.PostgreSQL92Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);//extends from PostgreSQLDialect
        m.put(JAVA_OBJECT, "json");

        m = Dialect.PostgreSQL93Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);//extends from PostgreSQLDialect
        m.put(JAVA_OBJECT, "json");

        m = Dialect.PostgreSQL94Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);//extends from PostgreSQLDialect
        m.put(JAVA_OBJECT, "json");

        m = Dialect.PostgreSQL95Dialect.typeMappings;
        m.putAll(Dialect.PostgreSQLDialect.typeMappings);//extends from PostgreSQLDialect
        m.put(JAVA_OBJECT, "json");

        //================SQLServerDialect family===============
        m = Dialect.SQLServerDialect.typeMappings;
        m.put(BIGINT, "numeric(19,0)");
        m.put(BINARY, "binary($l)");
        m.put(BIT, "tinyint");
        m.put(BLOB, "image");
        m.put(BOOLEAN, "bit");
        m.put(CHAR, "char(1)");
        m.put(CLOB, "text");
        m.put(DATE, "datetime");
        m.put(DECIMAL, "numeric($p,$s)");
        m.put(DOUBLE, "double precision");
        m.put(FLOAT, "float");
        m.put(INTEGER, "int");
        m.put(JAVA_OBJECT, "N/A");
        m.put(LONGNVARCHAR, "nvarchar($l)");
        m.put(LONGVARBINARY, "image");
        m.put(LONGVARCHAR, "text");
        m.put(NCHAR, "nchar($l)");
        m.put(NCLOB, "nclob");
        m.put(NUMERIC, "numeric($p,$s)");
        m.put(NVARCHAR, "nvarchar($l)");
        m.put(REAL, "real");
        m.put(SMALLINT, "smallint");
        m.put(TIME, "datetime");
        m.put(TIMESTAMP, "datetime");
        m.put(TINYINT, "smallint");
        m.put(VARBINARY, "varbinary($l)<8000|image");
        m.put(VARCHAR, "varchar($l)");

        m = Dialect.SQLServer2005Dialect.typeMappings;
        m.putAll(Dialect.SQLServerDialect.typeMappings);//extends from SQLServerDialect
        m.put(BIGINT, "bigint");
        m.put(BIT, "bit");
        m.put(BLOB, "varbinary(MAX)");
        m.put(CLOB, "varchar(MAX)");
        m.put(LONGVARBINARY, "varbinary(MAX)");
        m.put(LONGVARCHAR, "varchar(MAX)");
        m.put(NCLOB, "nvarchar(MAX)");
        m.put(VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
        m.put(VARCHAR, "varchar($l)<8000|varchar(MAX)");

        m = Dialect.SQLServer2008Dialect.typeMappings;
        m.putAll(Dialect.SQLServerDialect.typeMappings);//extends from SQLServerDialect
        m.put(BIGINT, "bigint");
        m.put(BIT, "bit");
        m.put(BLOB, "varbinary(MAX)");
        m.put(CLOB, "varchar(MAX)");
        m.put(DATE, "date");
        m.put(LONGVARBINARY, "varbinary(MAX)");
        m.put(LONGVARCHAR, "varchar(MAX)");
        m.put(NCLOB, "nvarchar(MAX)");
        m.put(NVARCHAR, "nvarchar($l)<4000|nvarchar(MAX)");
        m.put(TIME, "time");
        m.put(TIMESTAMP, "datetime2");
        m.put(VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
        m.put(VARCHAR, "varchar($l)<8000|varchar(MAX)");

        m = Dialect.SQLServer2012Dialect.typeMappings;
        m.putAll(Dialect.SQLServerDialect.typeMappings);//extends from SQLServerDialect
        m.put(BIGINT, "bigint");
        m.put(BIT, "bit");
        m.put(BLOB, "varbinary(MAX)");
        m.put(CLOB, "varchar(MAX)");
        m.put(DATE, "date");
        m.put(LONGVARBINARY, "varbinary(MAX)");
        m.put(LONGVARCHAR, "varchar(MAX)");
        m.put(NCLOB, "nvarchar(MAX)");
        m.put(NVARCHAR, "nvarchar($l)<4000|nvarchar(MAX)");
        m.put(TIME, "time");
        m.put(TIMESTAMP, "datetime2");
        m.put(VARBINARY, "varbinary($l)<8000|varbinary(MAX)");
        m.put(VARCHAR, "varchar($l)<8000|varchar(MAX)");
    }

    protected static void initTypeConvertMapping() {

        //================SQLiteDialect family===============
        Map<String, String> m = Dialect.SQLiteDialect.typeConvertMapping;
        //================MySQLDialect family===============
        m = Dialect.MySQLDialect.typeConvertMapping;
        m.put("mi", "minute");
        m.put("yy", "year");
        m.put("hh", "hour");
        m.put("mm", "month");
        m.put("ww", "week");
        m.put("dd", "day");
        //================OracleDialect family===============
        m = Dialect.OracleDialect.typeConvertMapping;
        //================PostgreSQLDialect family===============
        m = Dialect.PostgreSQLDialect.typeConvertMapping;
        //================SQLServerDialect family===============
        m = Dialect.SQLServerDialect.typeConvertMapping;

    }
}
