/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.datasource.dialects.id;

import com.af.v4.system.common.datasource.dialects.Dialect;
import com.af.v4.system.common.datasource.dialects.Type;
import com.af.v4.system.common.datasource.dialects.enums.GenerationType;
import com.af.v4.system.common.datasource.dialects.id.IdGenerator;
import java.sql.Connection;
import java.util.concurrent.locks.ReentrantLock;

public class TimeStampIdGenerator
implements IdGenerator {
    public static final TimeStampIdGenerator INSTANCE = new TimeStampIdGenerator();
    private static long count = 1L;
    private static final ReentrantLock LOCK = new ReentrantLock();

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.TIMESTAMP;
    }

    @Override
    public String getIdGenName() {
        return "TimeStampId";
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        return TimeStampIdGenerator.getNextID();
    }

    public static Object getNextID() {
        LOCK.lock();
        try {
            if (count > 999999L) {
                count = 1L;
            }
            Long l = System.currentTimeMillis() * 1000000L + count++;
            return l;
        }
        finally {
            LOCK.unlock();
        }
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }
}

