/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.common.ai.service;

import com.af.v4.system.common.ai.entity.AiProvider;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.core.proxy.liuli.ILiuLiConfigServiceProxy;
import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatModel;
import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatOptions;
import com.alibaba.cloud.ai.dashscope.embedding.DashScopeEmbeddingModel;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.advisor.PromptChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.QuestionAnswerAdvisor;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.SimpleVectorStore;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
public class AiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiService.class);
    private static final String AI_CONFIG_NAME = "ai_config";
    private static final List<AiProvider> AI_PROVIDERS = new ArrayList<AiProvider>();
    private static String DEFAULT_PROMPT;
    private final ChatMemory chatMemory;

    public AiService(ILiuLiConfigServiceProxy liuLiConfigServiceProxy, ChatMemory chatMemory) {
        this.chatMemory = chatMemory;
        JSONObject aiOptions = liuLiConfigServiceProxy.get(AI_CONFIG_NAME);
        if (aiOptions == null) {
            LOGGER.error((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u52a0\u8f7dAi\u670d\u52a1\u5931\u8d25\uff0c\u4f7f\u7528Ai\u76f8\u5173\u63a5\u53e3\u670d\u52a1\u8bf7\u5148\u521b\u5efa[ai_config]\u914d\u7f6e"})));
            return;
        }
        JSONArray modelProviders = aiOptions.getJSONArray("modelProviders");
        if (modelProviders == null || modelProviders.isEmpty()) {
            throw new ServiceException((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"[ai_config]\u914d\u7f6e\u91cc\u6ca1\u6709\u5b9a\u4e49\u4efb\u4f55\u6a21\u578b\u4f9b\u5e94\u5546"})));
        }
        modelProviders.forEach(item -> {
            JSONObject modelProvider = (JSONObject)item;
            String modelProviderName = modelProvider.getString("name");
            JSONObject models = modelProvider.getJSONObject("models");
            JSONArray apiKeys = modelProvider.getJSONArray("apiKeys");
            AiProvider aiProvider = new AiProvider(modelProviderName, models, apiKeys);
            AI_PROVIDERS.add(aiProvider);
        });
        String prompt = aiOptions.optString("defaultPrompt", null);
        DEFAULT_PROMPT = prompt != null && !prompt.isEmpty() ? prompt : "{value}";
    }

    public ChatClient buildChatClient(String modelName, String customizePrompt, boolean isUseWebSearch) {
        AiProvider aiProvider = AI_PROVIDERS.stream().filter(item -> item.models().has(modelName)).findFirst().orElseThrow(() -> new ServiceException("[ai_config]\u914d\u7f6e\u91cc\u6ca1\u6709\u63d0\u4f9b\u8be5\u6a21\u578b\uff1a" + modelName));
        JSONArray apiKeys = aiProvider.apiKeys();
        if (apiKeys == null || apiKeys.isEmpty()) {
            throw new ServiceException("Ai\u6a21\u578b[" + modelName + "]\u4e2d\u6ca1\u6709\u8bbe\u7f6eApiKey");
        }
        String apiKey = apiKeys.get(ThreadLocalRandom.current().nextInt(apiKeys.length())).toString();
        DashScopeApi dashScopeApi = new DashScopeApi(apiKey);
        DashScopeChatModel chatModel = new DashScopeChatModel(dashScopeApi);
        ChatClient.Builder builder = ChatClient.builder((ChatModel)chatModel);
        DashScopeChatOptions chatOptions = new DashScopeChatOptions();
        chatOptions.setModel(modelName);
        boolean isSupportWebSearch = ((JSONObject)aiProvider.models().get(modelName)).optBoolean("isSupportWebSearch", true);
        if (isSupportWebSearch) {
            chatOptions.setEnableSearch(Boolean.valueOf(isUseWebSearch));
        }
        DashScopeEmbeddingModel embeddingModel = new DashScopeEmbeddingModel(dashScopeApi);
        SimpleVectorStore vectorStore = SimpleVectorStore.builder((EmbeddingModel)embeddingModel).build();
        String prompt = DEFAULT_PROMPT;
        return builder.defaultOptions((ChatOptions)chatOptions).defaultSystem(promptSystemSpec -> {
            promptSystemSpec.text(prompt);
            promptSystemSpec.param("value", (Object)(customizePrompt == null ? "" : customizePrompt));
        }).defaultAdvisors(new Advisor[]{new PromptChatMemoryAdvisor(this.chatMemory), new QuestionAnswerAdvisor((VectorStore)vectorStore)}).build();
    }

    public ChatClient buildChatClient(String modelName, String customizePrompt) {
        return this.buildChatClient(modelName, customizePrompt, false);
    }

    public ChatClient buildChatClient(String modelName) {
        return this.buildChatClient(modelName, null);
    }

    public Flux<String> chat(ChatClient client, String chatId, String userMessage) {
        return client.prompt().user(this.formatText(userMessage)).advisors(a -> a.param("chat_memory_conversation_id", (Object)chatId).param("chat_memory_response_size", (Object)100)).stream().content();
    }

    public String syncChat(ChatClient client, String chatId, String userMessage) {
        return client.prompt().user(this.formatText(userMessage)).advisors(a -> a.param("chat_memory_conversation_id", (Object)chatId).param("chat_memory_response_size", (Object)100)).call().content();
    }

    private String formatText(String userMessage) {
        return userMessage.replace("{", "\\{").replace("}", "\\}");
    }
}

