package com.af.v4.system.api.factory;

import com.af.v4.system.api.RemoteUserService;
import com.af.v4.system.api.domain.SysUser;
import com.af.v4.system.api.model.LoginUser;
import com.af.v4.system.common.core.domain.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 用户服务降级处理
 */
@Component
public class RemoteUserFallbackFactory implements FallbackFactory<RemoteUserService> {
    private static final Logger log = LoggerFactory.getLogger(RemoteUserFallbackFactory.class);

    @Override
    public RemoteUserService create(Throwable throwable) {
        log.error("用户服务调用失败", throwable);
        return new RemoteUserService() {
            @Override
            public R<LoginUser> getUserInfo(String username, String resourceName, boolean isMobile, String source) {
                return R.fail(STR."获取用户失败:\{throwable.getMessage()}");
            }

            @Override
            public R<Map<String, Object>> logout(String source) {
                return R.fail(STR."用户登出失败:\{throwable.getMessage()}");
            }

            @Override
            public R<Boolean> registerUserInfo(SysUser sysUser, String source) {
                return R.fail(STR."注册用户失败:\{throwable.getMessage()}");
            }

            @Override
            public R<LoginUser> getWxUserInfo(String openid, String resourceName, boolean isMobile, String source) {
                return R.fail(STR."微信标识获取用户失败:\{throwable.getMessage()}");
            }

            @Override
            public R<LoginUser> unifiedLogin(String data, String source) {
                return R.fail(STR."统一认证登录获取用户失败:\{throwable.getMessage()}");
            }

            @Override
            public R<LoginUser> ssoLogin(String data, String source) {
                return R.fail(STR."SSO单点登录获取用户失败:\{throwable.getMessage()}");
            }

            @Override
            public R<LoginUser> getExternalUserInfo(String platformType, String platformUserId, String tenantName,
                    String resourceName, boolean isMobile, String source) {
                return R.fail(STR."获取外部用户信息失败:\{throwable.getMessage()}");
            }

            @Override
            public R<LoginUser> autoRegisterExternalUser(String registerData, String source) {
                return R.fail(STR."外部用户自动注册失败:\{throwable.getMessage()}");
            }

            @Override
            public R<Map<String, Object>> authInfo(String authData, String source) {
                return R.fail(STR."第三方平台认证失败:\{throwable.getMessage()}");
            }

            @Override
            public R<Boolean> recordSession(String sessionData, String source) {
                return R.fail(STR."记录会话失败:\{throwable.getMessage()}");
            }

        };
    }
}
