package com.af.v4.system.api.factory;

import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.api.RemoteLiuLiService;
import com.af.v4.system.api.RemoteLogicService;
import org.springframework.cloud.openfeign.FeignClientBuilder;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@Component
public class DynamicFeignClientFactory<T> {

    private static final ReentrantLock LOCK = new ReentrantLock();

    private final FeignClientBuilder feignClientBuilder;

    private final Map<String, T> FEIGN_CLIENT_MAP = new HashMap<>();

    public DynamicFeignClientFactory(ApplicationContext appContext) {
        this.feignClientBuilder = new FeignClientBuilder(appContext);
    }

    private static <T> FeignClientFactoryBean getFeignClientFactoryBean(Class<T> type, String key) {
        FeignClientFactoryBean feignClientFactoryBean = new FeignClientFactoryBean();
        feignClientFactoryBean.setContextId(key);
        if (type == RemoteLogicService.class) {
            feignClientFactoryBean.setFallbackFactory(RemoteLogicFallbackFactory.class);
        } else if (type == RemoteEntityService.class) {
            feignClientFactoryBean.setFallbackFactory(RemoteEntityFallbackFactory.class);
        } else if (type == RemoteLiuLiService.class) {
            feignClientFactoryBean.setFallbackFactory(RemoteLiuLiFallbackFactory.class);
        }
        return feignClientFactoryBean;
    }

    public T getFeignClient(final Class<T> type, String serviceId) {
        String key = STR."\{type.getName()}:\{serviceId}";
        T t = FEIGN_CLIENT_MAP.get(key);
        if (t == null) {
            LOCK.lock();
            try {
                t = FEIGN_CLIENT_MAP.get(key);
                if (t == null) {
                    FeignClientFactoryBean feignClientFactoryBean = getFeignClientFactoryBean(type, key);
                    t = this.feignClientBuilder.forType(type, feignClientFactoryBean, serviceId).build();
                    FEIGN_CLIENT_MAP.put(STR."\{type.getName()}:\{serviceId}", t);
                }
            } finally {
                LOCK.unlock();
            }
        }
        return t;
    }
}
