/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.api.factory;

import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.api.RemoteLiuLiService;
import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.api.factory.RemoteEntityFallbackFactory;
import com.af.v4.system.api.factory.RemoteLiuLiFallbackFactory;
import com.af.v4.system.api.factory.RemoteLogicFallbackFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.cloud.openfeign.FeignClientBuilder;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DynamicFeignClientFactory<T> {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private final FeignClientBuilder feignClientBuilder;
    private final Map<String, T> FEIGN_CLIENT_MAP = new HashMap<String, T>();

    public DynamicFeignClientFactory(ApplicationContext appContext) {
        this.feignClientBuilder = new FeignClientBuilder(appContext);
    }

    private static <T> FeignClientFactoryBean getFeignClientFactoryBean(Class<T> type, String key) {
        FeignClientFactoryBean feignClientFactoryBean = new FeignClientFactoryBean();
        feignClientFactoryBean.setContextId(key);
        if (type == RemoteLogicService.class) {
            feignClientFactoryBean.setFallbackFactory(RemoteLogicFallbackFactory.class);
        } else if (type == RemoteEntityService.class) {
            feignClientFactoryBean.setFallbackFactory(RemoteEntityFallbackFactory.class);
        } else if (type == RemoteLiuLiService.class) {
            feignClientFactoryBean.setFallbackFactory(RemoteLiuLiFallbackFactory.class);
        }
        return feignClientFactoryBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getFeignClient(Class<T> type, String serviceId) {
        String key = type.getName() + ":" + serviceId;
        Object t = this.FEIGN_CLIENT_MAP.get(key);
        if (t == null) {
            LOCK.lock();
            try {
                t = this.FEIGN_CLIENT_MAP.get(key);
                if (t == null) {
                    FeignClientFactoryBean feignClientFactoryBean = DynamicFeignClientFactory.getFeignClientFactoryBean(type, key);
                    t = this.feignClientBuilder.forType(type, feignClientFactoryBean, serviceId).build();
                    this.FEIGN_CLIENT_MAP.put(type.getName() + ":" + serviceId, t);
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return t;
    }
}

