/*
 * Decompiled with CFR 0.152.
 */
package com.aote.workflow.plugin;

import com.aote.rs.Server;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.workflow.perform.ActivityDef;
import com.aote.workflow.perform.DiversionDef;
import com.aote.workflow.perform.ProcessDef;
import com.aote.workflow.perform.ProcessInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkFlowLogicServer {
    @Autowired
    private SqlServer sqlServer;

    public void setService(Session session) {
        Server server = new Server();
        server.setAssignedSession(session);
    }

    public void setServiceBySqlServer(SqlServer sql) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
    }

    public String startWorkFlow(String name, String username, String userid, JSONObject personExpression) {
        JSONArray arr = new JSONArray();
        String personExpressionArr = arr.put((Object)personExpression).toString();
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        String process = server.txstartProcess(name, username, userid, personExpressionArr);
        return process;
    }

    public String startWorkflow(String name) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        String result = server.txstartProcess(name);
        return result;
    }

    public String startActivity(String processid, String name) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        String result = server.txstartActivity(processid, name);
        return result;
    }

    public int startActivity(String processid, String name, String username, String userid) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        int result = server.txstartActivity(processid, name, username, userid);
        return result;
    }

    public int startActivity(String processid, String name, JSONObject vars, String username, String userid) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        int result = server.txstartActivity(processid, name, vars.toString(), username, userid);
        return result;
    }

    public void setVars(String processid, String vars) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        server.ttxsetVars(processid, vars);
    }

    public void setVars(String processid, String vars, String username, String userid) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        server.txsetVars(processid, vars, username, userid);
    }

    public void setVars(String processid, JSONObject json) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        server.ttxsetVars(processid, json.toString());
    }

    public JSONObject setVars(String processid, JSONObject json, String username, String userid) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        return server.ttxsetVars(processid, json.toString(), username, userid);
    }

    public JSONObject setVars(String defid, String processid, JSONObject json, String username, String userid) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        return server.ttxsetVars(defid, processid, json.toString(), username, userid);
    }

    public JSONObject setVars(int actid, String processid, JSONObject json, String username, String userid) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        return server.ttxsetVars(actid, processid, json.toString(), username, userid);
    }

    public String getAction(String activityId) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        return server.txgetAction(activityId);
    }

    public String getWait(String processid) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        return server.txgetWait(processid);
    }

    public String getWFGraph(String processid) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        return server.txgetWFGraph(processid);
    }

    public JSONObject getWFGraph(String processid, Integer width, Integer levelHeight, String nodeType, String edgeType) throws Exception {
        Session session = SessionPool.getInstance().getSession();
        ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
        ProcessDef pdef = procIns.getDefine();
        ActivityDef act = pdef.getStartActivity();
        HashMap<Integer, ArrayList<String>> levelCount = new HashMap<Integer, ArrayList<String>>();
        this.getLevelCount(act, 1, levelCount);
        JSONObject res = new JSONObject();
        JSONArray nodes = new JSONArray();
        JSONArray edges = new JSONArray();
        res = this.getNodes(nodes, edges, processid, act, width, levelHeight, nodeType, edgeType, 1, levelCount);
        return res;
    }

    public JSONObject getNodes(JSONArray nodes, JSONArray edges, String processid, ActivityDef act, int width, Integer levelHeight, String nodeType, String edgeType, Integer level, HashMap<Integer, ArrayList<String>> map) throws Exception {
        ArrayList<String> list = map.get(level);
        int levelCount = list.size();
        int index = list.indexOf(act.getID()) + 1;
        JSONObject node = new JSONObject();
        node.put("id", (Object)act.getID());
        node.put("type", (Object)nodeType);
        node.put("text", (Object)act.getName());
        node.put("x", width * (2 * index - 1) / (2 * levelCount));
        node.put("y", levelHeight * level);
        JSONArray jsonArray = this.sqlServer.query("select * from activityins where processid = '" + processid + "' and defid = '" + act.getID() + "' order by id desc");
        node.put("properties", (Object)jsonArray);
        if (!WorkFlowLogicServer.isRepeat(nodes, node)) {
            nodes.put((Object)node);
        }
        for (int i = 0; i < act.getSplits().size(); ++i) {
            JSONObject edge = new JSONObject();
            DiversionDef divDef = act.getSplits().get(i);
            ActivityDef tailDef = divDef.getTail();
            edge.put("id", (Object)divDef.getID());
            edge.put("type", (Object)edgeType);
            edge.put("sourceNodeId", (Object)act.getID());
            edge.put("targetNodeId", (Object)tailDef.getID());
            if (!WorkFlowLogicServer.isRepeat(edges, edge)) {
                edges.put((Object)edge);
            }
            this.getNodes(nodes, edges, processid, tailDef, width, levelHeight, nodeType, edgeType, level + 1, map);
        }
        JSONObject obj = new JSONObject();
        obj.put("edges", (Object)edges);
        obj.put("nodes", (Object)nodes);
        return obj;
    }

    public HashMap<Integer, ArrayList<String>> getLevelCount(ActivityDef act, Integer level, HashMap<Integer, ArrayList<String>> map) {
        ArrayList<Object> list;
        if (map.containsKey(level)) {
            list = map.get(level);
            if (list.indexOf(act.getID()) == -1) {
                list.add(act.getID());
                map.put(level, list);
            }
        } else {
            list = new ArrayList();
            list.add(act.getID());
            map.put(level, list);
        }
        for (int i = 0; i < act.getSplits().size(); ++i) {
            DiversionDef divDef = act.getSplits().get(i);
            ActivityDef tailDef = divDef.getTail();
            this.getLevelCount(tailDef, level + 1, map);
        }
        return map;
    }

    public static boolean isRepeat(JSONArray jsonArray, JSONObject object) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (!object.get("id").toString().equals(jsonArray.getJSONObject(i).get("id").toString())) continue;
            return true;
        }
        return false;
    }

    public String excuteWorkFlow(String acitityid, String username, String userid, JSONObject personExpression) {
        JSONArray arr = new JSONArray();
        String personExpressionArr = arr.put((Object)personExpression).toString();
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        String process = server.txperformActivity(acitityid.toString(), username, userid, personExpressionArr);
        return process;
    }

    public String stopWorkFlow(String acitityid) {
        Server server = new Server();
        Session session = SessionPool.getInstance().getSession();
        server.setAssignedSession(session);
        String process = server.txStopProcess(acitityid);
        return process;
    }

    public String getOperator(String actorexpression) {
        if (actorexpression.indexOf("userid") != -1) {
            String sub = actorexpression.substring(actorexpression.indexOf("userid"));
            return sub.substring(sub.indexOf("'") + 1, sub.lastIndexOf("'"));
        }
        if (actorexpression.indexOf("(") != -1 && actorexpression.length() > 3) {
            return actorexpression.substring(actorexpression.indexOf("(") + 1, actorexpression.indexOf(")"));
        }
        return "";
    }
}

