/*
 * Decompiled with CFR 0.152.
 */
package com.aote.workflow.perform;

import com.aote.ThreadResource;
import com.aote.workflow.perform.Diagram;
import com.aote.workflow.perform.ProcessDefManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class DiagramManager {
    static Logger log = Logger.getLogger(DiagramManager.class);
    private static final long serialVersionUID = 373843474314241569L;
    private static DiagramManager instance = new DiagramManager();
    private Hashtable nameAndDiagrams = new Hashtable();

    public static DiagramManager getInstance() {
        return instance;
    }

    public DiagramManager() {
        this.load();
    }

    public void load() {
        File[] files;
        URL url = this.getClass().getClassLoader().getResource("processes/");
        log.info((Object)("========>\u8def\u5f84>" + url.toString()));
        if (url == null) {
            return;
        }
        String path = url.getPath();
        for (File f : files = new File(path).listFiles()) {
            String fileName = f.getName();
            if (fileName == null) continue;
            try {
                String digName = fileName.substring(0, fileName.indexOf("."));
                Diagram diagram = new Diagram();
                diagram.setName(digName);
                this.nameAndDiagrams.put(digName, diagram);
                String result = "";
                String encoding = "UTF-8";
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(f), encoding);
                BufferedReader bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    result = result + lineTxt;
                }
                int index = result.indexOf("<");
                if (index != -1) {
                    result = result.substring(index);
                }
                bufferedReader.close();
                diagram.setContext(result);
            }
            catch (Exception e) {
                log.error((Object)("\u6d41\u7a0b" + fileName + ": " + e.getMessage()));
            }
        }
    }

    public void load(String loadPath) {
        String path = "";
        if (loadPath == null || "".equals(loadPath)) {
            return;
        }
        File files = new File(loadPath);
        if (!files.isFile()) {
            return;
        }
        String fileName = files.getName();
        System.out.println("file name" + fileName);
        try {
            String digName = fileName.substring(0, fileName.indexOf("."));
            Diagram diagram = new Diagram();
            diagram.setName(digName);
            this.nameAndDiagrams.put(digName, diagram);
            String result = "";
            String encoding = "UTF-8";
            InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(files), encoding);
            BufferedReader bufferedReader = new BufferedReader(read);
            String lineTxt = null;
            while ((lineTxt = bufferedReader.readLine()) != null) {
                result = result + lineTxt;
            }
            bufferedReader.close();
            diagram.setContext(result);
        }
        catch (Exception e) {
            log.error((Object)("\u6d41\u7a0b" + fileName + ": " + e.getMessage()));
        }
    }

    public Diagram userLoad(String userUrl) {
        URL url = this.getClass().getClassLoader().getResource(userUrl);
        String path = url.getPath();
        File file = new File(path);
        String fileName = file.getName();
        try {
            String digName = fileName.substring(0, fileName.indexOf("."));
            Diagram diagram = new Diagram();
            diagram.setName(digName);
            String result = "";
            String encoding = "UTF-8";
            InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            BufferedReader bufferedReader = new BufferedReader(read);
            String lineTxt = null;
            while ((lineTxt = bufferedReader.readLine()) != null) {
                result = result + lineTxt;
            }
            bufferedReader.close();
            diagram.setContext(result);
            return diagram;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d41\u7a0b" + fileName + ": " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadResources(URL url, String path) {
        ArrayList<String> strs = new ArrayList<String>();
        int statu = 0;
        try {
            System.out.println(url);
            URL jarURL = new URL(url.toString().substring(0, url.toString().indexOf("!/") + 2));
            JarURLConnection jarCon = (JarURLConnection)jarURL.openConnection();
            JarFile jarFile = jarCon.getJarFile();
            Enumeration<JarEntry> jarEntrys = jarFile.entries();
            while (jarEntrys.hasMoreElements() && statu != 2) {
                JarEntry entry = null;
                try {
                    entry = jarEntrys.nextElement();
                }
                catch (Exception e) {
                    break;
                }
                String name = entry.getName();
                if (name.startsWith(path) && !entry.isDirectory()) {
                    if (statu == 0) {
                        statu = 1;
                    }
                    BufferedInputStream biput = null;
                    try {
                        byte[] buffer = new byte[(int)entry.getSize()];
                        biput = new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(name));
                        biput.read(buffer, 0, buffer.length);
                        String str = new String(buffer, "UTF-8");
                        strs.add(str);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    finally {
                        if (biput != null) {
                            biput.close();
                        }
                        continue;
                    }
                }
                if (statu != 1) continue;
                statu = 2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return strs;
    }

    public Enumeration getDiagrams() throws RemoteException {
        return this.nameAndDiagrams.elements();
    }

    public LinkedList getDiagramNames() throws RemoteException {
        return new LinkedList(this.nameAndDiagrams.keySet());
    }

    public Diagram getDiagramByName(String name) throws RemoteException {
        return (Diagram)this.nameAndDiagrams.get(name);
    }

    public Diagram getUserDiagramByName(String name) {
        String dir = (String)ThreadResource.ComponentDir.get();
        String path = null;
        path = dir == null ? "processes/" + name + ".xml" : dir + "/processes/" + name + ".xml";
        if (ProcessDefManager.class.getClassLoader().getResourceAsStream(path) == null) {
            return null;
        }
        Diagram diagram = this.userLoad(path);
        return diagram;
    }
}

