/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.transaction.SessionPool;
import com.aote.workflow.perform.ActivityDef;
import com.aote.workflow.perform.ActivityInstance;
import com.aote.workflow.perform.DiversionDef;
import com.aote.workflow.perform.PersonService;
import com.aote.workflow.perform.ProcessDef;
import com.aote.workflow.perform.ProcessDefManager;
import com.aote.workflow.perform.ProcessInstance;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Element;

@Path(value="workflow")
@Singleton
@Component
@Transactional
public class Server {
    @Autowired
    private SessionPool sessionPool;
    public Session assignedSession;

    public void setAssignedSession(Session session) {
        this.assignedSession = session;
    }

    @GET
    @Path(value="startprocess/{name}")
    public String txstartProcess(@PathParam(value="name") String name) {
        try {
            ProcessDef process = ProcessDefManager.getInstance().getProcessDef(name);
            if (process == null) {
                throw new RuntimeException("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff1a\u540d\u5b57=" + name);
            }
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            String processId = UUID.randomUUID().toString();
            ProcessInstance procIns = process.createInstance(session, processId);
            return procIns.getId();
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="startactivity/{processid}/{name}")
    public String txstartActivity(@PathParam(value="processid") String processid, @PathParam(value="name") String name) {
        try {
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
            ProcessDef process = procIns.getDefine();
            ActivityDef activity = process.getActivityByName(name);
            ActivityInstance actIns = new ActivityInstance(activity, procIns, "", null, null, null);
            session.save((Object)actIns);
            return actIns.getId() + "";
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="startactivity/{processid}/{name}/{username}/{userid}")
    public int txstartActivity(@PathParam(value="processid") String processid, @PathParam(value="name") String name, @PathParam(value="username") String username, @PathParam(value="userid") String userid) {
        try {
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
            ProcessDef process = procIns.getDefine();
            ActivityDef activity = process.getActivityByName(name);
            String exp = activity.getPersonExpression();
            ActivityInstance actIns = new ActivityInstance(activity, procIns, activity.getPersonExpression(), username, userid, null);
            JSONObject org = ActivityInstance.getOrgs(null, userid);
            actIns.setSenderOrg(org.getString("name"));
            actIns.setSenderOrgid(org.getString("id"));
            actIns.setFinishOrg(org.getString("name"));
            actIns.setFinishOrgid(org.getString("id"));
            exp = (String)actIns.getProcess().getExpressionValue("$" + exp);
            PersonService.Run(org.getString("name"), exp, session, username, userid);
            session.save((Object)actIns);
            return actIns.getId();
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="startactivity/{processid}/{name}/{vars}/{username}/{userid}")
    public int txstartActivity(@PathParam(value="processid") String processid, @PathParam(value="name") String name, @PathParam(value="vars") String vars, @PathParam(value="username") String username, @PathParam(value="userid") String userid) {
        try {
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
            procIns.putVar(new JSONObject(vars));
            ProcessDef process = procIns.getDefine();
            ActivityDef activity = process.getActivityByName(name);
            String exp = activity.getPersonExpression();
            exp = (String)procIns.getExpressionValue("$" + exp);
            JSONObject org = ActivityInstance.getOrgs(null, userid);
            PersonService.Run(org.getString("name"), exp, session, username, userid);
            String actorExp = PersonService.getActorid(exp);
            ActivityInstance actIns = new ActivityInstance(activity, procIns, actorExp, username, userid, null);
            actIns.setSenderOrg(org.getString("name"));
            actIns.setSenderOrgid(org.getString("id"));
            actIns.setFinishOrg(org.getString("name"));
            actIns.setFinishOrgid(org.getString("id"));
            session.save((Object)actIns);
            return actIns.getId();
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="setvars/{processid}/{username}/{userid}")
    public String txsetVars(@PathParam(value="processid") String processid, String vars, @PathParam(value="username") String username, @PathParam(value="userid") String userid) {
        this.ttxsetVars(processid, vars, username, userid);
        return "ok";
    }

    public JSONObject ttxsetVars(String defid, String processid, String vars, String username, String userid) {
        try {
            JSONObject jsob = new JSONObject();
            JSONObject json = new JSONObject(vars);
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
            procIns.putVar(json);
            ActivityInstance act = procIns.getActivitiesByDefid(defid);
            jsob = act.finish(session, username, userid);
            return jsob;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject ttxsetVars(int actid, String processid, String vars, String username, String userid) {
        try {
            JSONObject jsob = new JSONObject();
            JSONObject json = new JSONObject(vars);
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
            procIns.putVar(json);
            ActivityInstance act = procIns.getActivitiesByActid(actid);
            jsob = act.finish(session, username, userid);
            return jsob;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject ttxsetVars(String processid, String vars, String username, String userid) {
        try {
            JSONObject jsob = new JSONObject();
            JSONObject json = new JSONObject(vars);
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
            procIns.putVar(json);
            for (Object obj : procIns.getActivitiesByState("\u5f00\u59cb\u6d3b\u52a8")) {
                ActivityInstance actIns = (ActivityInstance)obj;
                jsob = actIns.finish(session, username, userid);
            }
            return jsob;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject ttxsetVars(String processid, String vars) {
        try {
            JSONObject jsob = new JSONObject();
            JSONObject json = new JSONObject(vars);
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
            procIns.putVar(json);
            for (Object obj : procIns.getActivitiesByState("\u5f00\u59cb\u6d3b\u52a8")) {
                ActivityInstance actIns = (ActivityInstance)obj;
                jsob = actIns.finish(session);
            }
            return jsob;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="getwait/{processid}")
    public String txgetWait(@PathParam(value="processid") String processid) {
        JSONArray result = new JSONArray();
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
        for (Object obj : procIns.getActivitiesByState("\u5f00\u59cb\u6d3b\u52a8")) {
            JSONObject json = new JSONObject();
            ActivityInstance actIns = (ActivityInstance)obj;
            json.put("defid", (Object)actIns.getDefid());
            json.put("defname", (Object)actIns.getDefname());
            result.put((Object)json);
        }
        return result.toString();
    }

    @GET
    @Path(value="getWFGraph/{processid}")
    public String txgetWFGraph(@PathParam(value="processid") String processid) {
        JSONObject res = new JSONObject();
        JSONArray spotlist = new JSONArray();
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        ProcessInstance procIns = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)((Object)processid));
        for (Object obj : procIns.getAllActivities()) {
            ActivityInstance actIns = (ActivityInstance)obj;
            spotlist.put((Object)actIns.getJson());
        }
        res.put("spots", (Object)this.getSpots(procIns));
        res.put("lines", (Object)this.getLines(procIns));
        return res.toString();
    }

    public JSONArray getSpots(ProcessInstance procIns) {
        HashMap<String, JSONObject> spotmap = new HashMap<String, JSONObject>();
        JSONArray Spots = new JSONArray();
        ProcessDef pdef = procIns.getDefine();
        for (Object obj : procIns.getAllActivities()) {
            ActivityInstance actIns = (ActivityInstance)obj;
            JSONObject json = actIns.getJson();
            if (spotmap.containsKey(json.getString("defid"))) continue;
            spotmap.put(json.getString("defid"), json);
        }
        for (Object obj : pdef.getActivities()) {
            JSONObject json = new JSONObject();
            ActivityDef act = (ActivityDef)obj;
            json.put("defid", (Object)act.getID());
            json.put("defname", (Object)act.getName());
            json.put("state", (Object)"\u672a\u6267\u884c");
            if (spotmap.containsKey(json.getString("defid"))) continue;
            spotmap.put(json.getString("defid"), json);
        }
        Iterator it = spotmap.values().iterator();
        while (it.hasNext()) {
            Spots.put((Object)((JSONObject)it.next()));
        }
        return Spots;
    }

    public JSONArray getLines(ProcessInstance procIns) {
        JSONArray Lines = new JSONArray();
        ProcessDef pdef = procIns.getDefine();
        for (Object obj : pdef.getDiversions()) {
            DiversionDef diversion = (DiversionDef)obj;
            JSONObject json = new JSONObject();
            json.put("start", (Object)diversion.getHead().getID());
            json.put("end", (Object)diversion.getTail().getID());
            Lines.put((Object)json);
        }
        return Lines;
    }

    @POST
    @Path(value="startprocess/{name}/{username}/{userid}")
    public String txstartProcess(@PathParam(value="name") String name, @PathParam(value="username") String username, @PathParam(value="userid") String userid, String personExpression) {
        try {
            JSONArray array = new JSONArray(personExpression);
            JSONObject firstObj = array.getJSONObject(0);
            String data = firstObj.getString("data");
            JSONObject dataObj = new JSONObject(data);
            String processId = dataObj.getString("id");
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessDef process = ProcessDefManager.getInstance().getProcessDef(name);
            if (process == null) {
                throw new RuntimeException("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff1a\u540d\u5b57=" + name);
            }
            ActivityDef activity = process.getStartActivity();
            if (activity == null) {
                throw new RuntimeException("\u6d41\u7a0b\u6ca1\u6709\u5f00\u59cb\u6d3b\u52a8\uff1a\u540d\u5b57=" + name);
            }
            ProcessInstance procIns = process.createInstance(session, processId);
            ActivityInstance actIns = new ActivityInstance(activity, procIns, "", username, userid, null);
            session.save((Object)actIns);
            actIns.finish(session, personExpression, username, userid);
            JSONObject okObject = new JSONObject();
            okObject.put("ok", (Object)"ok");
            return okObject.toString();
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="startWork/{name}/{username}/{userid}")
    public String txstartWork(@PathParam(value="name") String name, @PathParam(value="username") String username, @PathParam(value="userid") String userid, String personExpression) {
        try {
            JSONObject dataObj = new JSONObject(personExpression);
            String processId = dataObj.getString("id");
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ProcessDef process = ProcessDefManager.getInstance().getProcessDef(name);
            if (process == null) {
                throw new RuntimeException("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff1a\u540d\u5b57=" + name);
            }
            ActivityDef activity = process.getStartActivity();
            if (activity == null) {
                throw new RuntimeException("\u6d41\u7a0b\u6ca1\u6709\u5f00\u59cb\u6d3b\u52a8\uff1a\u540d\u5b57=" + name);
            }
            ProcessInstance procIns = process.createInstance(session, processId);
            ActivityInstance actIns = new ActivityInstance(activity, procIns, "", username, userid, null);
            session.save((Object)actIns);
            JSONObject result = new JSONObject();
            result.put("procIns", (Object)procIns.getId());
            result.put("actIns", actIns.getId());
            result.put("actName", (Object)actIns.getName());
            return result.toString();
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="perfomactivity/{acitityid}/{username}/{userid}")
    public String txperformActivity(@PathParam(value="acitityid") String acitityid, @PathParam(value="username") String username, @PathParam(value="userid") String userid, String personExpression) {
        try {
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ActivityInstance actIns = (ActivityInstance)session.load(ActivityInstance.class, (Serializable)((Object)acitityid));
            actIns.finish(session, personExpression, username, userid);
            if (actIns.getState().equals("\u7ed3\u675f")) {
                JSONObject error = new JSONObject();
                error.put("error", (Object)"\u5df2\u7ed3\u675f");
                return error.toString();
            }
            JSONObject okObject = new JSONObject();
            okObject.put("ok", (Object)"ok");
            return okObject.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="action/{acitityid}")
    public String txgetAction(@PathParam(value="acitityid") String acitityid) {
        Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
        ActivityInstance actIns = (ActivityInstance)session.load(ActivityInstance.class, (Serializable)Integer.valueOf(Integer.parseInt(acitityid)));
        Element e = actIns.getDefine().getElement();
        if (e.hasAttribute("action")) {
            return e.getAttribute("action");
        }
        return "";
    }

    @POST
    @Path(value="stop/{acitityid}")
    public String txStopProcess(@PathParam(value="acitityid") String acitityid) {
        try {
            Session session = this.assignedSession == null ? this.sessionPool.getSession() : this.assignedSession;
            ActivityInstance actIns = (ActivityInstance)session.load(ActivityInstance.class, (Serializable)((Object)acitityid));
            ProcessInstance pi = actIns.getProcess();
            List list = pi.getActivitiesByState("\u5f00\u59cb\u6d3b\u52a8");
            for (ActivityInstance act : list) {
                act.setState("\u7ec8\u6b62\u05b9");
                session.update((Object)act);
            }
            pi.stop();
            session.update((Object)pi);
            JSONObject result = new JSONObject();
            result.put("procIns", (Object)(pi == null ? null : pi.getName()));
            result.put("actIns", (Object)(actIns == null ? null : actIns.getName()));
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

