package com.aote.workflow.perform;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.*;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

import com.af.plugins.RestTools;

//临时产生人员映射关系
public class PersonService {

	public static void Run(String personExpression, Session session, String username, String userid) {

		if("".equals(personExpression)){
			return;
		}

		Map actor = new HashMap();

		// 获得实际人员表达式，personExpression有可能是给ldap表达式，与实际不同
		String realPerson = getActorid(personExpression);

		// 查询当前表达式及对应人员
		actor = (HashMap)session.get("t_actor", realPerson);

		// 如果存在直接删除
		if (actor != null) {
			session.delete(actor);
		} else {
			actor = new HashMap();
			actor.put("id", realPerson);
		}

		// 表达式对应人员
		Set persons = new HashSet();
		String name = new String();
		String str = new String();
		// 人员 传入id
		if (personExpression.startsWith("PI")) {
			// 人员id
			name = personExpression.substring(3,
					personExpression.length() - 1);
			str = "{source: 'this', userid: '" + name +"'}";
			persons=getPerson(persons,str);
//			sessionDel(session, personExpression);
		}
		// 如果是人员 传入用户名
		if (personExpression.startsWith("P")) {
			name = personExpression.substring(2,
					personExpression.length() - 1);
			Map map = new HashMap<String, String>();
			map.put("userid", name);
			map.put("userseq", name);
			persons.add(map);
		}
		// 是部门
		else if (personExpression.startsWith("D")) {
			name = personExpression.substring(2,
					personExpression.length() - 1);
			str = "{source: 'this.getParentByType($organization$).getChildByName($"+ name + "$).getChildren()', userid: '" + userid +"'}";
			persons=getPerson(persons,str);
//			sessionDel(session, personExpression);
		}
		// 是ID数组，暂定部门
		else if (personExpression.startsWith("I")) {
			name = personExpression.substring(2,
					personExpression.length() - 1);
			String ids[]=name.split(",");
			persons=getPersonList(persons,ids);
//			sessionDel(session, personExpression);
		}
		// 是角色数组
		else if (personExpression.startsWith("RS")) {
			name = personExpression.substring(3,
					personExpression.length() - 1);
			String[] roles = name.split(",");
			for (String role: roles) {
				str = "{source: 'this.getParentByType($organization$).getChildByName($"+ role + "$).getChildren()', userid: '" + userid +"'}";
				persons = getPerson(persons,str);
			}
//			sessionDel(session, personExpression);
		}
		// 是角色
		else if (personExpression.startsWith("R")) {
			name = personExpression.substring(2,
					personExpression.length() - 1);
			str = "{source: 'this.getParentByType($organization$).getChildByName($"+ name + "$).getChildren()', userid: '" + userid +"'}";
			persons=getPerson(persons,str);
//			sessionDel(session, personExpression);
		}
		 else {
			//非R非P
			//对表达式字符串进行转义
			personExpression=getExpression(personExpression);
			persons=getPerson(persons,personExpression);
			//删除数据库中已存在的数据
//			sessionDel(session,realPerson);
		}
		actor.put("f_person", persons);
		//放入资源类型【id或者是名称】
		actor.put("res", name);
		//保存数据到数据库
		// 防止并行节点人员表达式一样，导致同一session中存在多个id相同数据
		if (session.get("t_actor", actor.get("id").toString()) != null) {
			session.evict(session.get("t_actor", actor.get("id").toString()));
		}
		session.saveOrUpdate("t_actor", actor);
	}

	public static void Run(String personExpression, Session session) {

		if("".equals(personExpression)){
			return;
		}

		// 获得实际人员表达式，personExpression有可能是给ldap表达式，与实际不同
		String realPerson = getActorid(personExpression);
		Map actor = new HashMap();
		actor.put("id", realPerson);

		Set persons = new HashSet();
		String name=new String();
		String str=new String();
		// 如果是人员
		if (personExpression.startsWith("P")) {
			name = personExpression.substring(2,
					personExpression.length() - 1);
			Map map = new HashMap<String, String>();
			map.put("userid", name);
			map.put("userseq", name);
			persons.add(map);
		}
		// 是部门
		else if (personExpression.startsWith("D")) {
			name = personExpression.substring(2,
					personExpression.length() - 1);
			str = "{source: 'tool.getChildrenOfResName($" + name
					+ "$)', userid: ''}";
			persons=getPerson(persons,str);
			sessionDel(session, personExpression);
		}
		// 是ID数组，暂定部门
		else if (personExpression.startsWith("I")) {
			name = personExpression.substring(2,
					personExpression.length() - 1);
			String ids[]=name.split(",");
			persons=getPersonList(persons,ids);
			sessionDel(session, personExpression);
		}
		// 是角色
		else if (personExpression.startsWith("R")) {
			name = personExpression.substring(2,
					personExpression.length() - 1);
			str = "{source: 'tool.getChildrenOfResName($" + name
					+ "$)', userid: ''}";
			persons=getPerson(persons,str);
			sessionDel(session, personExpression);
		}else {//非R非P
			//对表达式字符串进行转义
			personExpression=getExpression(personExpression);
			persons=getPerson(persons,personExpression);
			//删除数据库中已存在的数据
			sessionDel(session,realPerson);
		}
		actor.put("f_person", persons);
		//放入资源类型【id或者是名称】
		actor.put("res", name);
		//保存数据到数据库
		session.saveOrUpdate("t_actor", actor);
	}
	//是否是数字【用来判断id】
	public static boolean isInteger(String str) {
		Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
		return pattern.matcher(str).matches();
	}

	//session执行插入前删除
	public static void sessionDel(Session session,String str){
		str = str.replaceAll("'", "''");
		String hql="DELETE t_actorperson WHERE  actorid='"+str+"'";
		Query query = session.createQuery(hql);
		query.executeUpdate();
	}
	//获取人员出入的是id组
	public static  Set getPersonList(Set persons,String[] str){
		for (int j=0;j<str.length;j++){
			//开始循环拿取资源子
			String resstr = "{source: 'tool.getChildrenOfResId($" + str[j]
					+ "$)', userid: ''}";
			String actual=RestTools.post("/rs/search", resstr);
			if(actual.indexOf("status: ") == -1 ){
				Object json = new JSONTokener(actual).nextValue();
				if(json instanceof JSONObject){
					JSONObject obj = (JSONObject)json;
					Map map = new HashMap<String, String>();
					//获取人选的id以及name
					map.put("userseq", obj.getString("id"));
					map.put("userid", obj.getString("name"));
					persons.add(map);
				}else if (json instanceof JSONArray){
					JSONArray arr = new JSONArray(actual);
					for (int i = 0; i < arr.length(); i++) {
						JSONObject obj = arr.getJSONObject(i);
						Map map = new HashMap<String, String>();
						//获取人选的id以及name
						map.put("userseq", obj.getString("id"));
						map.put("userid", obj.getString("name"));
						persons.add(map);
					}
				}
			}
		}
		return  persons;
	}
	//获取人员
	public static  Set getPerson(Set persons,String str){
        String actual=RestTools.post("/rs/search", str);
		if(actual.indexOf("status: ") == -1 ){
			Object json = new JSONTokener(actual).nextValue();
			if(json instanceof JSONObject){
				JSONObject obj = (JSONObject)json;
				Map map = new HashMap<String, String>();
				//获取人选的id以及name
				map.put("userseq", obj.getString("id"));
				map.put("userid", obj.getString("name"));
				persons.add(map);
			}else if (json instanceof JSONArray){
				JSONArray arr = new JSONArray(actual);
				for (int i = 0; i < arr.length(); i++) {
					JSONObject obj = arr.getJSONObject(i);
					Map map = new HashMap<String, String>();
					//获取人选的id以及name
					map.put("userseq", obj.getString("id"));
					map.put("userid", obj.getString("name"));
					persons.add(map);
				}
			}
		}
		return  persons;
	}

	//转义表达式
	public static  String  getExpression(String personExpression){
		// 转义 {: @lt;   } : @gt;  $ : @amp;
		String str = new String();
		if(personExpression != null){
			str = personExpression.replace("@lt;", "{");
			str = str.replace("@gt;", "}");
			str = str.replace("@amp;", "$");
		}
		//获取userid
	    return getUserid(str,1);

	}
    //替换this
    public static  String  getFixEXpression(String personExpression) {
        String str=getUserid(personExpression,1);
		// String userid=getUserid(personExpression,0);
        // 替换表达式source中的this为userid
		// 之前替换this出现bug 现在改为不替换 直接存储
        return  str;
    }
	//获取userid
    public static  String  getUserid(String str,int i) {
		JSONObject json = new JSONObject(str);
		String userid = json.getString("userid");
		int index=0;
        String olduserid=userid;
        //截取userid中正确的userid，对userid中的“.”进行判断截取最后一个字段
        if(userid.lastIndexOf(".")==userid.length()-1){//userid最后
            userid=userid.substring(0,userid.length()-1);
            index=	userid.lastIndexOf(".");
            userid=userid.substring(index+1,userid.length());
            //返回表达式i=0，返回userid，i=1，返回表达式
            if(i==0){return userid;}else {
                return str.replace(olduserid, userid);
            }
        }else{
            index=	userid.lastIndexOf(".");
            if(index==-1){
                if(i==0){return userid;}else {
                    return str.replace(olduserid, userid);
                }
            }
            else {
                userid = userid.substring(index + 1, userid.length());
                if(i==0){return userid;}else {
                    return str.replace(olduserid, userid);
                }
            }
        }
    }
    //获取actorid
    public static  String  getActorid(String str) {
		if (str.equals("") ||str.startsWith("I") || str.startsWith("R") || str.startsWith("P")|| str.startsWith("D")) {
			return str;
		}
		//对非R非P角色的actorid进行转义
		str = str.replace("@lt;", "{");
		str = str.replace("@gt;", "}");
		str = str.replace("@amp;", "$");
		str=getFixEXpression(str);
		//		JSONObject json = new JSONObject(str);
		//		String actorid = json.getString("source");
        return str;
    }

	public static String getPath() {
		String path = "";
		Map<String, String> map = new HashMap<String, String>();
		SAXReader read = new SAXReader();
		InputStream input = PersonService.class.getClassLoader()
				.getResourceAsStream("workflow.xml");
		try {
			Document document = read.read(input);
			Element root = document.getRootElement();
			for (Iterator it = root.elementIterator("url"); it.hasNext();) {
				Element elm = (Element) it.next();
				path = elm.attribute("path").getValue();
			}
			return path;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}
