/**查询用户气表信息**/
SELECT * FROM (
      SELECT
          uf.f_userfiles_id,
          uf.f_gasbrand_id,
          uf.f_user_type,
          uf.f_user_id,
          uf.f_userinfo_id,
          uf.f_civill_id,
          uf.f_meternumber,
          f_meter_classify,
          f_balance_gas,
          f_meter_base,
          f_card_id,
          uf.f_times,
          f_whether_hairpin,
          f_collection_type, -- 缴费方式
          f_total_gas, -- 表累购气量
          uf.f_card_password, -- 卡密码
          uf.f_meteread_maxid,
          gb.f_alias,  --别名
          gb.f_police_gas, -- 报警气量
          gb.f_topup_ceil, --充值上限
          gb.f_overdr_lines, -- 透支额度
          gb.f_meter_brand, -- 表品牌
          gb.f_calculation, --表端计费/系统计费
          up.f_state,
          f_parameter_key,
          f_table_state,
          f_balance_amount,
          {entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(m.f_jval, 0) f_jval,
          m.f_insert_date,
          m.id,
          ui.f_userinfo_code,
          ui.f_user_name,
          ui.f_user_state,
          ui.f_user_phone,
          a.f_address,
          ui.f_balance
      FROM
          t_userfiles uf
          LEFT JOIN t_userinfo ui on ui.f_userinfo_id = uf.f_userinfo_id
          LEFT JOIN t_user_address a ON ui.f_userinfo_id = a.f_userinfo_id
          LEFT JOIN t_gasbrand gb on uf.f_gasbrand_id = gb.id
          LEFT JOIN (select * from t_userproperties where f_state='有效') up on uf.f_userinfo_id = up.f_userinfo_id
          LEFT JOIN t_meteread m on m.id = uf.f_meteread_maxid
          where ui.f_user_state = '正常'
          and  uf.f_table_state = '正常'
      ) t
WHERE
    {condition} AND f_table_state = '正常'
ORDER BY
    id desc
