package com.aote.rs;


import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.pay.ccb_gongyi.MicroPayGongYi;
import com.aote.pay.icbc.gaomi.MicroPayGaoMi;
import com.aote.pay.icbc.shanggaoshunming.JsApiShunMing;
import com.aote.pay.xianbank.tongchuan.MicroPayTongChuan;
import com.aote.sql.SqlServer;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ContextLoader;

import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

/**
 * @Author: JoeCdy
 * @Description:
 * @Date: Created in 0:05 2020/8/29
 */
@Slf4j
@Component
@Path("pay")
@Singleton
@Transactional
public class PayServer {

    /**
     * 巩义建行付款码
     */
    @Autowired
    private MicroPayGongYi microPayGongYi;

    @Autowired
    private MicroPayGaoMi microPayGaoMi;

    @Autowired
    private MicroPayTongChuan microPayTongChuan;
//    @Autowired
//    private JsApiQianNengBoc jsApiQianNengBoc;
    @Autowired
    private SqlServer sqlServer;
    /**
     *  统一银行下单入口
     *
     * @param request
     * @param value   下单参数
     * @return 下单结果参数
     */
    @POST
    @Path("jsApiPay")
    public String jsApiPay(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("银行jsApi收到下单请求: {}", value);
            JSONObject json = new JSONObject(value);
            // 把request加入到下单参数中
            json.put("request", request);
            // 根据下单类型获取相应的对象
            String flag = json.getString("flag");
            // 首字母转小写, 因为bean的默认命名规则是首字符小写
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            log.debug("{} 处理下单", flag);
            // 获取到相应的银行处理实现类
            PaySuper paySuper = (PaySuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            // 调起下单程序
            result = paySuper.prePay(json);
        } catch (Exception e) {
            log.debug("银行jsApi下单异常", e);
        }
        return result;
    }
//    @POST
//    @Path("microPay")
//    public String microPay(@Context HttpServletRequest request, String value) {
//        String result = "";
//        try {
//            log.debug("银行microPay收到下单请求: {}", value);
//            JSONObject json = new JSONObject(value);
//            // 把request加入到下单参数中
//            json.put("request", request);
//            // 调起下单程序
//            result = jsApiQianNengBoc.microPay(json);
//        } catch (Exception e) {
//            log.debug("银行microPay下单异常", e);
//        }
//        return result;
//    }

//    @POST
//    @Path("codePay")
//    public String codePay(@Context HttpServletRequest request, String value) {
//        String result = "";
//        try {
//            log.debug("银行codePay收到下单请求: {}", value);
//            JSONObject json = new JSONObject(value);
//            // 把request加入到下单参数中
//            json.put("request", request);
//            // 调起下单程序
//            result = jsApiQianNengBoc.codePay(json);
//        } catch (Exception e) {
//            log.debug("银行codePay下单异常", e);
//        }
//        return result;
//    }

    /**
     *  统一银行下单入口
     *
     * @param request
     * @param value   下单参数
     * @return 下单结果参数
     */
    @POST
    @Path("jsApiRefund")
    public String jsApiRefund(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("银行jsApi收到退款请求: {}", value);
            JSONObject json = new JSONObject(value);
            // 把request加入到退款参数中
            json.put("request", request);
            // 根据下单类型获取相应的对象
            String flag = json.getString("flag");
            // 首字母转小写, 因为bean的默认命名规则是首字符小写
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            log.debug("{} 处理下单", flag);
            // 获取到相应的银行处理实现类
            RefundSuper refundSuper = (RefundSuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            // 调起下单程序
            result = refundSuper.refund( json);
        } catch (Exception e) {
            log.debug("银行jsApi退款异常", e);
        }
        return result;
    }

    /**
     * 江西银行退款入口
     *
     * @param request
     * @param value   退款参数
     * @return 退款结果参数
     */

    @POST
    @Path("refundShanggao")
    public String refundShanggao(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("银行jsApi收到退款请求: {}", value);
            JSONObject json = new JSONObject(value);
            JSONObject sqlParam = new JSONObject();
            sqlParam.put("tablename","t_weixinreturnxml");
            String condition =  "id = "+json.getInt("id")+"";
            sqlParam.put("condition",condition);
            JSONArray query = sqlServer.query("singleTable", sqlParam);

            if (query.length()>0) {
                json =  query.getJSONObject(0);
            } else {
                json.put("trade_state", "N");
                json.put("result_msg", "退款失败");
                return json.toString();
            }



            // 把request加入到退款参数中
            json.put("request", request);

            JsApiShunMing paySuper = (JsApiShunMing) ContextLoader.getCurrentWebApplicationContext().getBean("jsApiShunMing");

            // 调起退款程序
            result = paySuper.refund(json);
        } catch (Exception e) {
            log.debug("银行jsApi退款异常", e);
        }
        return result;
    }


    /**
     * 江西退款查询入口
     *
     * @param request
     * @param value   查询参数
     * @return 查询结果参数
     */
    @POST
    @Path("refundShanggaoOrderStatus")
    public String refundShanggaoOrderStatus(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("收到查询请求: {}", value);
            JSONObject json = new JSONObject(value);
            JSONObject sqlParam = new JSONObject();
            sqlParam.put("tablename","t_weixinreturnxml");
            String condition =  "id = "+json.getInt("id")+"";
            sqlParam.put("condition",condition);
            JSONArray query = sqlServer.query("singleTable", sqlParam);

            if (query.length()>0) {
                json =  query.getJSONObject(0);
            } else {
                json.put("trade_state", "N");
                json.put("result_msg", "退款失败");
                return json.toString();
            }

            // 获取到相应的银行处理实现类
            JsApiShunMing paySuper = (JsApiShunMing) ContextLoader.getCurrentWebApplicationContext().getBean("jsApiShunMing");

            // 调起查询程序
            result = paySuper.refundOrderStatus(json.toString());
        } catch (Exception e) {
            log.debug("银行microPay查询异常", e);
        }
        return result;
    }


    /**
     * 统一扫码盒查询入口
     *
     * @param request
     * @param value   查询参数
     * @return 查询结果参数
     */
    @POST
    @Path("microPayOrderStatus")
    public String microPayOrderStatus(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("银行microPay收到查询请求: {}", value);
            JSONObject json = new JSONObject(value);
            // 把request加入到下单参数中
            json.put("request", request);
            // 根据下单类型获取相应的对象
            String flag = json.getString("flag");
            // 首字母转小写, 因为bean的默认命名规则是首字符小写
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            log.debug("{} 处理查询", flag);
            // 获取到相应的银行处理实现类
            PaySuper paySuper = (PaySuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            // 调起查询程序
            result = paySuper.orderStatus(value);
        } catch (Exception e) {
            log.debug("银行microPay查询异常", e);
        }
        return result;
    }



    /**
     * 巩义建行付款码查询
     *
     * @param request
     * @param value
     * @return
     */
    @POST
    @Path("microPayGongYiOrderStatus")
    @Produces(MediaType.APPLICATION_JSON)
    public String microPayGongYiOrderStatus(@Context HttpServletRequest request, String value) {
        log.debug("microPayGongYiOrderStatus收到查询请求: {}", value);
        return microPayGongYi.orderStatus(value);
    }

    /**
     * 高密建行付款码查询
     * @param request
     * @param value
     * @return
     */
    @POST
    @Path("microPayGaoMiOrderStatus")
    @Produces(MediaType.APPLICATION_JSON)
    public String microPayGaoMiOrderStatus(@Context HttpServletRequest request, String value) {
        log.debug("microPayGaoMiOrderStatus收到查询请求: {}", value);
        return microPayGaoMi.orderStatus(value);
    }


    /**
     * 西银惠付付款码查询
     *
     * @param request
     * @param value
     * @return
     */
    @POST
    @Path("MicroPayTongChuanOrderStatus")
    @Produces(MediaType.APPLICATION_JSON)
    public String MicroPayTongChuanOrderStatus(@Context HttpServletRequest request, String value) {
        log.debug("MicroPayTongChuanOrderStatus收到查询请求: {}", value);
        return microPayTongChuan.orderStatus(value);
    }
    @POST
    @Path("getRecordFile")
    public String getRecordFile(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("银行jsApi收到下单请求: {}", value);
            JSONObject json = new JSONObject(value);
            // 把request加入到下单参数中
            json.put("request", request);
            // 根据下单类型获取相应的对象
            String flag = json.getString("flag");
            // 首字母转小写, 因为bean的默认命名规则是首字符小写
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            // 获取到相应的银行处理实现类
            RefundSuper refundSuper = (RefundSuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            // 调起下单程序
            result = refundSuper.getRecordFile(json).toString();
        } catch (Exception e) {
            log.debug("银行下载对账文件异常", e);
        }
        return result;
    }
}
