package com.aote.weixin.timer;

import cn.hutool.core.date.DateUtil;
import com.aote.rs.SqlService;
import com.aote.sql.SqlServer;
import com.aote.util.ResourceHelper;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @description:
 * @author: 唐梓烨
 * @time: 2023/4/28 16:54
 */
@Slf4j
@Component
public class BatchBusinessAwaitServer {
    /**
     * 线程池
     */
    private static final ExecutorService executorService = Executors.newFixedThreadPool( 2);

    static JSONObject configJson;

    @Autowired
    private OrderProcess orderProcess;
    @Autowired
    private SqlService sqlService;
    private static final String THREAD_PRODUCE = "获取待执行的任务";
    private static final String THREAD_CONSUME = "执行任务";
    /**
     * 公共资源
     */
    private PublicResource resource = new PublicResource();

    @PostConstruct
    public void action() throws IOException {
        configJson = new JSONObject( ResourceHelper.getString("config.json"));
        if (configJson.optBoolean("action", false)) {
            new Thread(new Task(THREAD_PRODUCE)).start();
            new Thread(new Task(THREAD_CONSUME)).start();
        }
    }

    class Task implements Runnable {
        private final String threadName;

        Task(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    if (THREAD_PRODUCE.equals(threadName)) {
                        //生产者
                        resource.increase();
                    } else if (THREAD_CONSUME.equals(threadName)) {
                        //消费者
                        resource.decrease();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class PublicResource {
        private JSONArray job = new JSONArray();
        private final Object object = new Object();

        /**
         * 生产者生产产品
         */
        public void increase() throws Exception {
            synchronized (object) {
                //如果产品个数大于最大个数 等待
                while (!job.isEmpty() && configJson.optBoolean("action", false)
                ) {
                    object.wait();
                }
                JSONObject params = new JSONObject();
                JSONObject conditionParam = new JSONObject();
                conditionParam.put("dateNow", DateUtil.now());
                params.put("data", conditionParam);
                String orderQuery = sqlService.txExecute("orderQuery", 1, 1000, params.toString());
                job = new JSONArray(orderQuery);
                // 如果 没有查询到 10秒后再查询
                if (job.isEmpty()) {
                    Thread.sleep(1000 * 10);
                }else {
                    System.out.println("--" + Thread.currentThread().getName() + ":生产了一个任务.");
                }
                object.notifyAll();
            }
        }

        //消费者消费产品
        public void decrease() throws Exception {
            synchronized (object) {
                //如果产品个数小于等于0 等待
                while (job.isEmpty()) {
                    object.wait();
                }
                CountDownLatch latch = new CountDownLatch(job.length());
                job.forEach(item -> executorService.execute(() ->{
                    try {
                        JSONObject searchItem = (JSONObject) item;
                        try {
                            orderProcess.process(searchItem);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } finally {
                        latch.countDown();
                    }
                }));
                latch.await();
                job = new JSONArray();
                System.out.println("--" + Thread.currentThread().getName() + ":消费了一个任务.");
            }
        }
    }
}
