package com.aote.weixin;

import com.aote.util.ResourceHelper;
import com.google.common.base.Strings;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/**
 * 获取微信配置内容类
 */
@Component
public class Config {

    /**
     *  微信wechatConfig参数对象, 用它动态获取数据
     */
    public static PropertiesConfiguration wechatConfig;
    public static PropertiesConfiguration filterConfig;
    public static PropertiesConfiguration config;
    private static WechatConfigService wechatConfigService;
    static {
        try {
            wechatConfig = new PropertiesConfiguration("wechatConfig.properties");
            // 自动重新加载
            wechatConfig.setReloadingStrategy(new FileChangedReloadingStrategy());

            filterConfig = new PropertiesConfiguration("filterConfig.properties");
            // 自动重新加载
            filterConfig.setReloadingStrategy(new FileChangedReloadingStrategy());
        } catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }


    @Autowired
    public void setWechatConfigService(WechatConfigService wechatConfigService) {
        Config.wechatConfigService = wechatConfigService;
    }
    /**
     * 姓名脱敏处理
     *
     * @param fullName 传过来的姓名
     */
    public static String desensitizedName(String fullName){
        if (!Strings.isNullOrEmpty(fullName)) {
            String x = String.valueOf(fullName.charAt(0));
            String name = fullName.replace(x,"*");
            return name ;
        }
        return fullName;
    }
    /**
     * 电话号码脱敏处理
     *
     * @param phoneNumber 传过来的电话号码
     */
    public static String desensitizedPhoneNumber(String phoneNumber){
        if(StringUtils.isNotEmpty(phoneNumber)){
            phoneNumber = phoneNumber.replaceAll("(\\w{3})\\w*(\\w{4})", "$1****$2");
        }
        return phoneNumber;
    }
    /**
     * 身份证号码脱敏处理
     *
     * @param idNumber 传过来的身份证号码
     */
    public static String desensitizedIdNumber(String idNumber){
        if(StringUtils.isNotEmpty(idNumber)){
            idNumber = idNumber.replaceAll("(\\w{4})\\w*(\\w)", "$1****$2");
        }
        return idNumber;
    }

    /**
     * 地址脱敏处理
     *
     * @param address 传过来的地址
     */
    public static String desensitizedAddress(String address){

        if(StringUtils.isNotEmpty(address)){
            address =  address.replaceAll("0","*");
            address =  address.replaceAll("1","*");
            address =  address.replaceAll("2","*");
            address =  address.replaceAll("3","*");
            address =  address.replaceAll("4","*");
            address =  address.replaceAll("5","*");
            address =  address.replaceAll("6","*");
            address =  address.replaceAll("7","*");
            address =  address.replaceAll("8","*");
            address =  address.replaceAll("9","*");
        }
        return address;
    }
    public static JSONObject paramToJson(String str) {
        String[] strChild = str.split("&");
        JSONObject param = new JSONObject();
        String[] var3 = strChild;
        int var4 = strChild.length;

        for(int var5 = 0; var5 < var4; ++var5) {
            String s1 = var3[var5];
            String[] split = s1.split("=");
            if (split.length == 2) {
                try {
                    param.put(split[0], URLDecoder.decode(split[1], "utf8"));
                } catch (UnsupportedEncodingException var9) {
                    var9.printStackTrace();
                }
            } else {
                param.put(split[0], "");
            }
        }

        return param;
    }

    /**
     * 获取JSON配置
     *
     * @param company 微信端传过来的公司名
     */
    public static  JSONObject getConfig(String company) {
        String str = null;
        JSONObject result = new JSONObject();
        try {
            result = wechatConfigService.getConfig(company);
            if (result.isEmpty()) {
                str = ResourceHelper.getString("filiale/" + company + "/weixin/config.json");
                result = new JSONObject(str);
            }

        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }


    /**
     * 获取微信前台配置
     *
     * @param company 微信端传过来的公司名
     */
    public static JSONObject getClientConfig(String company) {
        String str = null;
        JSONObject result = new JSONObject();
        try {
            result = wechatConfigService.getClientConfig(company);
            if (result.isEmpty()) {
                str = ResourceHelper.getString("filiale/" + company + "/weixin/wechatconfig.json");
                result = new JSONObject(str);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }



    /**
     * 获取json配置
     *
     * @param filepath 需要获取的文件路径
     */
    public static JSONObject getCustomConfig(String filepath) {
        String str = null;
        try {
            str = ResourceHelper.getString(filepath);
        } catch (IOException e) {
            e.printStackTrace();
        }
        JSONObject result = new JSONObject(str);
        return result;
    }

    public static boolean isPassUri(String url) {
        for (String item : filterConfig.getString("urlPass").split("-")) {
            if (url.contains(item)) {
                return true;
            }
        }
        return false;
    }
    public static boolean isPassIp(String ip) {
        for (String item : filterConfig.getString("ipPass").split("-")) {
            if (ip.contains(item)) {
                return true;
            }
        }
        return false;
    }
}
