package com.aote.util.image;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;

/**
 * 文字、文本转图片
 */
public class FontToImage {
    /**
     * 根据str,font的样式以及输出文件目录
     * str: 输入的文字
     * typeface： 字体
     * size: 字号，字的大小(磅数)
     */
    public static String createImage(String str, String typeface, int size, String outFilePath,
                                   Integer width, Integer height) throws Exception {
        File outFile = new File(outFilePath);
        // 通常三个常量 Font.PLAIN, Font.BOLD, Font.ITALIC
        int style = Font.PLAIN;
        Font font = new Font(typeface, style, size);
        // 创建图片
        BufferedImage image = new BufferedImage(width, height,
                BufferedImage.TYPE_INT_BGR);
        Graphics g = image.getGraphics();
        g.setClip(0, 0, width, height);
        g.setColor(Color.white);
        // 先用黑色填充整张图片,也就是背景
        g.fillRect(0, 0, width, height);
        // 在换成黑色
        g.setColor(Color.black);
        // 设置画笔字体
        g.setFont(font);
        // 用于获得垂直居中y
        Rectangle clip = g.getClipBounds();
        FontMetrics fm = g.getFontMetrics(font);
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int y = (clip.height - (ascent + descent)) / 2 + ascent;
        for (int i = 0; i < 6; i++) {
            // 256 340 0 680
            // 画出字符串
            g.drawString(str, i * 680, y);
        }
        g.dispose();
        // 输出png图片
        ImageIO.write(image, "png", outFile);
        return outFilePath;
    }

    public static void main(String[] args) throws Exception {
        String imagePath = "d:/handplanImage/正式测试数据.png";
        createImage("请在这里输入文字", "微软雅黑", 32, imagePath, 300, 64);
    }
}
