package com.aote.util;

import java.security.MessageDigest;
import java.util.*;


public class SignUtils {

    /**
     *
     * @param sqMap
     * @return
     */
    public static String plainStr(Map<String, String> sqMap) {
        StringBuffer plain = new StringBuffer();
        for (Map.Entry<String, String> entry : sqMap.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            if (null != v && !"".equals(v) && !"sign".equals(k) && !"key".equals(k)) {
                plain.append(k + "=" + v + "$$");
            }
        }
        return plain.substring(0, plain.lastIndexOf("$$"));
    }


    /**
     * ACCSII排序
     *
     * @param finalpackage
     * @return
     */
    public static String sortStr(SortedMap<Object, Object> finalpackage) {
        StringBuffer sb = new StringBuffer();
        Set<?> es = finalpackage.entrySet();
        // 所有参与传参的参数按照ACCSII排序（升序）
        Iterator<?> it = es.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry) it.next();
            String k = (String) entry.getKey();
            Object v = entry.getValue();
            if (null != v && !"".equals(v) && !"sign".equals(k) && !"key".equals(k)) {
                sb.append(k + "=" + v + "&");
            }
        }
        return sb.substring(0, sb.lastIndexOf("&"));
    }


    private static final char[] HEX = {'0', '1', '2', '3', '4', '5',
            '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        // 把密文转换成十六进制的字符串形式
        for (int j = 0; j < len; j++) {
            buf.append(HEX[(bytes[j] >> 4) & 0x0f]);
            buf.append(HEX[bytes[j] & 0x0f]);
        }
        return buf.toString();
    }

    public static String encode(String str) {
        if (str == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(str.getBytes());
            return getFormattedText(messageDigest.digest());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
