package com.aote.util;

import org.json.JSONObject;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @description:
 * @author: tzh
 * @time: 2023/10/12 15:09
 */
public class PushUtil {
    /**
     * 定义 Pattern 为静态字段
     */
    private static final Pattern PATTERN = Pattern.compile("<(.*?)>");

    /**
     * 在一个字符串中查找并替换特定的占位符。
     * @param pushData  替换源
     * @param f_value   需要查找替换的字符串
     * @return
     */

    public static String replacePlaceholders(JSONObject pushData, String f_value) {
        // 创建 matcher 对象
        Matcher matcher = PATTERN.matcher(f_value);

        // 创建 StringBuffer 对象存储最终结果
        StringBuffer sb = new StringBuffer();

        // 标记是否找到了占位符
        boolean foundPlaceholder = false;

        // 对每个匹配的部分进行替换
        while (matcher.find()) {
            foundPlaceholder = true;
            String key = matcher.group(1);

            if (pushData.has(key)) {
                // 替换匹配的部分
                String replacement = String.valueOf(pushData.get(key));
                matcher.appendReplacement(sb, replacement);
            } else {
                // 如果 pushData 中没有找到匹配的值，将占位符替换为 '无'
                matcher.appendReplacement(sb, " ");
            }
        }

        // 如果没有找到占位符，返回原始的 f_value
        if (!foundPlaceholder) {
            return f_value;
        }

        // 添加剩余的部分
        matcher.appendTail(sb);

        // 返回最终的结果
        return sb.toString();
    }
}
