package com.aote.rs.wechatpay;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.aote.entity.WxPayReturnData;
import com.aote.entity.WxPaySendData;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.sql.SqlServer;
import com.aote.util.PropertiesUtil;
import com.aote.util.WechatUrl;
import com.aote.util.WxSign;
import com.aote.util.XmlUtils;
import com.aote.weixin.Config;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 * 预付费处理
 */
@Component
public class Attachprepay implements PaySuper, RefundSuper {

    static Logger log = Logger.getLogger(Attachprepay.class);

    @Autowired
    private LogicServer logicServer;

    @Autowired
    private SqlServer sqlServer;

    

    /**
     * 微信退费
     */
    @Autowired
    private WxRefund wxRefund;
    /**

    /**
     * 下单接口
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        JSONObject result = new JSONObject();
        try {
            String appId = json.getString("appId");
            String key = json.getString("key");
            String mchId = json.getString("mchId");
            String notifyUrl = json.getString("wechatNotify");
            String money = json.getString("money");
            String openid = json.getString("openid");
            String attach = json.getString("attach");
            String ip = json.getString("ip");
            String filiale = json.getString("filiale");
            String orderType = json.getString("orderType");

            // 支付商户订单号
            String outTradeNo = WxSign.getNonceStr();
            WxPaySendData sendData = getPaySendEntity(appId, mchId, money, openid, attach, ip, notifyUrl, outTradeNo);
            // 下单处理,返回数据为xml
            String returnXml = unifiedOrder(sendData, key);
            WxPayReturnData reData = (WxPayReturnData) XmlUtils.formatXml(returnXml, WxPayReturnData.class);
            // 下单成功标识
            boolean checkoutSuccess = false;
            // 判断返回数据
            String return_code = reData.getReturn_code();
            if (return_code.equals("SUCCESS")) {
                if (!reData.getResult_code().equals("SUCCESS")) {
                    result.put("error", "返回错误：" + reData.getErr_code()
                            + reData.getErr_code_des());
                } else {
                    checkoutSuccess = true;
                }
            } else {
                result.put("error", "系统错误：" + reData.getReturn_msg());
            }
            if (checkoutSuccess) {
                // 保存下单信息到中间表
                JSONObject param = new JSONObject(attach);
                String userFilesId = param.optString("f_userfiles_id", "");

                JSONObject saveOrder = new JSONObject();
                saveOrder.put("f_out_trade_no", sendData.getOut_trade_no());
                saveOrder.put("f_attach", attach);
                saveOrder.put("f_openid", sendData.getOpenid());
                saveOrder.put("f_total_fee", sendData.getTotal_fee());
                saveOrder.put("f_order_state", "已下单");
                saveOrder.put("f_order_type", orderType);
                saveOrder.put("flag", "Attachprepay");
                saveOrder.put("f_filiale", filiale);
                saveOrder.put("f_userfiles_id", userFilesId);
                // 保存分公司id
                JSONObject clientConfig = Config.getClientConfig(filiale);
                saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                logicServer.run("savewxreturnxml", saveOrder);
            }
            // 跳转支付页面
            SortedMap<Object, Object> finalpackage = new TreeMap<Object, Object>();
            String timestamp = WxSign.getTimeStamp();
            String nonceStr2 = WxSign.getNonceStr();
            String prepay_id2 = "prepay_id=" + reData.getPrepay_id();
            String packages = prepay_id2;
            finalpackage.put("appId", appId);
            finalpackage.put("timeStamp", timestamp);
            finalpackage.put("nonceStr", nonceStr2);
            finalpackage.put("package", packages);
            finalpackage.put("signType", "MD5");
            String finalsign = WxSign.createSign(finalpackage, key);
            result.put("appId", appId);
            result.put("timeStamp", timestamp);
            result.put("nonceStr", nonceStr2);
            result.put("pg", prepay_id2);
            result.put("sign", finalsign);
            result.put("signType", "MD5");
            // 返回商户订单号
            result.put("outTradeNo", outTradeNo);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.debug("result=" + result);
        return result.toString();
    }

    public WxPaySendData getPaySendEntity(String appId, String mchId, String money,
                                          String openid, String attach, String ip, String url, String outTradeNo) {
        WxPaySendData result = new WxPaySendData();
        JSONObject at = new JSONObject(attach);
        if (at.has("f_userinfo_code")) {
            result.setBody("燃气费-用户编号:" + at.getString("f_userinfo_code"));
        } else {
            result.setBody("微信公众号支付");
        }
        result.setAppid(appId); // appid
        result.setAttach(attach);
        result.setMch_id(mchId); //商户id
        result.setNonce_str(WxSign.getNonceStr());
        result.setNotify_url(url);//支付完回调地址
        result.setOut_trade_no(outTradeNo); // 随机数
        BigDecimal v1 = new BigDecimal(money);
        BigDecimal v2 = new BigDecimal("100");
        Double b = v1.multiply(v2).doubleValue();
        int fee1 = b.intValue();
        result.setTotal_fee(fee1);//result.setTotal_fee((int) (Double.parseDouble(money) * 100));// 单位：分 支付金额
        result.setTrade_type("JSAPI");// setTrade_type 交易类型 JSAPI--公众号支付、NATIVE--原生扫码支付、APP--app支付
        result.setSpbill_create_ip(ip); //订单生成的机器IP，指用户浏览器端IP
        result.setOpenid(openid);
        return result;
    }

    public static String unifiedOrder(WxPaySendData data, String key) {
        // 统一下单支付
        String returnXml = null;
        String attach = data.getAttach();
        // 附加数据attach最大长度String(127)
        int len = 120;
        if(attach.length() > len) {
            attach = attach.substring(0, len) + '}';
            data.setAttach(attach);
        }
        try {
            // 生成sign签名
            SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
            parameters.put("appid", data.getAppid());
            parameters.put("attach", attach);
            parameters.put("body", data.getBody());
            parameters.put("mch_id", data.getMch_id());
            parameters.put("nonce_str", data.getNonce_str());
            parameters.put("notify_url", data.getNotify_url());
            parameters.put("out_trade_no", data.getOut_trade_no());
            parameters.put("total_fee", (Integer) data.getTotal_fee());
            parameters.put("trade_type", data.getTrade_type());
            parameters.put("spbill_create_ip", data.getSpbill_create_ip());
            parameters.put("openid", data.getOpenid());
            parameters.put("device_info", data.getDevice_info());
            data.setSign(WxSign.createSign(parameters, key));
            XStream xs = new XStream(new DomDriver("UTF-8", new XmlFriendlyNameCoder("-_", "_")));
            xs.alias("xml", WxPaySendData.class);
            String xml = xs.toXML(data);
            log.debug("微信支付下单数据:" + xml);
            returnXml = HttpUtil.post(WechatUrl.DOWN_PAY_API, xml, 10000);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return returnXml;
    }

    /**
     * 查询订单是否支付成功
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        log.debug("主动查询订单 >>> " + value);
        JSONObject jsonObject = new JSONObject(value);
        JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));

        String appId = wxConfig.getString("appId");
        String mchId = wxConfig.getString("mchId");
        String key = wxConfig.getString("key");
        String nonceStr = WxSign.getNonceStr();
        // 签名
        SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
        parameters.put("appid", appId);
        parameters.put("mch_id", mchId);
        parameters.put("nonce_str", nonceStr);
        if (jsonObject.has("transaction_id")) {
            parameters.put("transaction_id", jsonObject.getString("transaction_id"));
        } else {
            parameters.put("out_trade_no", jsonObject.getString("out_trade_no"));
        }
        parameters.put("sign", WxSign.createSign(parameters, key));
        String requestXml = XmlUtils.getRequestXml(parameters);
        try {
            // 发送查询请求
            String returnXml = HttpUtil.post(WechatUrl.PAY_QUERY_API, requestXml, 60000);
            String xml = JSONUtil.parseFromXml(returnXml).get("xml").toString();
            log.debug("查询订单返回:" + xml);
            return xml;
        } catch (Exception e) {
            log.debug("查询订单出错:" + e);
            return "{}";
        }
    }

    /**
     * 退款接口
     * @param json
     * @return 退款结果参数
     */
    @Override
    public String refund (JSONObject json) {
        JSONObject result = new JSONObject();
        log.debug( PropertiesUtil.getProperties("server"));
        try {
            String filiale =  json.getString("f_filiale");
            JSONObject wxConfig = Config.getConfig(filiale);
            String appId = wxConfig.getString("appId");
            String key = wxConfig.getString("key");
            String mchId = wxConfig.getString("mchId");
            int id = json.getInt("id");
            String total_fee = String.valueOf(json.getInt("f_total_fee"));
            // 微信支付订单号
            String transactionid = json.getString("f_transaction_id");
            // 微信退费证书路径
            String certificatePath = wxConfig.getString("certificatePath");
            log.debug("订单超时,发起退款");
            String ip = "";
            String port = "";

            String res = wxRefund.SendRefundreq(appId, mchId, key, total_fee, transactionid, certificatePath, ip, port + "").toString();

            // 发起退款
            JSONObject reData =  new JSONObject(res);
            // 下单成功标识
            boolean checkoutSuccess = false;
            // 判断返回数据
            String return_code = reData.getString("f_return_code");
            if (return_code.equals("SUCCESS")) {
                if (! reData.getString("f_return_code").equals("SUCCESS")) {
                    result.put("error", "返回错误：" + reData.getString("f_return_msg")
                            + reData.getString("f_err_code_des"));
                } else {
                    checkoutSuccess = true;
                }
            } else {
                result.put("error", "系统错误：" + reData.getString("f_return_msg"));
            }
            if (checkoutSuccess) {
                JSONObject saveOrder = new JSONObject();
                saveOrder.put("f_order_state", "退款中");
                saveOrder.put("f_refund_id", reData.getString("f_refund_id"));
                saveOrder.put("id", id);
                logicServer.run("savewxreturnxml", saveOrder);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.debug("result=" + result);
        return result.toString();
    }
    /**
     * 查询订单是否支付成功
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String refundOrderStatus(String value) {
        JSONObject result = new JSONObject();
        log.debug("主动查询订单 >>> " + value);
        JSONObject jsonObject = new JSONObject(value);
        JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
        int id = jsonObject.getInt("id");
        String appId = wxConfig.getString("appId");
        String mchId = wxConfig.getString("mchId");
        String key = wxConfig.getString("key");
        String nonceStr = WxSign.getNonceStr();
        // 签名
        SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
        parameters.put("appid", appId);
        parameters.put("mch_id", mchId);
        parameters.put("nonce_str", nonceStr);
        if (jsonObject.has("f_refund_id")) {
            parameters.put("refund_id", jsonObject.getString("f_refund_id"));
        } else if (jsonObject.has("f_transaction_id")){
            parameters.put("transaction_id", jsonObject.getString("f_transaction_id"));
        } else {
            parameters.put("out_trade_no", jsonObject.getString("out_trade_no"));
        }
        parameters.put("sign", WxSign.createSign(parameters, key));
        String requestXml = XmlUtils.getRequestXml(parameters);
        try {
            // 发送查询请求
            String returnXml = HttpUtil.post(WechatUrl.REFUND_QUERY_API, requestXml, 60000);
            String xml = JSONUtil.parseFromXml(returnXml).get("xml").toString();
            log.debug("查询订单返回:" + xml);
            JSONObject res = new JSONObject(xml);
            if ("SUCCESS".equals(res.getString("refund_status_$n"))) {
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已退款' where id = '" + id + "'");
                result.put("result_msg", "退款成功");
            } else if ("REFUNDCLOSE".equals(res.getString("refund_status_$n"))){
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                result.put("result_msg", "退款失败");
            } else {
                result.put("result_msg", "退款中");
            }
            return result.toString();
        } catch (Exception e) {
            log.debug("查询订单出错:" + e);
            return "{}";
        }
    }
    @Override
    public JSONObject getRecordFile(JSONObject json) {
        return null;
    }
}
