package com.aote.pay.psbc.mengzhou;


import cn.hutool.core.date.DateTime;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.util.FileUtils;
import com.aote.util.PSBCSignUtils;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Slf4j
@Component
public class JsApiMengZhou implements PaySuper, RefundSuper {
    @Autowired
    private LogicServer logicServer;
    
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");

        JSONObject jsonAttach = new JSONObject(attach);
        //订单类型
        String ordertype = jsonAttach.getString("fee_type");


        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            log.debug("进入");
            PSBCSignUtils.openPayPrivateKey = wxConfig.getString("privateKey");
            PSBCSignUtils.openPayPublicKey = wxConfig.getString("publicKey");
            log.debug( PSBCSignUtils.openPayPrivateKey);
            log.debug(  PSBCSignUtils.openPayPublicKey);
            // 渠道商代号，由开放式缴费平台分配
            String channelId = wxConfig.getString("channelId");
            String payItemNo = "";
            payItemNo = wxConfig.getString("rilePayItemNo");
            if ("配套费".equals(ordertype) || ordertype == "配套费") {
                payItemNo = wxConfig.getString("peiTiaoPayItemNo");
            }
            log.debug(channelId);
            // 缴费项目编号，由开放式缴费平台提供，渠道商线下维护到其系统
            log.debug(payItemNo);
            // 交易金额,单位为分
             String txnAmt = money;
            log.debug(txnAmt);
            // 渠道商用户标识id
             String openId = openid;
            log.debug(openId);
             String orderNo = PayUtil.getOrderNoByNumber();
            log.debug(orderNo);
             String notifyUrl = wxConfig.getString("wechatNotify");
            log.debug(notifyUrl);
             String openPayUri = wxConfig.getString("openPayUri");

            log.debug(openPayUri);


            JSONObject message = new JSONObject();
            JSONObject head = new JSONObject();
            JSONObject body = new JSONObject();
            /**
             * 请求头（消息头）
             */
            //版本号必填
            head.put("version", "1.0.0");
            //交易码必填  固定 pay
            head.put("trancode", "pay");
            //报文id必填 默认系统生成
            head.put("msgId", PayUtil.getOrderNoByNumber());
            //收费单位代号 必填 平台提供
            head.put("channelId", channelId);
            message.put("head", head);
            /**
             * 消息体
             */
            /**
             * 缴费项目编号，由开放式缴
             * 费平台提供，收费单位线下
             * 维护到其系统。
             * 必填
             */
            body.put("payItemNo", payItemNo);
            /**
             * 收费单位生成的订单号，需
             * 保证永久唯一。
             * 必填
             * 系统生成
             */
            body.put("orderNo", orderNo);
            /**
             * 收费单位订单描述
             * 必填 不用改
             */
            body.put("orderDesc", "test");
            /**
             * 交易金额 单位分
             */
            body.put("txnAmt", String.valueOf(new BigDecimal(txnAmt).multiply(new BigDecimal("100")).setScale(0, BigDecimal.ROUND_HALF_UP)));
            /**
             * 后台通知收费单位支付结果
             * 地址：测试环境只支持 IP:
             * 端口，不支持域名:端口；生
             * 产环境地址均支持。
             * 必填
             */
            body.put("backUrl", notifyUrl);//后台通知渠道商支付结果地址,请根据实际地址填写
            /**
             * 收银台支付完成返回商户跳
             * 转地址 ，当 payType=3
             * 时，该字段传“”即可。
             */
            body.put("frontUrl", "http://wxtest.smeia.cn/h5/#/paySuccess");//收银台支付完成返回商户跳转地址,请根据实际地址填写
            /**
             * 交易类型
             * 1-移动端
             * 2-PC 端
             */
            body.put("txnType", "1");
            /**
             * 交易时间
             * 收费单位发送交易时间，时
             * 间格式为
             * yyyyMMddHHmmss。
             */
            body.put("txnTime", new DateTime().toString("yyyyMMddHHmmss"));
            /**
             * 收费单位用户标识 id
             * （openid 是微信用户的标
             * 识）。
             * 必填
             */
            body.put("openId", openId);
            message.put("body", body);
            String plaintext = message.toString();
            log.debug("下单明文为：{}", plaintext);
            // 加密
            String ciphertext = PSBCSignUtils.encrypt(channelId, plaintext);
            // 加签
            String signature = PSBCSignUtils.sign(channelId, ciphertext);
            String cipherInfo = signature + "|+|" + ciphertext;
            String uri = openPayUri + channelId;
            // 调用缴费平台接口
            String response = new HttpService().sendPost(uri, cipherInfo);
                    //httpService.sendPost(uri, cipherInfo);
            log.info("接口返回密文为：{}", response);


            // 解密返回报文
            String res =  PSBCSignUtils.decrypt(response, channelId);
            log.info("下单接口返回明文为：{}", res);
            JSONObject data = new JSONObject(res);
            if ("000000".equals(data.getJSONObject("head").getString("respCode"))) {
                // 保存下单信息到中间表
                result.put("stute", "success");
                result.put("cashierHtml",data.getJSONObject("body").getString("cashierHtml"));
                JSONObject saveOrder = new JSONObject();
                saveOrder.put("f_out_trade_no", orderNo);
                saveOrder.put("f_attach", attach);
                saveOrder.put("f_openid", openid);
                saveOrder.put("flag", "JsApiMengZhou");
                saveOrder.put("f_order_state", "已下单");
                saveOrder.put("f_order_type", "燃气收费");
                saveOrder.put("f_filiale", filiale);
                saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
                // 保存分公司id
                JSONObject clientConfig = Config.getClientConfig(filiale);
                saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                logicServer.run("savewxreturnxml", saveOrder);
            } else {
                result.put("stute", "fail");
                result.put("respMsg", data.getJSONObject("head").getString("respMsg"));
            }
        } catch (Exception e) {
            result.put("stute", "fail");
            result.put("respMsg", e);
            log.debug("长安银行下单异常错误", e);
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            String orderNo = jsonObject.getString("out_trade_no");
            String attach = jsonObject.getString("f_attach");
            JSONObject jsonAttach = new JSONObject(attach);

            String ordertype = jsonAttach.getString("fee_type");

            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String channelId = wxConfig.getString("channelId");
            String payItemNo = "";
            payItemNo = wxConfig.getString("rilePayItemNo");
            if ("配套费".equals(ordertype) || ordertype == "配套费") {
                payItemNo = wxConfig.getString("peiTiaoPayItemNo");
            }

            String openPayUri = wxConfig.getString("openPayUri");
            JSONObject message = new JSONObject();
            JSONObject head = new JSONObject();
            JSONObject body = new JSONObject();
            head.put("version", "1.0.0");
            head.put("trancode", "confirm");
            head.put("msgId", PayUtil.getOrderNoByNumber());
            head.put("channelId", channelId);
            message.put("head", head);
            body.put("payItemNo", payItemNo);
            body.put("orderNo", orderNo);
            message.put("body", body);
            String plaintext = message.toString();
            log.info("查询明文为：{}", plaintext);
            // 加密
            final String ciphertext =  PSBCSignUtils.encrypt(channelId, plaintext);
            // 加签
            final String signature = PSBCSignUtils.sign(channelId, ciphertext);
            final String cipherInfo = signature + "|+|" + ciphertext;
            final String uri = openPayUri + channelId;
            // 调用缴费平台接口
            String response = new HttpService().sendPost(uri, cipherInfo);
                  //  httpService.sendPost(uri, cipherInfo);
            // 解密返回报文
            String res =  PSBCSignUtils.decrypt(response, channelId);
            log.info("查询接口返回明文为：{}", res);
            JSONObject data = new JSONObject(res);
            if ("000000".equals(data.getJSONObject("head").getString("respCode"))) {
                if ("02".equals(data.getJSONObject("body").getString("orderStatus"))) {
                    result.put("result_code", "SUCCESS");
                    result.put("trade_state", "SUCCESS");
                    // 订单号
                    result.put("transaction_id",data.getJSONObject("body").getString("orderNo"));
                    // 交易金额
                    result.put("total_fee",jsonObject.get("f_total_fee"));
                    // 交易日期
                    result.put("time_end", new DateTime().toString("yyyyMMddHHmmss"));

                } else {
                    result.put("stute", "fail");
                    result.put("trade_state", "fail");
                }
            } else {
                result.put("stute", "fail");
                result.put("trade_state", "fail");
            }

        } catch (Exception e) {
            log.debug("查询订单出错:" + e);
            result.put("stute", "fail");
            result.put("trade_state", "fail");

        }
        return result.toString();
    }

    @Override
    public JSONObject getRecordFile(JSONObject json) {
        String filiale = json.getString("f_filiale");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            log.debug("进入");
            PSBCSignUtils.openPayPrivateKey = wxConfig.getString("privateKey");
            PSBCSignUtils.openPayPublicKey = wxConfig.getString("publicKey");
            log.debug( PSBCSignUtils.openPayPrivateKey);
            log.debug(  PSBCSignUtils.openPayPublicKey);
            // 渠道商代号，由开放式缴费平台分配
            String channelId = wxConfig.getString("channelId");
            log.debug(channelId);
            // 缴费项目编号，由开放式缴费平台提供，渠道商线下维护到其系统
            String payItemNo = wxConfig.getString("rilePayItemNo");
            log.debug(payItemNo);
            String openPayUri = wxConfig.getString("openPayUri");
            log.debug(openPayUri);

            JSONObject message = new JSONObject();
            JSONObject head = new JSONObject();
            JSONObject body = new JSONObject();
            head.put("version", "1.0.0");
            head.put("trancode", "reconcile");
            head.put("msgId", PayUtil.getOrderNoByNumber());
            head.put("channelId", channelId);
            message.put("head", head);
            body.put("txnDate", json.getString("txnDate"));
            message.put("body", body);
            String plaintext = message.toString();
            log.debug("下单明文为：{}", plaintext);
            // 加密
            String ciphertext = PSBCSignUtils.encrypt(channelId, plaintext);
            // 加签
            String signature = PSBCSignUtils.sign(channelId, ciphertext);
            String cipherInfo = signature + "|+|" + ciphertext;
            String uri = openPayUri + channelId;
            // 调用缴费平台接口
            String response = new HttpService().sendPost(uri, cipherInfo);

            //httpService.sendPost(uri, cipherInfo);
            log.info("接口返回密文为：{}", response);

            // 解密返回报文
            String res =  PSBCSignUtils.decrypt(response, channelId);
            JSONObject data = new JSONObject(res);
            log.info("对账接口返回明文：{}", res);
            if ("000000".equals(data.getJSONObject("head").getString("respCode"))) {
                final String zipFilePath = Config.wechatConfig.getString("mendRecordPath") + channelId + ".zip";
                final String unzipDir = Config.wechatConfig.getString("mendRecordPath") + channelId;
                FileUtils.decodeFileContent(zipFilePath,data.getJSONObject("body").getString("fileContent"));
                FileUtils.unzip(zipFilePath, unzipDir);
                log.info("下载成功");
                // 添加到数据库
                String fileName = data.getJSONObject("body").getString("fileName");
                File createFile = new File(unzipDir);
                File[] files = createFile.listFiles();
                if(files==null||files.length==0) {
                    log.debug("该文件没有任何东西");
                }else {
                    for(File file : files) {
                        log.debug("文件名"+file.getName());
                        // 判断是否是文件,true:是文件,false:不是文件
                        if (file.isFile() && fileName.equals(file.getName())) {
                            try {
                                List<String> lines = org.apache.commons.io.FileUtils.readLines(file, "GBK");
                                Iterator temp = lines.iterator();
                                while(temp.hasNext()) {
                                    String line1 = String.valueOf(temp.next());
                                    String line  =line1.replace("|-|","");
                                    log.info("line的值是===>" + line);
                                    String[] lineValues = line.split("\\|\\+\\|");
                                    log.info("每行数据的参数:" + Arrays.toString(lineValues));
                                    log.info("每行数据的参数长度:" + lineValues.length);
                                    if (lineValues.length > 7) {
                                        log.info("时间:" + lineValues[1]);
                                        Date sDate = new SimpleDateFormat("yyyyMMddHHmmss").parse(lineValues[1]);
                                        String f_trade_date =new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(sDate);
                                        JSONObject jsonObject = new JSONObject();
                                        //  交易时间
                                        jsonObject.put("f_trade_date", f_trade_date);
                                        // 订单号
                                        jsonObject.put("f_trade_number", lineValues[2]);
                                        // 金额
                                        jsonObject.put("f_total_charge", lineValues[7]);
                                        jsonObject.put("f_gas_fee", lineValues[7]);
                                        //银行名称
                                        jsonObject.put("f_bank_name", "中国邮政储蓄银行");
                                        if (lineValues[2].indexOf("SN") >= 0) {
                                            //付款方式
                                            jsonObject.put("f_payment", "跨屏扫");
                                        } else {
                                            //付款方式
                                            jsonObject.put("f_payment", "微信公众号");
                                        }
                                        // 平台订单号
                                        jsonObject.put("f_trade_code", lineValues[3]);
                                        //  缴费项目编号
                                        jsonObject.put("f_organizat_id", lineValues[4]);
                                        log.debug(jsonObject.toString());

									    logicServer.run("saveBankPayment", jsonObject);
                                        // 更新中间表状态
                                    }
                                }
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                result.put("stute", "fail");
                result.put("respMsg", data.getJSONObject("head").getString("respMsg"));
            }
        } catch (Exception e) {
            result.put("stute", "fail");
            result.put("respMsg", e);
            log.debug("长安银行下单异常错误", e);
        }
        return result;
    }


    @Override
    public String refund(JSONObject json) {
        return null;
    }

    @Override
    public String refundOrderStatus(String value) {
        return null;
    }
}
