package com.aote.pay.icbc.shanggaoshunming;

import TestClass.HttpRequest;
import TestClass.Signature;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.sql.SqlServer;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import com.icbc.api.DefaultIcbcClient;
import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcConstants;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.request.MybankPayQrcodeScannedPayRequestV2;
import com.icbc.api.request.MybankPayQrcodeScannedPaystatusRequestV2;
import com.icbc.api.response.MybankPayQrcodeScannedPaystatusResponseV2;
import com.icbc.api.response.MybankQrcodeScannedPayResponseV2;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @Author 史睿
 * @Date 2022/1/22
 * @Version 1.0
 * @describe 江西银行-上高被扫
 */
@Slf4j
@Component
public class MicroPayShunMing implements PaySuper, RefundSuper {

    @Autowired
    private LogicServer logicServer;

    @Autowired
    private SqlServer sqlServer;

    @Autowired
    JsApiShunMing jsApiShunMing;
    

    // 版本号,固定填写
    String version = "1.0.0";
    // 编码方式,固定填写
    String encode = "UTF-8";

    /**
     * 上高顺民被扫支付接口
     * @param json 包含授权码等相关信息的json对象
     * @return 订单状态
     */
    @Override
    public String prePay(JSONObject json) {
        Object money = json.get("money");
        String attach = json.getJSONObject("attach").toString();
 //       String userfilesid = json.getString("userfilesid");
//        分公司名称
        String filiale = String.valueOf(json.get("filiale"));

        if (filiale == null || filiale.length() == 0) {
            throw new RuntimeException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
        // 交易代码,固定填写
        String trtype = "GP00011";
        // 交易日期，格式为yyyyMMdd
        String trdate = new SimpleDateFormat("yyyyMMdd").format(new Date());
        // 交易时间，格式为hhmmss
        String trtime = new SimpleDateFormat("hhmmss").format(new Date());
        String subcode = "guokai.gpay.sweptPay";

        // 交易流水号
        String serialno = PayUtil.getOutTradeNo();


        // 商户号
        String busino = wxConfig.getString("busino");
//        用户付款码
        String authCode = String.valueOf(json.get("auth_code"));
        // deleteValue商户订单号，商户端保证唯一
        String orderno = PayUtil.getOrderNoByNumber();


        // 订单金额，单位为分
        String amt_trans = String.valueOf(PayUtil.yuan2FenInt(money));

        // 货币代码，默认156
        String currency = "156";

        // 订单主题
        String ordertitle = wxConfig.getString("ordertitle");

        // 商品描述
        String orderdesc = wxConfig.getString("orderdesc");

        // 前台返回商户结果时使用
        String return_url = wxConfig.getString("return_url");

        // 异步通知商户URL，端口必须 为443或80
        String notify_url = wxConfig.getString("wechatNotify");

        // 渠道类型,07-PC 08-WAP
        String channel_type = wxConfig.getString("channel_type");

        // 确认收货标志, 0线上确认收货，8线上待收货(暂不启用)，9线下免确认收货 默认请填9
        String confflag = wxConfig.getString("confflag");

        // 签名方式，固定填写
        String sign_type = "RSA";



        // 验签字段
        Map<String, String> map = new HashMap<>();
        map.put("version", version);
        map.put("encode", encode);
        map.put("trdate", trdate);
        map.put("trtime", trtime);
        map.put("trtype", trtype);
        map.put("subcode", subcode);
        map.put("serialno", serialno);
        map.put("busino", busino);
        map.put("auth_code", authCode);
        map.put("orderno", orderno);
        map.put("amt_trans", amt_trans);
        map.put("currency", currency);
        map.put("ordertitle", ordertitle);
        map.put("orderdesc", orderdesc);
        map.put("notify_url", notify_url);
        map.put("return_url", return_url);
        map.put("channel_type", channel_type);
        map.put("confflag", confflag);
        map.put("sign_type", sign_type);
        // 公钥
        String publicKey = wxConfig.getString("publicKey");
        // 私钥
        String privateKey = wxConfig.getString("privateKey");
        //
        String apiKey = wxConfig.getString("apiKey");

        Signature signature = new Signature();

        String signMsg = signature.rsa256Sign(map, apiKey, privateKey);

        if (!signMsg.isEmpty()) {
            log.debug("报文加签成功，签名值：" + signMsg);
        } else {
            log.debug("报文加签失败！！");
        }
        map.put("sign", signMsg);

        // 下单地址
        String microPayUrl = wxConfig.getString("microPayUrl");

        log.debug("江西银行扫码支付地址: {},下单参数: {}", microPayUrl, HttpRequest.getParamStr(map));

            try {
                String response = HttpRequest.sendPost(microPayUrl, HttpRequest.getParamStr(map));
                JSONObject responsejson = new JSONObject();
                String[] res = response.split("&");
                for (String re : res) {
                    int split = re.indexOf('=');
                    String key = re.substring(0, split);
                    String value = re.substring(split + 1);
                    responsejson.put(key, value);
                }
                log.debug("江西银行下单返回数据");
                log.debug("江西银行下单返回数据: {}", responsejson);
                if ("00000".equals(responsejson.getString("respcode"))) {
                    // 返回订单号
                    result.put("f_out_trade_no", orderno);
                    JSONObject saveOrder = new JSONObject();
//                    订单状态
                    switch (responsejson.getString("status")){
                        case "-1":
//                        下单失败
                            throw new RuntimeException("付款码下单失败,银行返回信息:" + responsejson.getString("respmsg"));
                        case "1":
//                        支付中
                            saveOrder.put("f_order_state", "待查询");
                            result.put("result_msg", "支付结果未知");
                            break;
                        case "0":
//                        支付成功
                            saveOrder.put("f_order_state", "已支付");
                            result.put("result_msg", "支付确认成功");
                            break;
                        case "4":
//                        支付失败
                            result.put("result_msg", "支付确认失败");
                        case "9":
//                        支付结果未知
                            saveOrder.put("f_order_state", "待查询");
                            result.put("result_msg", "支付结果未知");
                            break;
                    }
                    JSONObject param = new JSONObject(attach);
                    // 二维码类型
                    String qrcodetype = responsejson.optString("pay_type","00081");
                    String qrcodename = "";
                    switch (qrcodetype) {
                        case "00015":
                            qrcodename = "银联二维码";
                            break;
                        case "00081":
                            qrcodename = "微信支付";
                            break;
                        case "00091":
                            qrcodename = "支付宝支付";
                            break;
                        default:
                            qrcodename = "未知";
                    }
                    result.put("qrcodetype", qrcodename);
                    String userFilesId = param.optString("f_userfiles_id", "");
                    saveOrder.put("f_out_trade_no", orderno);
                    saveOrder.put("f_serialno", serialno);
                    saveOrder.put("f_attach", attach);
                    saveOrder.put("f_order_type", "燃气收费");
                    //saveOrder.put("f_order_state", "已支付");
                    saveOrder.put("f_trdate", trdate);
                    saveOrder.put("f_trtime", trdate);
                    saveOrder.put("flag", "MicroPayShunMing");
                    saveOrder.put("f_trade_type", "MICROPAY");
                    saveOrder.put("f_filiale", filiale);
                    saveOrder.put("f_bank_type", qrcodename);
                    saveOrder.put("f_total_fee", String.valueOf(PayUtil.yuan2FenInt(money)));
                    saveOrder.put("f_userfiles_id", userFilesId);
                    // 保存分公司id
                    JSONObject clientConfig = Config.getClientConfig(filiale);
                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                    logicServer.run("savewxreturnxml", saveOrder);
                }
            } catch (Exception var9) {
                var9.printStackTrace();
            }
        } catch (Exception e) {
            log.debug("上高惠付款码下单异常错误", e);
            result.put("result_msg", "支付确认失败");
            result.put("err_msg", e.getMessage());
        }

        return result.toString();
    }

    /**
     * 顺民被扫支付订单状态查询
     * @param value
     * @return
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));

            JSONObject sqlParam = new JSONObject();
            sqlParam.put("f_out_trade_no", jsonObject.getString("out_trade_no"));
            JSONArray query = sqlServer.query("microPayOrderQuery", sqlParam);
            if (query.length() > 0) {
                jsonObject = (JSONObject) query.get(0);
            }else {
                result.put("result_code", "FAIL");
                result.put("return_msg", "查询失败");
                return result.toString();
            }

            // 交易代码,固定填写
            String trtype = "GP00063";
            // 交易日期，格式为yyyyMMdd
            String trdate = jsonObject.getString("f_trdate");
            // 交易时间，格式为hhmmss
            String trtime = jsonObject.getString("f_trtime");
            // 固定
            String subcode = "guokai.gpay.consumeQuery";
            // 交易流水号
            String serialno = jsonObject.getString("f_serialno");
            // 商户号
            String busino = wxConfig.getString("busino");
            // 商户订单号
            String orderno = jsonObject.getString("out_trade_no");
            // 签名方式，固定填写
            String sign_type = "RSA";

            // 验签字段
            LinkedHashMap<String, String> map = new LinkedHashMap<>();
            map.put("version", version);
            map.put("encode", encode);
            map.put("trdate", trdate);
            map.put("trtime", trtime);
            map.put("trtype", trtype);
            map.put("subcode", subcode);
            map.put("serialno", serialno);
            map.put("busino", busino);
            map.put("orderno", orderno);
            map.put("sign_type", sign_type);

            // 公钥
            String publicKey = wxConfig.getString("publicKey");
            // 私钥
            String privateKey = wxConfig.getString("privateKey");
            //
            String apiKey = wxConfig.getString("apiKey");

            Signature signature = new Signature();
            String signMsg = signature.rsa256Sign(map, apiKey, privateKey);
            if (!signMsg.isEmpty()) {
                log.debug("报文加签成功，签名值：" + signMsg);
            } else {
                log.debug("报文加签失败！！");
            }
            map.put("sign", signMsg);

            // 下单地址
            String queryUrl = wxConfig.getString("queryUrl");
            log.debug("江西银行查询地址: {},查询参数: {}", queryUrl, new JSONObject(map));

            try {
                String response = HttpRequest.sendPost(queryUrl, HttpRequest.getParamStr(map));
                JSONObject responsejson = new JSONObject();
                String[] res = response.split("&");
                for (String re : res) {
                    int split = re.indexOf('=');
                    String key = re.substring(0, split);
                    String val = re.substring(split + 1);
                    responsejson.put(key, val);
                }
                log.debug("江西银行查询返回信息: {}", responsejson);
                if ("00000".equals(responsejson.getString("respcode"))) {
                    // 支付状态，0 处理成功  9 初始状态  1待支付返回/状态未知  4-支付结果为失败
                    if ("0".equals(responsejson.getString("status"))) {
                        this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state = '已支付', f_transaction_id = '"+jsonObject.getString("out_trade_no")+"', f_imp_tradeno ='"+responsejson.getString("imp_tradeno")+"',f_transno = '" + responsejson.getString("transno") + "' where id = '" +  jsonObject.getInt("id") + "'");
                        result.put("result_msg", "支付确认成功");
                        result.put("trade_state", "Y");

                        // 订单号
                        result.put("transaction_id", responsejson.getString("chn_tradeno"));
                        // 交易日期
                        result.put("time_end", responsejson.getString("transdate") + responsejson.getString("transtime"));
                        // 交易金额
                        result.put("total_fee", responsejson.getString("amt_trans"));
                    } else if ("4".equals(responsejson.getString("status"))) {
                        result.put("trade_state", "N");
                        result.put("result_code", "FAIL");
                        result.put("return_msg", responsejson.getString("status"));
                        log.debug("订单状态为支付失败：" + responsejson.getString("status"));
                    } else {
                        result.put("trade_state", "W");
                        result.put("return_msg", responsejson.getString("status"));
                        log.debug("订单状态为未知：" + responsejson.getString("status"));
                    }
                } else {

                    result.put("trade_state", "N");
                    result.put("result_code", "FAIL");
                    result.put("return_msg", responsejson.getString("respmsg"));
                    log.debug("查询失败", responsejson.getString("respmsg"));
                }
            } catch (Exception var9) {
                log.error("操作失败：原因" + var9.getMessage());
                result.put("trade_state", "N");
                result.put("result_code", "FAIL");
                result.put("return_msg", "系统异常");
                var9.printStackTrace();
            }
        } catch (Exception e) {
            result.put("trade_state", "N");
            log.debug("江西银行查询订单异常：" + e);
        }
        return result.toString();
    }

    @Override
    public String refund(JSONObject json) {
        return jsApiShunMing.refund(json);
    }

    @Override
    public String refundOrderStatus(String value) {
        return jsApiShunMing.refundOrderStatus(value);
    }

    @Override
    public JSONObject getRecordFile(JSONObject json) {
        return null;
    }
}
