package com.aote.pay.cup_shanxian;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import com.aote.entity.PayBodyEntity;
import com.aote.entity.QueryBodyEntity;
import com.aote.entity.WebPayBodyEntity;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.sql.SqlServer;
import com.aote.util.*;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;
import javax.crypto.spec.SecretKeySpec;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import javax.crypto.Mac;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.*;
import java.net.URLEncoder;

@Slf4j
@Component
public class JsApiShanXian implements PaySuper, RefundSuper {

    @Autowired
    private LogicServer logicServer;

    @Autowired
    private SqlServer sqlServer;
    

    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        HttpServletRequest request = (HttpServletRequest) json.get("request");

        if (filiale == null || filiale.length() == 0) {
            throw new RuntimeException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            Date date = new Date();
            SimpleDateFormat dateFormat= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            // 请求时间
            String requestTimestamp = dateFormat.format(date);
            String timestamp =  new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            //
            String msgSrcId = wxConfig.getString("msgSrcId");
            // 日期17位
            String format = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            // 商户订单号
            String merOrderId = msgSrcId + format +  RandomUtil.randomNumbers(7);
            // 商户号
            String mid = wxConfig.getString("mid");
            // 终端号
            String tid = wxConfig.getString("tid");
            // 业务类型
            String instMid = "YUEDANDEFAULT";
            // 金额
            String totalAmount = String.valueOf(PayUtil.yuan2FenInt(money));
            //AppId
            String subAppId =  wxConfig.getString("appId");
            String appid = wxConfig.getString("bankAppid");
            String appkey = wxConfig.getString("bankAppkey");

            String url =  wxConfig.getString("payUrl");
            //OpenId
            String subOpenId = openid;

            PayBodyEntity reqBody = new PayBodyEntity();
            reqBody.setRequestTimestamp(requestTimestamp);
            reqBody.setMerOrderId(merOrderId);
            reqBody.setMid(mid);
            reqBody.setTid(tid);
            reqBody.setInstMid(instMid);
            reqBody.setTotalAmount(totalAmount);

            //2. 获取认证报文，timestamp为当前日期，老旧日期无法请求成功
            String authorization = "OPEN-FORM-PARAM";
            String signature = getSignature(appid,appkey,timestamp,"nonce",reqBody.toString());
            String URL = url + "?" + "authorization=" + authorization + "&appId=" + appid
                    + "&timestamp=" + timestamp + "&nonce=" + "nonce" + "&content=" + URLEncoder.encode(reqBody.toString(),"UTF-8")
                    + "&signature=" + URLEncoder.encode(signature,"UTF-8");
            //3. 发送http请求，并解析返回信息
            String response = URL;
            log.debug(response);
            // 保存下单信息到中间表
            JSONObject saveOrder = new JSONObject();
            saveOrder.put("f_out_trade_no", merOrderId);
            saveOrder.put("f_attach", attach);
            saveOrder.put("f_openid", openid);
            saveOrder.put("flag", "JsApiShanXian");
            saveOrder.put("f_order_state", "已下单");
            saveOrder.put("f_order_type", "燃气收费");
            saveOrder.put("f_trade_type", "JSAPI");
            saveOrder.put("f_filiale", filiale);
            saveOrder.put("f_total_fee", String.valueOf(PayUtil.yuan2FenInt(money)));
            // 保存分公司id
            JSONObject clientConfig = Config.getClientConfig(filiale);
            saveOrder.put("f_orgid", clientConfig.get("orgStr"));
            logicServer.run("savewxreturnxml", saveOrder);
            result.put("url",response);
        }catch (Exception e) {
            log.debug("单县银联下单异常错误", e);
        }

        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            String outTradeNo = jsonObject.getString("out_trade_no");
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String selectUrl = wxConfig.getString("selectUrl");
            String f_create_time = jsonObject.getString("f_create_time");
            Date date = new Date();
            SimpleDateFormat dateFormat= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp =  new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());

            // 请求时间
            String requestTimestamp = dateFormat.format(date);
            // 商户号
            String mid = wxConfig.getString("mid");
            // 终端号
            String tid = wxConfig.getString("tid");
            String appid = wxConfig.getString("bankAppid");
            String appkey = wxConfig.getString("bankAppkey");
            //1. 组建请求报文
            QueryBodyEntity reqBody = new QueryBodyEntity();
            reqBody.setRequestTimestamp(requestTimestamp);
            reqBody.setMid(mid);
            reqBody.setTid(tid);
            reqBody.setInstMid("YUEDANDEFAULT");
            reqBody.setMerOrderId(outTradeNo);
            System.out.println("request body:\n"+reqBody);
            //2. 获取认证报文，timestamp为当前日期，老旧日期无法请求成功
            String authorization = getAuthorization(appid,appkey,timestamp,"nonce",reqBody.toString());
            System.out.println("authorization:\n"+authorization);
            //3. 发送http请求，并解析返回信息
            JSONObject response = new JSONObject(request(selectUrl,authorization,reqBody.toString()));

            log.debug(response.toString());
            if ("SUCCESS".equals(response.optString("errCode",""))) {
                if ("TRADE_SUCCESS".equals(response.getString("status"))){
                    String transaction_id = response.getString("merOrderId");
                    String time_end =  new SimpleDateFormat("yyyyMMddHHmmss").format( DateUtil.parseDateTime(f_create_time));
                    String total_fee = String.valueOf(response.getInt("totalAmount"));

                    result.put("total_fee", total_fee);
                    result.put("transaction_id", transaction_id);
                    result.put("time_end", time_end);
                    result.put("trade_state", "SUCCESS");
                    log.debug("交易金额total_fee : " + total_fee);
                    log.debug("订单号f_transaction_id : " + transaction_id);
                    log.debug("交易日期time_end : " + time_end);
                } else {
                    result.put("result_code", "FAIL");
                    result.put("error", "订单状态不等于已支付");
                }
            } else {
                result.put("result_code", "FAIL");
                result.put("error", "系统错误");
            }

        } catch (Exception e) {
            log.debug("操作失败, 原因: {}", e);
            result.put("error", "系统异常");
        }
        return result.toString();
    }

    @Override
    public String refund(JSONObject json) {
        String filiale = json.getString("f_filiale");
        Integer id = json.getInt("id");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        log.debug("进入");
        JSONObject result = new JSONObject();
        try {
            String appid = wxConfig.getString("bankAppid");
            String appkey = wxConfig.getString("bankAppkey");
            String refundUrl =wxConfig.getString("refundUrl");
            String tid = wxConfig.getString("tid");
            String mid = wxConfig.getString("mid");
            String instMid = "YUEDANDEFAULT";
            String orderAmount = String.valueOf(json.get("f_total_fee"));
            // 商户退款订单号
            String merOrderId = json.getString("f_out_trade_no");

            Date date = new Date();
            SimpleDateFormat dateFormat= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp =  new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());

            // 请求时间
            String requestTimestamp = dateFormat.format(date);
            //1. 组建请求报文
            WebPayBodyEntity reqBody = new WebPayBodyEntity();
            reqBody.setRequestTimestamp(requestTimestamp);
            reqBody.setMerOrderId(merOrderId);
            reqBody.setMid(mid);
            reqBody.setTid(tid);
            reqBody.setInstMid(instMid);
            reqBody.setRefundAmount(orderAmount);


            log.debug("科莱民银行退款地址: {},退款参数: {}", refundUrl, reqBody);
            //2. 获取认证报文，timestamp为当前日期，老旧日期无法请求成功
            String authorization = getAuthorization(appid,appkey,timestamp,"nonce",reqBody.toString());
            System.out.println("authorization:\n"+authorization);
            //3. 发送http请求，并解析返回信息
            JSONObject response = new JSONObject(request(refundUrl,authorization,reqBody.toString()));
            log.debug("科莱民银行退款返回:"+response);
            JSONObject saveOrder = new JSONObject();
            if ("SUCCESS".equals(response.getString("errCode"))) {
                if ("SUCCESS".equals(response.getString("refundStatus"))){
                    //退款成功
                    saveOrder.put("f_order_state", "已退款");
                } else if ("FAIL".equals(response.getString("refundStatus"))){
                } else {
                    saveOrder.put("f_order_state", "退款中");
                }
            }
            saveOrder.put("id", id);
//            saveOrder.put("f_refund_no",);

            logicServer.run("savewxreturnxml", saveOrder);
        } catch (Exception e) {
            log.debug(e.toString());
        }
        return result.toString();
    }

    @Override
    public String refundOrderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询退款订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            String outTradeNo = jsonObject.getString("out_trade_no");
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String refundSelectUrl = wxConfig.getString("selectUrl");
            Integer id = jsonObject.getInt("id");
            Date date = new Date();
            SimpleDateFormat dateFormat= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp =  new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            // 商户号
            String mid = wxConfig.getString("mid");
            // 终端号
            String tid = wxConfig.getString("tid");
            String appid = wxConfig.getString("bankAppid");
            String appkey = wxConfig.getString("bankAppkey");
            // 请求时间
            String requestTimestamp = dateFormat.format(date);
            //1. 组建请求报文
            QueryBodyEntity reqBody = new QueryBodyEntity();
            reqBody.setRequestTimestamp(requestTimestamp);
            reqBody.setMid(mid);
            reqBody.setTid(tid);
            reqBody.setInstMid("YUEDANDEFAULT");
            reqBody.setMerOrderId(outTradeNo);
            System.out.println("request body:\n"+reqBody);
            //2. 获取认证报文，timestamp为当前日期，老旧日期无法请求成功
            String authorization = getAuthorization(appid,appkey,timestamp,"nonce",reqBody.toString());
            System.out.println("authorization:\n"+authorization);
            //3. 发送http请求，并解析返回信息
            JSONObject response = new JSONObject(request(refundSelectUrl,authorization,reqBody.toString()));
            log.debug(response.toString());
            if ("SUCCESS".equals(response.getString("errCode"))) {
                if ("SUCCESS".equals(response.getString("refundStatus"))){
                    this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已退款' where id = '" + id + "'");
                    result.put("result_msg", "退款成功");
                    log.debug(result.toString());
                } else if ("FAIL".equals(response.getString("refundStatus"))){
                } else {
                    result.put("return_msg", "退款处理中");
                }
            }
        } catch (Exception e) {
            result.put("return_msg", "查询失败");
            log.debug("查询订单异常：" + e);
        }
        log.debug("查询订单返回: {}", result);
        return result.toString();
    }

    @Override
    public JSONObject getRecordFile(JSONObject json) {
        return null;
    }



    /**
     * 获取签名头
     * @param appid
     * @param appkey
     * @param timestamp 格式:"yyyyMMddHHmmss"
     * @param nonce 随机字符串，
     * @param body 请求体
     * @return authorization 认证报文
     * @throws Exception
     */
    static String getSignature(String appid, String appkey, String timestamp, String nonce, String body) throws Exception {
        byte[] data = body.getBytes("utf-8");
        InputStream is = new ByteArrayInputStream(data);
        String testSH = DigestUtils.sha256Hex(is);
        String s1 = appid+timestamp+nonce+testSH;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(appkey.getBytes("utf-8"),"HmacSHA256"));
        byte[] localSignature = mac.doFinal(s1.getBytes("utf-8"));
        String localSignatureStr = Base64.encodeBase64String(localSignature);
        return localSignatureStr;
    }

    /**
     * 获取签名头
     * @param appid
     * @param appkey
     * @param timestamp 格式:"yyyyMMddHHmmss"
     * @param nonce 随机字符串，
     * @param body 请求体
     * @return authorization 认证报文
     * @throws Exception
     */
    static String getAuthorization(String appid, String appkey, String timestamp, String nonce, String body) throws Exception {
        byte[] data = body.getBytes("utf-8");
        InputStream is = new ByteArrayInputStream(data);
        String testSH = DigestUtils.sha256Hex(is);
        String s1 = appid+timestamp+nonce+testSH;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(appkey.getBytes("utf-8"),"HmacSHA256"));
        byte[] localSignature = mac.doFinal(s1.getBytes("utf-8"));
        String localSignatureStr = Base64.encodeBase64String(localSignature);
        return  "OPEN-BODY-SIG AppId="+"\""+appid+"\""+", Timestamp="+"\""+timestamp+"\""+", Nonce="+"\""+nonce+"\""+", Signature="+"\""+localSignatureStr+"\"";
    }



    /**
     * 发送http请求
     * @param url 请求url
     * @param authorization 认证报文
     * @param reqBody  请求体
     * @return response
     */
    static String request(String url, String authorization, String reqBody){
        String response = "";
        PrintWriter out = null;
        BufferedReader in = null;
        try{
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            HttpURLConnection httpUrlConnection = (HttpURLConnection) conn;
            httpUrlConnection.setRequestProperty("Content-Type", "application/json");
            httpUrlConnection.setRequestProperty("authorization",authorization);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setReadTimeout(18000);
            httpUrlConnection.setConnectTimeout(18000);
            httpUrlConnection.setDoInput(true);
            out = new PrintWriter(httpUrlConnection.getOutputStream());
            out.write(reqBody);
            out.flush();
            httpUrlConnection.connect();
            in = new BufferedReader(new InputStreamReader(httpUrlConnection.getInputStream()));
            String line;
            while ((line = in.readLine()) != null) {
                response += line;
            }
        }catch(Exception e){
            e.printStackTrace();
        } finally {
            try {
                if (out != null) { out.close();}
                if (in != null) {in.close();}
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return response;
    }

}
