package com.aote.weixin.timer;

import com.af.plugins.JsonTools;
import com.aote.module.ModuleMapper;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.quartz.*;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

@Component
public class SchedulerService implements ApplicationContextAware {

	private static final Logger LOGGER = Logger.getLogger(MyQuartzJobBean.class);

	@Autowired
	private Scheduler scheduler;
	@Autowired
	private JobDetail jobDetail;

	private ApplicationContext context;

	/**
	 * 业务列表
	 */
	private static final String BUSINESS_LIST_PATH = "timerBusiness.json";

	@PostConstruct
	public void init() throws ParseException {
		// 获取所有引入的表具模块名
		Map<String, Map<String, String>> map = ModuleMapper.getMap();
		for (String moduleName : map.keySet()) {
			String modulePath = map.get(moduleName).get("path");
			if (modulePath == null) {
				modulePath = "";
			} else {
				modulePath = modulePath + "/";
			}
			//获取每个模块下的Timer业务配置文件
			String businessListPath = modulePath + moduleName + "/" + BUSINESS_LIST_PATH;
			if (SchedulerService.class.getClassLoader().getResourceAsStream(businessListPath) != null) {
				JSONArray business = JsonTools.readJsonArrayFile(businessListPath);
				for(int i = 0; i < business.length(); i++){
					JSONObject item = business.getJSONObject(i);
					if(item.optBoolean("enable", false)) {
						item.put("moduleName",moduleName);
						//加入到调度任务队列
						schedule(item.getString("name"),
								new CronExpression(item.getString("expression")),item);
					}
				}
			}
		}
	}

	public void schedule(String name, CronExpression cronExpression, JSONObject dataMap) {
		if (isValidExpression(cronExpression)) {
			CronTriggerImpl trigger = new CronTriggerImpl();
			trigger.setCronExpression(cronExpression);
			TriggerKey triggerKey = new TriggerKey(name, "weixin");
			trigger.setKey(triggerKey);
			try {
				if(dataMap.has("beanName")){
					Object beanObject = context.getBean(dataMap.getString("beanName"));
					MethodInvokingJobDetailFactoryBean bean = new MethodInvokingJobDetailFactoryBean();
					bean.setName(dataMap.getString("beanName")+ "-" +dataMap.getString("runMethod"));
					bean.setConcurrent(false);
					bean.setTargetObject(beanObject);
					bean.setTargetMethod(dataMap.getString("runMethod"));
					bean.afterPropertiesSet();
					trigger.setJobName(bean.getObject().getKey().getName());
					scheduler.addJob(bean.getObject(), true);
				} else {
					trigger.setJobName(jobDetail.getKey().getName());
					scheduler.addJob(jobDetail, true);
				}
				LOGGER.info("["+name+"]已加入调度任务队列");
				if (scheduler.checkExists(triggerKey)) {
					scheduler.rescheduleJob(triggerKey, trigger);
				} else {
					scheduler.scheduleJob(trigger);
				}
			} catch (SchedulerException e) {
				throw new IllegalArgumentException(e);
			} catch (NoSuchMethodException | ClassNotFoundException e) {
				e.printStackTrace();
			}
		}
	}

	private boolean isValidExpression(final CronExpression cronExpression) {

		CronTriggerImpl trigger = new CronTriggerImpl();
		trigger.setCronExpression(cronExpression);

		Date date = trigger.computeFirstFireTime(null);

		return date != null && date.after(new Date());
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.context = applicationContext;
	}
}
