package com.aote.util.image;

import com.af.plugins.CommonTools;
import com.af.plugins.JsonTools;
import com.af.plugins.RestTools;
import org.json.JSONObject;

import java.io.IOException;

public class ImageUtil {

    /**
     * 地址
     */
    private static final String PICTURE_URL = "http://47.105.172.196:8000";
    /**
     * 用户名
     */
    private static final String USER_NAME = "admin";
    /**
     * 密码
     */
    private static final String PASSWORD = "admin";

    /**
     * 图像数据上传，获取文本
     * @param id 请求访问的唯一标识
     * @param imageData 图像信息
     * @return 识别的文本结果
     */
    public static String getImageText(String id,ImageData imageData){
        JSONObject params = new JSONObject();
        if(imageData.getImageType().equals("jpg")){
            params.put("PictureType",16);
        } else {
            params.put("PictureType",32);
        }
        JSONObject imageRequestData = new JSONObject();
        imageRequestData.put("SizeRow",imageData.getWidth());
        imageRequestData.put("SizeCol",imageData.getHeight());
        imageRequestData.put("imData",imageData.getBase64Str());
        params.put("ImageData",imageRequestData);
        params.put("PicIdx",imageData.getName());
        params.put("UserID",id);
        params.put("DataType",4);
        JSONObject result = JsonTools.convertToJson(RestTools.post(PICTURE_URL,params));
        String identifyResult = result.getString("IdentifyResult");
        identifyResult = identifyResult.substring(1,identifyResult.length() - 1).replace(" ","");
        return identifyResult;
    }

    /**
     * 识别软件状态查询
     * @param id 请求访问的唯一标识
     * @return 结果
     */
    public static JSONObject getStatus(String id){
        JSONObject requestParams = new JSONObject();
        requestParams.put("DataType",2);
        requestParams.put("UserName",USER_NAME);
        requestParams.put("Passwd",PASSWORD);
        requestParams.put("UserID",id);
        JSONObject requestResult = new JSONObject(RestTools.post(PICTURE_URL,requestParams));
        JSONObject result = new JSONObject();
        if(requestResult.has("ServiceStatus")){
            if(requestResult.getInt("ServiceStatus") == 1){
                result.put("status","正常");
            } else {
                result.put("status","未就绪");
                result.put("message",requestResult.toString());
            }
        } else {
            result.put("status","服务异常");
        }
        return result;
    }

    public static String getWeiXinText(String code,JSONObject params) throws IOException {
        //获取请求访问的唯一标识
        String id = code;
        //获取识别软件就绪状态
        JSONObject statusObject = getStatus(id);
        String status = statusObject.getString("status");
        switch (status) {
            case "正常":
                ImageData imageData = ImageData.getImageData(
                        params.getString("filename"),
                        params.getString("filebase"),
                        params.getInt("filewidth"),
                        params.getInt("filehight"),
                        params.getString("fileType"));
                return getImageText(id,imageData);
            case "未就绪":
                throw new RuntimeException("识别软件未就绪！");
            default:
                throw new RuntimeException("网络异常:" + statusObject.getString("message"));
        }
    }

    public static void main(String[] args) throws IOException {
        //获取请求访问的唯一标识
        String id = CommonTools.getUUID();
        //获取识别软件就绪状态
        JSONObject statusObject = getStatus(id);
        String status = statusObject.getString("status");
        if(status.equals("正常")){
            //System.out.println(getImageText(id,ImageData.getImageData("D:\\1.jpg")));
        } else if(status.equals("未就绪")){
            throw new RuntimeException("识别软件未就绪！");
        } else {
            throw new RuntimeException("网络异常:"+statusObject.getString("message"));
        }
    }
}
