package com.aote.util;
import com.aote.weixin.timer.OrderProcess;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public  class PSBCSignUtils {
    static Logger log = Logger.getLogger(PSBCSignUtils.class);
    public static String openPayPrivateKey;

    public static  String openPayPublicKey;
    // 渠道单位私钥
    private  final static ConcurrentMap<String, BCECPrivateKey> PRI_KEY_PARAMS = new ConcurrentHashMap<>();
    // 缴费平台公钥
    private final static ConcurrentMap<String, BCECPublicKey> PUB_KEY_PARAMS = new ConcurrentHashMap<>();

    public static String encrypt(String channelId, String plaintext) throws InvalidCipherTextException {
        BCECPublicKey publicKey = PUB_KEY_PARAMS.get(channelId);
        if (publicKey == null) {
            // 支付缴费热加载证书
            reloadPaymentCert(channelId);
            publicKey = PUB_KEY_PARAMS.get(channelId);
        }
        final byte[] plaintextBytes = plaintext.getBytes(StandardCharsets.UTF_8);
        final byte[] encodedPlaintext = Base64.encode(plaintextBytes);
        final byte[] ciphertextBytes = SM2Utils.encrypt(publicKey, encodedPlaintext);
        return Base64.toBase64String(ciphertextBytes);
    }
    public static void reloadPaymentCert(final String channelId) {
        //支付缴费证书管理加载
        try {
            log.debug("支付缴费证书管理加载缴费平台公钥:openPayPublicKey"+openPayPublicKey);
            // 缴费平台公钥
            final byte[] publicKeyBytes = Base64.decode(openPayPublicKey);
            final BCECPublicKey publicKey = BCECUtils.convertX509ToECPublicKey(publicKeyBytes);
            // 渠道单位私钥
            log.debug("支付缴费证书管理加载渠道单位私钥:openPayPrivateKey"+openPayPublicKey);
            final byte[] privateKeyBytes = Base64.decode(openPayPrivateKey);
            final BCECPrivateKey privateKey = BCECUtils.convertPKCS8ToECPrivateKey(privateKeyBytes);
            PUB_KEY_PARAMS.put(channelId, publicKey);
            PRI_KEY_PARAMS.put(channelId, privateKey);
        } catch (final Exception e) {
            log.debug("获取密钥出错:" + e);
            throw new RuntimeException("获取密钥出错", e);
        }
    }

    public static String sign(String channelId, String ciphertext) throws CryptoException {
        BCECPrivateKey privateKey = PRI_KEY_PARAMS.get(channelId);
        if (privateKey == null) {
            // 支付缴费热加载证书
            reloadPaymentCert(channelId);
            privateKey = PRI_KEY_PARAMS.get(channelId);
        }
        final byte[] signCiphertextBytes = ciphertext.getBytes(StandardCharsets.UTF_8);
        final byte[] sign = SM2Utils.sign(privateKey, signCiphertextBytes);
        return ByteUtils.toHexString(sign);
    }

    public static String decrypt(String ciphertextInfo, String channelId) {
        final int index = ciphertextInfo.indexOf("|+|");
        final String signature = ciphertextInfo.substring(0, index);
        final String ciphertext = ciphertextInfo.substring(index + "|+|".length());
        try {
            // 验签
            final boolean verifyResult = verify(channelId, signature, ciphertext);
            // 解密
            BCECPrivateKey privateKey = PRI_KEY_PARAMS.get(channelId);
            if (privateKey == null) {
                // 支付缴费热加载证书
                reloadPaymentCert(channelId);
                privateKey = PRI_KEY_PARAMS.get(channelId);
            }
            final byte[] ciphertextBytes = Base64.decode(ciphertext);
            final byte[] decryptedCiphertext = SM2Utils.decrypt(privateKey, ciphertextBytes);
            final byte[] plaintextBytes = Base64.decode(decryptedCiphertext);
            final String plaintext = new String(plaintextBytes, StandardCharsets.UTF_8);
            return plaintext;
        } catch (Exception e) {
            throw new RuntimeException("验签解密失败");
        }
    }

    private static boolean verify(String channelId, String signature, String ciphertext) {
        BCECPublicKey publicKey = PUB_KEY_PARAMS.get(channelId);
        if (publicKey == null) {
            // 支付缴费热加载证书
            reloadPaymentCert(channelId);
            publicKey = PUB_KEY_PARAMS.get(channelId);
        }
        final byte[] sign = ByteUtils.fromHexString(signature);
        final byte[] bytes = ciphertext.getBytes(StandardCharsets.UTF_8);
        return SM2Utils.verify(publicKey, bytes, sign);
    }
}
