package com.aote.rs.wechatauth;

import cn.hutool.http.HttpUtil;
import com.aote.util.WechatUrl;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * 获取微信code,openId
 */
@Component
public class WxOpenIdRequest {

    static Logger log = Logger.getLogger(WxOpenIdRequest.class);

    public WxOpenIdRequest() {
    }

    /**
     * 获取微信授权code请求
     *
     * @throws UnsupportedEncodingException
     */
    public String getCodeUrl(String appId, String redirectUrl, String state) throws UnsupportedEncodingException {
        String codeUrl = WechatUrl.CODE_URL;
        return codeUrl.replace("APPID", appId).replace("REDIRECT_URI", URLEncoder.encode(redirectUrl, "UTF-8")).replace("STATE", state);
    }

    /**
     * 获取微信用户唯一标识 openid
     */
    public JSONObject openidRequest(String code, String appId, String appSecret) {
        JSONObject result = new JSONObject();
        if (code == null) {
            throw new RuntimeException("登录失败，用户禁止授权！");
        }
        // 获取微信用户openid
        String openidUrl = WechatUrl.OPENID_URL
                .replace("APPID", appId)
                .replace("APPSECRET", appSecret)
                .replace("CODE", code);
        String openidResult = HttpUtil.get(openidUrl);
        if (openidResult == null) {
            throw new RuntimeException("请求错误！");
        }
        JSONObject openidJson = new JSONObject(openidResult);
        log.debug("获取到的openidJSON = " + openidJson);
        if (!openidJson.has("openid")) {
            throw new RuntimeException("获取用户openid失败! " + openidJson);
        }
        String openid = String.valueOf(openidJson.get("openid"));
        log.debug("获取到的openid = " + openid);
        result.put("openid", openid);
        return result;
    }
    public JSONObject getUserInfo (String openId, String accessToken) {
        String userInfoUrl = WechatUrl.USER_INFO
                .replace("ACCESSTOKEN", accessToken)
                .replace("OPENID", openId);
        String userInfo = HttpUtil.get(userInfoUrl);
        return new JSONObject(userInfo);
    }

}
