package com.aote.rs;

import cn.hutool.http.HttpUtil;
import com.aote.util.sxb.Sm2Tool;
import com.aote.weixin.Config;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.inject.Singleton;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import java.io.IOException;

/**
 * @description:
 * @author: 唐梓烨
 * @time: 2024/10/18 17:53
 */
@Path("third")
@Singleton
@Component
@Transactional(rollbackFor = Exception.class)
public class ThirdServer {
    static Logger log = LoggerFactory.getLogger(ThirdServer.class);
    @GET
    @Path("login/{tenant}")
    public String verifyServer2(@PathParam("tenant") String tenant, @QueryParam("token") String token, @Context HttpServletResponse response) {
        JSONObject wxConfig = Config.getConfig(tenant);
        log.info("传来的参数：tenant:{},token:{}", tenant, token);
        String getOpenIdUrl = wxConfig.getString("thirdOpenidUrl");
        String ywNotifyUrl = wxConfig.getString("ywNotifyUrl");

        // 根据token 获取用户openid
        JSONObject tokenParam = new JSONObject().put("token", token);
        JSONObject params = new JSONObject().put("params", tokenParam);
        log.info("请求第三方地址：{},参数:{}", getOpenIdUrl, params);
        String post = HttpUtil.post(getOpenIdUrl, params.toString(), 60000);
        log.info("请求第三方地址返回：{}", post);
        JSONObject jsonObject = new JSONObject(post);
        if (jsonObject.getJSONObject("status").getInt("code") == 200) {
            String originalOpenid = jsonObject.getJSONObject("custom").getString("openid");
            String openid;
            try {
                openid = new Sm2Tool().decrypt(originalOpenid);
                log.info("用户的openid：{}", openid);
            } catch (Exception e) {
                throw new RuntimeException("第三方返回数据解密失败！", e);
            }
            try {
                response.sendRedirect(ywNotifyUrl + openid + "&filiale=" + tenant);
            } catch (IOException e) {
                throw new RuntimeException("重定向获取微信授权失败！", e);
            }
        }
        return "";
    }
}
