package com.aote.rs;

import com.af.plugins.RSAUtil;
import com.aote.config.SystemConfig;
import com.aote.util.JsonHelper;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.inject.Singleton;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import java.io.IOException;


/**
 * @description:
 * @author: 唐梓烨
 * @time: 2024/9/9 17:33
 */
@Path("init")
@Singleton
@Component
@Transactional(rollbackFor = Exception.class)
public class InitServer {
    @GET
    public String verifyServer(@QueryParam("key") String key,@Context HttpServletResponse response) throws IOException {
        String result = "";
        if (key.isEmpty()) {
            response.sendError(403);
        } else {
            String encryKey = SystemConfig.DataSecurity.getAesKey();
            String newKey = encryKey + "-" + key;
            result = RSAUtil.encrypt(newKey);
        }
        return result;
    }
}
