package com.aote.rs;

import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import java.io.Serializable;

@Slf4j
@Component
@Path("csm")
@Singleton
@Transactional
public class CsmServer implements Serializable {

    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private LogicServer logicServer;

    /**
     * 用户进入页面之后点击呼叫排队，进行分配客服
     * @param request
     * @param value
     * @return
     */
    @POST
    @Path("assign-agent")
    public String assignAgent(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("客户系统收到请求分配客服请求: {}", value);
            result = logicServer.run("assignAgent", value).toString();
        } catch (Exception e) {
            log.debug("客户系统分配客服请求异常", e);
        }
        return result;
    }

    @POST
    @Path("call-client")
    public String callClient(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("客服呼叫用户: {}", value);
            result = logicServer.run("callClient", value).toString();
        } catch (Exception e) {
            log.debug("客服呼叫用户请求异常", e);
        }
        return result;
    }
}
