package com.aote.pay.icbc.weinan;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
/**
 * 软件开发工具包 配制
 * @author xuyaowen
 *
 */

public class SDKConfig {

	/** 签名证书路径. */
	public String signCertPath;
	/** 签名证书密码. */
	public String signCertPwd;
	/** 签名证书密码. */
	public String signCertType;
	/** 加密公钥证书路径. */

	/** 配置文件中签名证书路径常量. */
	public static final String SDK_SIGNCERT_PATH = "acpsdk.signCert.path";
	/** 配置文件中签名证书密码常量. */
	public static final String SDK_SIGNCERT_PWD = "acpsdk.signCert.pwd";
	/** 配置文件中签名证书类型常量. */
	public static final String SDK_SIGNCERT_TYPE = "acpsdk.signCert.type";
	/** 属性文件对象. */
	private Properties properties;

	/**
	 * 默认构造函数
	 */
	public SDKConfig() {
		super();
	}

	/**
	 * 从properties文件加载
	 *
	 * @param rootPath
	 *            不包含文件名的目录.
	 */
	public void loadPropertiesFromPath(String rootPath,String FILE_NAME) {
		File file = new File(rootPath + File.separator + FILE_NAME);
		System.out.println("in:"+ file);
		InputStream in = null;
		if (file.exists()) {
			try {
				in = new FileInputStream(file);
				BufferedReader bf=new BufferedReader(new InputStreamReader(in,"utf-8"));
				properties = new Properties();
				properties.load(bf);
				loadProperties(properties);
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				if (null != in) {
					try {
						in.close();
					} catch (IOException e) {
						e.printStackTrace();
					}
				}
			}
		} else {
			// 由于此时可能还没有完成LOG的加载，因此采用标准输出来打印日志信息
			System.out.println(rootPath + FILE_NAME + "不存在,加载参数失败");
		}
	}

	/**
	 * 从classpath路径下加载配置参数
	 */
	public void loadPropertiesFromSrc(String FILE_NAME) {
		InputStream in = null;
		try {
			// Properties pro = null;
			in = SDKConfig.class.getClassLoader().getResourceAsStream(FILE_NAME);
			System.out.println("in:"+ in);
			if (null != in) {
				BufferedReader bf=new BufferedReader(new InputStreamReader(in,"utf-8"));
				properties = new Properties();
				try {
					properties.load(bf);
				} catch (IOException e) {
					throw e;
				}
			}
			loadProperties(properties);
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (null != in) {
				try {
					in.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	/**
	 * 根据传入的
	 * java.util.Properties)}对象设置配置参数
	 *
	 * @param pro
	 */
	public void loadProperties(Properties pro) {
		String value = "";
		try {
			value = pro.getProperty(SDK_SIGNCERT_PATH);
			if (!SDKUtil.isEmpty(value)) {
				this.signCertPath = value.trim();
			}
			value = pro.getProperty(SDK_SIGNCERT_PWD);
			if (!SDKUtil.isEmpty(value)) {
				this.signCertPwd = value.trim();
			}
			value = pro.getProperty(SDK_SIGNCERT_TYPE);
			if (!SDKUtil.isEmpty(value)) {
				this.signCertType = value.trim();
			}
		} catch (Exception e) {
			// TODO: handle exception
		}

	}

	public String getSignCertPath() {
		return signCertPath;
	}

	public void setSignCertPath(String signCertPath) {
		this.signCertPath = signCertPath;
	}

	public String getSignCertPwd() {
		return signCertPwd;
	}

	public void setSignCertPwd(String signCertPwd) {
		this.signCertPwd = signCertPwd;
	}

	public String getSignCertType() {
		return signCertType;
	}

	public void setSignCertType(String signCertType) {
		this.signCertType = signCertType;
	}


	public Properties getProperties() {
		return properties;
	}

	public void setProperties(Properties properties) {
		this.properties = properties;
	}

}
