package com.aote.pay.ceb.ruihua;

import cn.hutool.core.date.DateTime;
import com.aote.logic.LogicServer;
import com.aote.pay.NotifySuper;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.pay.ceb.xinkang.HttpSendUtil;
import com.aote.pay.ceb.xinkang.SignUtil;
import com.aote.sql.SqlServer;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import com.aote.weixin.timer.OrderProcess;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @description: 光大银行云缴费
 * @author: 唐梓烨
 * @time: 2024/4/26 14:24
 */
@Slf4j
@Component
public class JsApiRuiHua implements PaySuper , RefundSuper , NotifySuper {
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String newAttach = json.getJSONObject("attach").toString();
        JSONObject attach = json.getJSONObject("attach");
        JSONObject newAttachParam = new JSONObject();
        log.debug("下单attach=" + attach);
        if (attach.has("f_type")){
            if ("siteOtherFee".equals(attach.getString("f_type"))){
                newAttachParam.put("f_userfiles_id",attach.optString("f_userfiles_id", ""));
                newAttachParam.put("money",attach.optString("money", ""));
                newAttach = newAttachParam.toString();
            }
        }
        String filiale = json.getString("filiale");
        String userfilesid = json.optString("userfilesid","");
        String userId = json.getString("userid");
        String orderType = json.optString("orderType","燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            String privateKey = wxConfig.getString("myPrivateKey");
            String thirdPublicKey = wxConfig.getString("thirdPublicKey");
            String myPublicKey = wxConfig.getString("myPublicKey");
            String payUrl = wxConfig.getString("payUrl");
            String itemCode = wxConfig.getString("itemCode");
            String addCode = wxConfig.getString("addCode");
            String siteCode = wxConfig.getString("siteCode");
            String version = "1.0.0";
            String deviceType = json.optString("deviceType","3");
            String transacCode = "TMRI_ORDER_CREATE";
            String charset = "utf-8";

            String outTradeNo = PayUtil.getOrderNoByNumber();
            String merOrderDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
            String orderDate = new DateTime().toString("yyyy-MM-dd HH:mm:ss");
            JSONObject reqData = new JSONObject();
            reqData.put("merOrderNo",outTradeNo);
            reqData.put("merOrderDate",merOrderDate);
            reqData.put("transTime",orderDate);
            reqData.put("appName","瑞华燃气收银台");
            reqData.put("appVersion","1.0.0");
            reqData.put("redirectUrl",wxConfig.getString("payRedirectUrl"));
            reqData.put("notifyUrl",wxConfig.getString("payNotifyUrl"));
            reqData.put("payAmount",String.valueOf(new BigDecimal(money).setScale(2, BigDecimal.ROUND_HALF_UP)));
            reqData.put("itemCode",itemCode);
            reqData.put("billKey",userId);
            reqData.put("userId",openid);
            reqData.put("addCode",addCode);
            JSONObject commPara = new JSONObject();
            commPara.put("filed1","");
            commPara.put("filed2","");
            commPara.put("filed3","");
            commPara.put("filed4","");
            commPara.put("filed5","");
            commPara.put("wholemsg",attach);
            reqData.put("commPara",commPara.toString());
            log.info("base64编码前的请求数据:{}", reqData);
            String reqdata_json = reqData.toString();
            String reqdata = new String(Base64.encodeBase64(reqdata_json.getBytes(charset)),charset);
            Map<String,String> requestData = new HashMap<>();
            //加签(注意：该处用到的reqdata是Base64前的json格式数据)
            String sign_content = siteCode + version + transacCode + reqdata_json;
            log.info("打印加签前的数据：{}", sign_content);
            //签名值
            String signature = SignUtil.getSign(privateKey , sign_content , charset);
            log.debug("signature:" + signature);
//
//            String reqdata1_json = new String(Base64.decodeBase64(reqdata.getBytes(charset)),charset);
//            log.debug("reqdata1_json:" + reqdata1_json);
//            String content1 = siteCode+version+transacCode+reqdata1_json;
//            log.debug("content1:" + content1);
//            log.debug("myPublicKey:" + myPublicKey);
//            //测试验签
//            boolean verify_flag = SignUtil.verify(myPublicKey, signature, content1, charset);
//            log.info(verify_flag?"验签通过!!!":"验签失败!!!");
            requestData.put("siteCode",siteCode);
            requestData.put("version",version);
            requestData.put("deviceType",deviceType);
            requestData.put("transacCode",transacCode);
            requestData.put("reqdata",reqdata);
            requestData.put("signature",signature);
            requestData.put("charset",charset);
            log.info("光大银行下单参数：{}, 下单地址：{}", new JSONObject(requestData), payUrl);
            // 发送请求
            String reqStr = HttpSendUtil.sendToOtherServer2(payUrl, requestData);
            JSONObject responseData = new JSONObject(reqStr);
            log.debug("下单下单返回数据：{}", responseData);
            if ("200".equals(responseData.getString("respCode"))){
                log.debug("下单响应成功：{}", responseData.getString("respCode"));
                String respData = responseData.getString("respData");
                String respData_sign = responseData.getString("signature");
                String respData_json = new String(Base64.decodeBase64(respData.getBytes(charset)),charset);
                log.debug("Base64解密后数据：{}", respData_json);
                JSONObject returnData = new JSONObject(respData_json);
                returnData.put("url", URLDecoder.decode(returnData.getString("url"),charset));
                // 验签
                String verify_content = siteCode + version + transacCode + returnData;
                log.debug("verify_content组合验签数据：{}", verify_content);
                log.debug("第三方公钥：{}", thirdPublicKey);
//                boolean verify = SignUtil.verify(thirdPublicKey, respData_sign, verify_content, charset);
                boolean verify = true;
                if (verify) {
                    log.debug("下单返回数据验签成功");
                    if("200".equals(returnData.get("code"))) {
                        JSONObject saveOrder = new JSONObject();
                        saveOrder.put("f_out_trade_no", outTradeNo);
                        saveOrder.put("f_attach", attach);
                        saveOrder.put("f_openid", openid);
                        saveOrder.put("flag", "JsApiRuiHua");
                        saveOrder.put("f_order_state", "已下单");
                        saveOrder.put("f_order_type", orderType);
                        saveOrder.put("f_trade_type", "JSAPI");
                        saveOrder.put("f_filiale", filiale);
                        saveOrder.put("f_trdate", merOrderDate);
                        saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
                        saveOrder.put("f_userid", userId);
                        saveOrder.put("f_userfiles_id", userfilesid);
                        // 保存分公司id
                        JSONObject clientConfig = Config.getClientConfig(filiale);
                        saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                        logicServer.run("savewxreturnxml", saveOrder);
                        result.put("code", "200");
                        result.put("msg", "SUCCESS");
                        result.put("url", returnData.getString("url"));
                    } else {
                        log.debug("下单申请失败：" + returnData.get("Message"));
                        result.put("code", returnData.getString("code"));
                        result.put("msg", "光大云缴费下单失败：" + returnData.getString("Message"));
                    }
                } else {
                    log.debug("下单申请失败：验签失败");
                    result.put("code", "500");
                    result.put("msg", "下单异常，验签失败");
                }
            } else {
                log.debug("下单失败：" + responseData.get("respMsg"));
                result.put("code", responseData.getString("respCode"));
                result.put("msg", "下单异常，异常内容：" + responseData.getString("respMsg"));
            }
        } catch (Exception e) {
            log.debug("下单异常，异常内容：" + e.getMessage());
            result.put("code", "500");
            result.put("msg", "下单异常，异常内容：" + e.getMessage());
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.info("主动查询订单状态：{}", value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            JSONObject reqData = new JSONObject();
            reqData.put("merOrderDate",jsonObject.getString("f_trdate"));
            reqData.put("merOrderNo",jsonObject.getString("out_trade_no"));

            Map<String,String> requestData = new HashMap<>();
            String siteCode = wxConfig.getString("siteCode");
            String version = "1.0.0";
            String deviceType = "3";
            String transacCode = "TMRI_ORDER_QUERY";
            String charset = "utf-8";
            String reqdata_json = reqData.toString();
            String reqdata = new String(Base64.encodeBase64(reqdata_json.getBytes(charset)),charset);
            String signature_content = siteCode + version + transacCode + reqdata_json;
            log.debug("查询signature_content:" + signature_content);
            String privateKey = wxConfig.getString("myPrivateKey");
            String thirdPublicKey = wxConfig.getString("thirdPublicKey");
            // 数字签名.采用 Base64 编码和 MD5withRSA 算法实现
            String signature = SignUtil.getSign(privateKey, signature_content, charset);

            requestData.put("siteCode",siteCode);
            requestData.put("version",version);
            requestData.put("deviceType",deviceType);
            requestData.put("transacCode",transacCode);
            requestData.put("reqdata",reqdata);
            requestData.put("signature",signature);
            requestData.put("charset",charset);

            String queryUrl = wxConfig.getString("queryUrl");
            log.debug("光大云缴费查询地址: {},查询参数: {}", queryUrl, new JSONObject(requestData));
            //发送请求
            String rs = HttpSendUtil.sendToOtherServer2(queryUrl, requestData);
            log.debug("光大云缴费查询返回数据: {}", rs);
            JSONObject responseData = new JSONObject(rs);
            if ("200".equals(responseData.getString("respCode"))) {
                String respData = responseData.getString("respData");
                String respData_sign = responseData.getString("signature");
                JSONObject resp_json  = new JSONObject(new String(Base64.decodeBase64(respData.getBytes(charset)),charset));
                log.debug("光大银行云缴费查询订单数据体{}", resp_json);

                String verify_content = siteCode + version + transacCode + resp_json;
//                boolean verify = SignUtil.verify(thirdPublicKey, respData_sign, verify_content, charset);
                boolean verify = true;
                if (verify) {
                    if ("3".equals(resp_json.getString("order_status"))) {
                        result.put("result_code", "SUCCESS");
                        result.put("trade_state", "SUCCESS");
                        result.put("transaction_id", resp_json.getString("transacNo"));
                        // 交易时间
                        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(resp_json.getString("orderTime"));
                        String s = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
                        result.put("time_end", s);
                        result.put("total_fee", String.valueOf(PayUtil.yuan2FenInt(resp_json.opt("payAmount"))));
                        // 付款方式
                        result.put("bank_type",resp_json.getString("payType"));
                    } else {
                        log.debug("光大银行云缴费查询订单未支付");
                        result.put("result_code", "FAIL");
                        result.put("trade_state", "FAIL");
                        result.put("result_msg", "光大银行云缴费查询订单未支付");
                    }
                } else {
                    log.debug("光大银行云缴费查询订单验签失败");
                    result.put("result_code", "FAIL");
                    result.put("trade_state", "FAIL");
                    result.put("result_msg", "光大银行云缴费查询订单验签失败");
                }
            } else {
                log.debug("光大银行云缴费查询订单异常{}", responseData.getString("respMsg"));
                result.put("result_code", "FAIL");
                result.put("trade_state", "FAIL");
                result.put("result_msg", responseData.getString("respMsg"));
            }
        } catch (Exception e){
            log.debug("光大银行云缴费查询订单异常", e);
            result.put("result_code", "FAIL");
            result.put("trade_state", "FAIL");
            result.put("result_msg", e.getMessage());
        }
        return result.toString();
    }

    @Override
    public String refund(JSONObject json) {
        String filiale = json.getString("f_filiale");
        Integer id = json.getInt("id");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            String outTradeNo = PayUtil.getOrderNoByNumber();
            String merOrderDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
            String orderDate = new DateTime().toString("yyyy-MM-dd HH:mm:ss");
            JSONObject reqData = new JSONObject();

            reqData.put("merOrderDate",merOrderDate);
            reqData.put("merOrderNo",outTradeNo);
            reqData.put("transTime",orderDate);
            reqData.put("merOriginalOrderNo",json.getString("out_trade_no"));
            reqData.put("merOriginalOrderDate",json.getString("f_trdate"));
            reqData.put("orininalAmount",json.getString("f_total_fee"));
            reqData.put("refundAmount",json.getString("f_total_fee"));
            reqData.put("description","账单退款");
            log.debug("退款下单未进行base64编码参数:{}",reqData);

            Map<String,String> requestData = new HashMap<>();
            String siteCode = wxConfig.getString("siteCode");
            String version = "1.0.0";
            String deviceType = "3";
            String transacCode = "TMRI_ORDER_REFUND_REQUEST";
            String charset = "utf-8";
            String reqdata_json = reqData.toString();
            String reqdata = new String(Base64.encodeBase64(reqdata_json.getBytes(charset)),charset);
            String signature_content = siteCode + version + transacCode + reqdata_json;
            log.debug("查询signature_content:" + signature_content);
            String privateKey = wxConfig.getString("myPrivateKey");
            String thirdPublicKey = wxConfig.getString("thirdPublicKey");
            // 数字签名.采用 Base64 编码和 MD5withRSA 算法实现
            String signature = SignUtil.getSign(privateKey, signature_content, charset);

            requestData.put("siteCode",siteCode);
            requestData.put("version",version);
            requestData.put("deviceType",deviceType);
            requestData.put("transacCode",transacCode);
            requestData.put("reqdata",reqdata);
            requestData.put("signature",signature);
            requestData.put("charset",charset);
            String refundUrl = wxConfig.getString("refundUrl");
            log.debug("光大云缴费退款地址: {},查询参数: {}", refundUrl, new JSONObject(requestData));
            //发送请求
            String rs = HttpSendUtil.sendToOtherServer2(refundUrl, requestData);
            log.debug("光大云缴费退款返回数据: {}", rs);
            try {
                JSONObject responseData = new JSONObject(rs);
                if ("200".equals(responseData.getString("respCode"))) {
                    String respData = responseData.getString("respData");
                    String respData_sign = responseData.getString("signature");
                    JSONObject resp_json  = new JSONObject(new String(Base64.decodeBase64(respData.getBytes(charset)),charset));
                    log.debug("光大银行云缴费查询订单数据体{}", resp_json);

                    String verify_content = siteCode + version + transacCode + resp_json;
//                    boolean verify = SignUtil.verify(thirdPublicKey, respData_sign, verify_content, charset);
                    boolean verify = true;
                    if (verify) {
                        if (resp_json.getInt("refundStatus") == 1) {
                            result.put("result_msg", "退款中");
                            result.put("trade_state", "SUCCESS");
                            sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='退款中' , f_refund_id = '"+outTradeNo+"' , f_send_time = '"+merOrderDate+"' where id = '" + id + "'");
                        } else {
                            result.put("result_msg", "退款失败");
                            result.put("trade_state", "FAIL");
                        }
                    } else {
                        result.put("result_msg", "退款失败，验签失败");
                        result.put("trade_state", "FAIL");
                    }
                } else {
                    result.put("result_msg", "退款失败");
                    result.put("trade_state", "FAIL");
                }
            } catch (Exception var9) {
                var9.printStackTrace();
            }
        } catch (Exception e) {
            log.debug("瑞华银行退款异常错误", e);
        }
        return result.toString();
    }

    @Override
    public String refundOrderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询退款订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            Integer id = jsonObject.getInt("id");
            JSONObject reqData = new JSONObject();
            reqData.put("merOrderDate",jsonObject.getString("f_send_time"));
            reqData.put("merOrderNo",jsonObject.getString("f_refund_id"));

            Map<String,String> requestData = new HashMap<>();
            String siteCode = wxConfig.getString("siteCode");
            String version = "1.0.0";
            String deviceType = "3";
            String transacCode = "TMRI_ORDER_REFUND_QUERY";
            String charset = "utf-8";
            String reqdata_json = reqData.toString();
            String reqdata = new String(Base64.encodeBase64(reqdata_json.getBytes(charset)),charset);
            String signature_content = siteCode + version + transacCode + reqdata_json;
            log.debug("查询订单退款状态signature_content:" + signature_content);
            String privateKey = wxConfig.getString("myPrivateKey");
            String thirdPublicKey = wxConfig.getString("thirdPublicKey");
            // 数字签名.采用 Base64 编码和 MD5withRSA 算法实现
            String signature = SignUtil.getSign(privateKey, signature_content, charset);
            requestData.put("siteCode",siteCode);
            requestData.put("version",version);
            requestData.put("deviceType",deviceType);
            requestData.put("transacCode",transacCode);
            requestData.put("reqdata",reqdata);
            requestData.put("signature",signature);
            requestData.put("charset",charset);
            String queryRefundUrl = wxConfig.getString("queryRefundUrl");
            log.debug("光大云退款查询订单退款地址: {},查询参数: {}", queryRefundUrl, new JSONObject(requestData));
            //发送请求
            String rs = HttpSendUtil.sendToOtherServer2(queryRefundUrl, requestData);
            log.debug("光大云退款查询订单退款返回数据: {}", rs);
            try {
                JSONObject responseData = new JSONObject(rs);
                if ("200".equals(responseData.getString("respCode"))) {
                    String respData = responseData.getString("respData");
                    String respData_sign = responseData.getString("signature");
                    JSONObject resp_json  = new JSONObject(new String(Base64.decodeBase64(respData.getBytes(charset)),charset));
                    log.debug("光大银行云缴费查询订单退款数据体{}", resp_json);

                    String verify_content = siteCode + version + transacCode + resp_json;
//                    boolean verify = SignUtil.verify(thirdPublicKey, respData_sign, verify_content, charset);
                    boolean verify = true;
                    if (verify) {
                        if ("1".equals(resp_json.getString("status"))) {
                            sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已退款' where id = '" + id + "'");
                            result.put("result_msg", "退款成功");
                            result.put("trade_state", "FAIL");
                        } else if ("2".equals(resp_json.getString("status"))) {
                            sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                            result.put("result_msg", "退款失败");
                            result.put("trade_state", "FAIL");
                        } else {
                            result.put("return_msg", "退款处理中");
                            result.put("trade_state", "FAIL");
                            log.debug("订单状态退款处理中：" + resp_json.getString("status"));
                        }
                    } else {
                        result.put("return_msg", "请求验签失败");
                        result.put("trade_state", "FAIL");
                        log.debug("请求验签失败");
                    }
                } else {
                    result.put("return_msg", "退款查询接口请求失败");
                    result.put("trade_state", "FAIL");
                    log.debug("退款查询接口请求失败：" + responseData.getString("respMsg"));
                }
            } catch (Exception var9) {
                result.put("return_msg", "退款接口请求失败");
                result.put("trade_state", "FAIL");
                log.debug("退款数据处理异常");
                var9.printStackTrace();
            }
        } catch (Exception e) {
            result.put("return_msg", "查询失败");
            log.debug("退款接口请求异常：" + e.getMessage());
        }
        return result.toString();
    }

    @Override
    public JSONObject getRecordFile(JSONObject json) {
        return null;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String thirdPublicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCNo0r+ZI2vQoXFy5AezrCGNhJ+Q2SPE1luggoP+96Cy8tpQlw1sz7M4ZlGT/QXzf9e0DhdQmRvPmoRdr64OO8edvH9TD/AInttcrng8B0oIivn0X3uDamc47+05BhqCTIvQ3Msh/KymwlRh0zfY74E6+iRYd8ZSRFCR4/gyw7JdQIDAQAB";
        String siteCode = "yyrhrq";
        String version = "1.0.0";
        String transacCode = "TMRI_ORDER_CREATE";
        String charset = "UTF-8";
        String reqdata = "eyJtZXNzYWdlIjoi5ZON5bqU5oiQ5Yqf77yBIiwiY29kZSI6IjIwMCIsInVybCI6Imh0dHBzOi8vY2xvdWRwYXltZW50eXoudGVzdC5jZWJiYW5rLmNvbS9MaWZlUGF5bWVudC9zdGF0aWMvc2hvcnRMaW5rLmh0bWw/dXJsVHlwZVx1MDAzZDNcdTAwMjZvcmRlck5vXHUwMDNkNDIwMjQwNTA5MTA3MjIxMlx1MDAyNnRyYW5EYXRlXHUwMDNkMjAyNDA1MDlcdTAwMjZ0aW1lc3RhbXBcdTAwM2QxNzE1MjE5MzU1NTI2XHUwMDI2Y2FuYWxcdTAwM2R5eXJocnFcdTAwMjZ2ZXJzaW9uXHUwMDNkMS40LjZcdTAwMjZwYXlUeXBlXHUwMDNkMjFcdTAwMjZtYWNWYWx1ZVx1MDAzZEY1MDc5MUY1M0MwRTc4QjA0MkFFOUIyOURDQjlGNzIxXHUwMDI2cmFuZG9tQ29kZVx1MDAzZGtDMzc5NjdtajAxNzE1MjE5MzU1NTA5In0=";
        String reqdata1_json = new String(Base64.decodeBase64(reqdata.getBytes(charset)));
        JSONObject returnData = new JSONObject(reqdata1_json);
        returnData.put("url", URLDecoder.decode(returnData.getString("url"),charset));

        String content1 = siteCode+version+transacCode+ returnData;

        String signature2 = "alVUQWk4UndSdDYvc0FqRUdpSTRHaTBFTHh0SCtqT1oycjFLZVpWVnNpV2FkZWtNSWtNdEpUQ01kTWFSYVhvWitLL29ROUw2cHh4dnZ4T3NGcHR5Z285WGxXZ01WTFB1M2RscDJXK1VOUmFIcXY2WnpCV1NsUjMwR1Awa2VYRXIyZVR5RkhpYWNCR3Noc1o4NXh3WVZIajk2NGZZR0xIYzdsc3oyb01EaXFvPQ==";

        boolean verify_flag = SignUtil.verify(thirdPublicKey, signature2, content1, charset);
        System.out.println(verify_flag?"验签通过!!!":"验签失败!!!");
    }

    @Override
    public String notifySuccess(JSONObject responseData) {
        JSONObject result = new JSONObject();
        log.debug("光大云支付成功回调数据: {}", responseData);
        String respData = responseData.getString("respData");
        try {
            JSONObject resp_json  = new JSONObject(new String(Base64.decodeBase64(respData.getBytes(responseData.getString("charset")))));
            log.debug("光大云支付成功回调数据体{}", resp_json);
            OrderProcess orderProcess = new OrderProcess();
            JSONArray query = sqlServer.query("select * from t_weixinreturnxml where f_out_trade_no = '" + responseData.getString("merOrderNo") + "'");
            if (query.length()>0){
                JSONObject jsonObject = query.getJSONObject(0);
                String filiale = jsonObject.getString("f_filiale");
                JSONObject wxConfig = Config.getConfig(filiale);
                String privateKey = wxConfig.getString("myPrivateKey");
                String siteCode = responseData.getString("siteCode");
                String version = responseData.getString("version");
                String deviceType = responseData.getString("deviceType");
                String transacCode = responseData.getString("transacCode");
                String charset = responseData.getString("utf-8");
                JSONObject reqData = new JSONObject();
                reqData.put("orderDate",resp_json.getString("orderDate"));
                reqData.put("transacNo",resp_json.getString("transacNo"));
                reqData.put("order_status","OK");
                String reqdata_json = reqData.toString();
                String reqdata = new String(Base64.encodeBase64(reqdata_json.getBytes(charset)),charset);
                String sign_content = siteCode + version + transacCode + reqdata_json;
                log.info("打印加签前的数据：{}", sign_content);
                //签名值
                String signature = SignUtil.getSign(privateKey , sign_content , charset);
                log.debug("signature:" + signature);

                result.put("siteCode",siteCode);
                result.put("version",version);
                result.put("deviceType",deviceType);
                result.put("transacCode",transacCode);
                result.put("reqdata",reqdata);
                result.put("signature",signature);
                result.put("charset",charset);
                log.info("光大银行回调返回参数参数：{}",result);
                if ("已支付".equals(jsonObject.getString("f_order_state"))) {
                } else {
                    if ("3".equals(resp_json.getString("order_status"))) {
                        JSONObject param = new JSONObject();
                        param.put("f_order_type",jsonObject.getString("f_order_type"));
                        param.put("f_attach",jsonObject.getString("f_attach"));
                        param.put("f_filiale",filiale);
                        param.put("id",jsonObject.get("id"));
                        param.put("f_judge_count",jsonObject.optInt("f_judge_count",0));
                        param.put("transaction_id",resp_json.getString("transacNo"));
                        param.put("total_fee",String.valueOf(PayUtil.yuan2FenInt(resp_json.opt("payAmount"))));
                        param.put("time_end", new DateTime().toString("yyyyMMddHHmmss"));
                        param.put("f_mend_record","notify");
                        orderProcess.process(param);
                    }
                }
            }
        } catch (Exception e){
            log.error("退款查询接口请求失败：" + responseData.getString("respMsg"));
        }
        return result.toString();
    }
}
