package com.aote.pay.abc_furuike;

import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.xianbank.tongchuan.Base64Utils;
import com.aote.util.PayUtil;
import com.aote.util.WxSign;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.net.URI;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * 大荔农行掌银对接下单接口
 * @author tzh
 */
@Slf4j
@Component
public class JsApiDaLi implements PaySuper {

    @Autowired
    private LogicServer logicServer;
    

    /**
     * 下单接口(6.3.1 方式 1：通过与农行服务器建立连接访问农行支付平台服务)
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        log.debug("大荔下单参数: {}", json);
        HttpServletRequest req = (HttpServletRequest)json.get("request");
        String money = json.getString("money");
        double doubleMoney = Double.parseDouble(money);
        DecimalFormat df = new DecimalFormat("0.00");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userfilesid = json.getString("userfilesid");
        String orderType = json.optString("orderType","燃气收费");
        JSONObject result = new JSONObject();
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        try {
            // 报文头
            String channelCode = "0004";
            // 报文体
            JSONObject dataParam = new JSONObject();
            String appId = wxConfig.getString("appId");
            // 支付订单编号
            String orderNo = WxSign.getNonceStr();
            // 交易模式
            dataParam.put("paymode","2");
            // 交易类型
            dataParam.put("transtype","A");
            dataParam.put("countno",wxConfig.optString("countno"));
            dataParam.put("terminal_serialno",orderNo);
            dataParam.put("amount",df.format(doubleMoney));
            dataParam.put("body",orderType + '-' + userfilesid);
            dataParam.put("notify_url",wxConfig.getString("wechatNotify"));
            dataParam.put("api_type","JSAPI");
            dataParam.put("appid",wxConfig.getString("appId"));
            dataParam.put("openid",openid);
            dataParam.put("spbill_create_ip",req.getRemoteAddr());
            // todo
            String signParam = "A"+df.format(doubleMoney)+orderNo;
            String publicKey = wxConfig.getString("publicKey");
            String sign = RSAEncrypt.encrypt(signParam,publicKey);
            dataParam.put("macdata",sign);
            // todo 对dataParam base64加密
            byte[] bytes = (channelCode + dataParam.toString()).getBytes("gbk");
            String sendPackage = Base64Utils.encode(bytes);
            String PayUrl = wxConfig.getString("payUrl");
            // 创建 URIBuilder 实例
            URIBuilder uriBuilder = new URIBuilder(PayUrl);
            // 添加参数到URIBuilder
            uriBuilder.addParameter("reqDate", new SimpleDateFormat("yyyyMMdd").format(new Date()));
            uriBuilder.addParameter("reqTime", new SimpleDateFormat("HHmmss").format(new Date()));
            uriBuilder.addParameter("provCode", "26");
            uriBuilder.addParameter("srcAreaCode", "26");
            uriBuilder.addParameter("accessType", "Application/json");
            uriBuilder.addParameter("sendPackage", sendPackage);
            uriBuilder.addParameter("macdata", sign);
            // 获取构建后的URI
            URI uri = uriBuilder.build();

            log.debug("下单地址: {},下单bogy参数: {}", uri.toString(), dataParam);
            CloseableHttpClient client ;
            CloseableHttpResponse response ;
            String res ;
            try {
                HttpPost httpPost = new HttpPost(uri.toString());
                StringEntity entityParams = new StringEntity(dataParam.toString(), "utf-8");
                httpPost.setEntity(entityParams);
                httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                client = HttpClients.createDefault();
                response = client.execute(httpPost);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != HttpStatus.SC_OK) {
                    log.error("HTTP请求未成功！HTTP Status Code:" + response.getStatusLine());
                } else {
                    res =  EntityUtils.toString(response.getEntity());
                    log.debug("查看返回结果xml: {}",res);
                    try {
                        Document document = DocumentHelper.parseText(res);
                        Element rootEle = document.getRootElement();
                        String respCode=rootEle.elementText("respCode");
                        String respExplain=rootEle.elementText("respExplain");
//                        JSONObject responseJson = XML.toJSONObject(res);
                        if ("0000".equals(respCode)&&"success".equals(respExplain)) {
                            byte[] base64arr= Base64.getDecoder().decode(rootEle.elementText("recvPackage"));
                            String recvPackage = new String(base64arr,"gbk");
                            log.debug("recvPackage==>{}",recvPackage);
                            // 去掉开头的 0004
                            JSONObject recive = new JSONObject(recvPackage.substring(4));
                            if ("00".equals(recive.getString("respcode"))) {
                                // 保存下单信息到中间表
                                JSONObject saveOrder = new JSONObject();
                                saveOrder.put("f_out_trade_no", orderNo);
                                saveOrder.put("f_attach", attach);
                                saveOrder.put("f_openid", openid);
                                saveOrder.put("flag", "JsApiDaLi");
                                saveOrder.put("f_order_state", "已下单");
                                saveOrder.put("f_order_type", "燃气收费");
                                saveOrder.put("f_trade_type", "JSAPI");
                                saveOrder.put("f_filiale", filiale);
                                saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
                                // 保存分公司id
                                JSONObject clientConfig = Config.getClientConfig(filiale);
                                saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                                logicServer.run("savewxreturnxml", saveOrder);
                                result.put("code", "200");
                                result.put("msg", "SUCCESS");
                                result.put("f_out_trade_no", orderNo);
                                result.put("appId", appId);
                                result.put("prepay_id", recive.getString("prepay_id"));
                                byte[] base64payData= Base64.getDecoder().decode(recive.getString("pay_data"));
                                String payData = new String(base64payData,"gbk");
                                result.put("pay_data", payData);
                            } else {
                                result.put("code", recive.getString("respcode"));
                                result.put("error", "下单失败，失败原因:" + recive.getString("result"));
                            }
                        } else {
                            result.put("code", respCode);
                            result.put("error", "响应失败");
                        }
                    } catch (Exception e) {
                        log.debug("结果转换错误");
                        result.put("code", "302");
                        result.put("error",  e.getMessage());
                    }
                }
            } catch (Exception e){
                log.debug("请求响应错误");
                result.put("code", "500");
                result.put("result_msg", "请求响应错误");
                result.put("err_msg", e.getMessage());
                throw new RuntimeException("下单请求农行掌银支付未正常响应");
            }
        } catch (Exception e) {
            log.debug("操作失败, 原因: {}", e.getMessage());
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {

        JSONObject result = new JSONObject();
        try {
            // 报文头
            String channelCode = "0004";
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            // 订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            // 分公司
            String filiale = jsonObject.getString("f_filiale");
            JSONObject wxConfig = Config.getConfig(filiale);
            String publicKey = wxConfig.getString("publicKey");
            JSONObject dataParam = new JSONObject();
            dataParam.put("paymode","2");
            dataParam.put("transtype","5");
            dataParam.put("countno",wxConfig.getString("countno"));
            dataParam.put("terminal_serialno",outTradeNo);
            String signParam = "5"+"0.00"+outTradeNo;
            String sign = RSAEncrypt.encrypt(signParam,publicKey);
            dataParam.put("macdata",sign);
            byte[] bytes = (channelCode + dataParam.toString()).getBytes("gbk");
            String sendPackage = Base64Utils.encode(bytes);
            String queryUrl = wxConfig.getString("queryUrl");
            // 创建 URIBuilder 实例
            URIBuilder uriBuilder = new URIBuilder(queryUrl);
            // 添加参数到URIBuilder
            uriBuilder.addParameter("reqDate", new SimpleDateFormat("yyyyMMdd").format(new Date()));
            uriBuilder.addParameter("reqTime", new SimpleDateFormat("HHmmss").format(new Date()));
            uriBuilder.addParameter("provCode", "26");
            uriBuilder.addParameter("srcAreaCode", "26");
            uriBuilder.addParameter("accessType", "Application/json");
            uriBuilder.addParameter("sendPackage", sendPackage);
            uriBuilder.addParameter("macdata", sign);
            // 获取构建后的URI
            URI uri = uriBuilder.build();
            CloseableHttpClient client ;
            CloseableHttpResponse response ;
            String res ;
            try {
                HttpPost httpPost = new HttpPost(uri.toString());
                StringEntity entityParams = new StringEntity(dataParam.toString(), "utf-8");
                httpPost.setEntity(entityParams);
                httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                client = HttpClients.createDefault();
                response = client.execute(httpPost);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != HttpStatus.SC_OK) {
                    log.error("HTTP请求未成功！HTTP Status Code:" + response.getStatusLine());
                } else {
                    res =  EntityUtils.toString(response.getEntity());
                    log.debug("查看返回结果xml: {}",res);
                    try {
                        Document document = DocumentHelper.parseText(res);
                        Element rootEle = document.getRootElement();
                        String respCode=rootEle.elementText("respCode");
                        String respExplain=rootEle.elementText("respExplain");
//                        JSONObject responseJson = XML.toJSONObject(res);
                        if ("0000".equals(respCode)&&"success".equals(respExplain)) {
                            byte[] base64arr= Base64.getDecoder().decode(rootEle.elementText("recvPackage"));
                            String recvPackage = new String(base64arr,"gbk");
                            // 去掉开头的0004
                            JSONObject recive = new JSONObject(recvPackage.substring(4));
                            if ("00".equals(recive.getString("respcode"))) {
                                result.put("result_code", "SUCCESS");
                                result.put("trade_state", "SUCCESS");
                                result.put("f_total_fee", "SUCCESS");
                                result.put("transaction_id",recive.getString("transaction_id"));
                                result.put("time_end", recive.getString("transdate")+recive.getString("transtime"));
                            } else {
                                result.put("result_code", "FAIL");
                                result.put("result_msg", recive.getString("result"));
                            }
                        } else {
                            result.put("result_code", "FAIL");
                            result.put("result_msg", "响应失败");
                        }
                    } catch (Exception e) {
                        log.debug("结果转换错误");
                        result.put("result_code", "FAIL");
                        result.put("result_msg",  e.getMessage());
                    }
                }
            } catch (Exception e){
                log.debug("请求响应错误");
                result.put("result_code", "FAIL");
                result.put("result_msg",  e.getMessage());
            }
        } catch (Exception e) {
            log.debug("操作失败, 原因: {}", e.getMessage());
            result.put("result_code", "FAIL");
            result.put("trade_state", "FAIL");
            result.put("result_msg", e.getMessage());
        }
        log.debug("查询订单返回: {}", result.toString());
        return result.toString();
    }
}

