package com.aote.pay.yuantiao;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;


/**
 * @author 唐梓烨
 */
public class ValidateUtil {

    /**
     * 验签
     *
     * @param:
     * @return:
     */
    public static boolean validate(String certPath, String transData, String signMsg) throws Exception {
        /*====1.获取公钥信息=====*/
        PublicKey publicKey = getValidateCert(certPath).getPublicKey();
        String prikeyStr = Base64.getEncoder().encodeToString(publicKey.getEncoded());
        /*=====2.根据原文获取摘要信息=====*/
        String digest = DigestUtil.getDigest(transData);
        /*====3.验签=======*/
        boolean validateSignRes = validateSignBySoft(publicKey, digest, signMsg);
        return validateSignRes;
    }

    /**
     * 验签
     *
     * @param:
     * @return:
     */
    public static X509Certificate getValidateCert(String ValidateCertPath) {
        X509Certificate validateCert = null;
        File file = new File(ValidateCertPath);
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            in = new FileInputStream(file.getAbsolutePath());
            validateCert = (X509Certificate) cf.generateCertificate(in);
        } catch (CertificateException e) {
            e.printStackTrace();

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } finally {
            if (null != in) {
                try {
                    in.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return validateCert;
    }

    /**
     * 验签
     *
     * @param:
     * @return:
     */
    public static boolean validateSignBySoft(PublicKey publicKey, String digest, String signMsg) throws Exception {
        /*=====1.根据算法获取签名对象=====*/
        Signature st = Signature.getInstance("SHA256withRSA");
        /*=====2.根据公钥初始化签名对象=====*/
        st.initVerify(publicKey);
        /*=====3.将摘要信息更新到签名对象中=====*/
        st.update(digest.getBytes("UTF-8"));
        /*=====4.验签=====*/
        byte[] signBytes = Base64.getDecoder().decode(signMsg);
        return st.verify(signBytes);
    }
}

