package com.aote.pay.icbc.yulinzhongran;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.util.PayUtil;
import com.aote.util.WxSign;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.SortedMap;
import java.util.TreeMap;

/**
 * @Author: JoeCdy
 * @Description: 榆林中燃工行
 * @Date: Created in 13:41 2020/11/28
 */
@Slf4j
@Component
public class JsApiYuLinZhongRan implements PaySuper {

    @Autowired
    private LogicServer logicServer;
    

    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        String result = "";
        try {
            String money = String.valueOf(json.get("money"));
            String openid = json.getString("openid");
            String attach = String.valueOf(json.get("attach"));
            String filiale = json.getString("filiale");
            String otherType = json.getString("othertype");

            if (otherType == null || otherType.length() == 0) {
                otherType = "燃气收费";
            }

            // 分公司配置对象
            JSONObject wxConfig = Config.getConfig(filiale);
            // 交易码
            String busCode = "6003";
            // 平台商户号
            String merchantNo = wxConfig.getString("merchantNo");
            // 消费金额
            String totalFee = String.valueOf(PayUtil.yuan2FenInt(money));
            // 商户订单号
            String outTradeNo = PayUtil.getOutTradeNo();
            // 调用方编号
            String partnerNo = wxConfig.getString("partnerNo");
            // 同步跳转地址
            String returnUrl = wxConfig.getString("returnUrl") + openid +"&filiale=" + filiale;
            // 签名值
            String sign = "";
            // 进行签名值运算
            SortedMap<Object, Object> finalpackage = new TreeMap<Object, Object>();
            finalpackage.put("busCode", busCode);
            finalpackage.put("merchantNo", merchantNo);
            finalpackage.put("totalFee", totalFee);
            finalpackage.put("outTradeNo", outTradeNo);
            finalpackage.put("partnerNo", partnerNo);
            finalpackage.put("returnUrl", returnUrl);
            sign = WxSign.createSign(finalpackage, wxConfig.getString("icbcKey"));
            finalpackage.put("sign", sign);
            // 下单地址
            String downPayApi = wxConfig.getString("prePayUrl");
            // 下单参数
            String paramMap = new JSONObject(finalpackage).toString();
            log.debug("榆林工行下单地址: {},下单参数: {}", downPayApi, paramMap);
            // 发送下单请求
            String response = HttpUtil.post(downPayApi, paramMap);
            log.debug("榆林工行下单返回数据: {}", response);
            JSONObject responseJson = new JSONObject(response);
            if (!"00".equals(responseJson.getString("returnCode"))) {
                throw new RuntimeException("下单失败,银行返回信息:" + response);
            }
            String formData = responseJson.getString("formData");
            // 内容base64 解码, 返给前台
            result = Base64.decodeStr(formData);
            // 保存下单信息到中间表
            JSONObject saveOrder = new JSONObject();
            saveOrder.put("f_out_trade_no", outTradeNo);
            saveOrder.put("f_attach", attach);
            saveOrder.put("f_openid", openid);
            saveOrder.put("f_order_state", "已下单");
            saveOrder.put("flag", "JsApiYuLinZhongRan");
            saveOrder.put("f_trade_type", "JSAPI");
            saveOrder.put("f_order_type", otherType);
            saveOrder.put("f_filiale", filiale);
            saveOrder.put("f_total_fee", totalFee);
            // 保存分公司id
            JSONObject clientConfig = Config.getClientConfig(filiale);
            saveOrder.put("f_orgid", clientConfig.get("orgStr"));
            logicServer.run("savewxreturnxml", saveOrder);
        } catch (Exception e) {
            log.debug("榆林工行下单异常错误", e);
            result = "";
        }
        log.debug("榆林工行下单返给前台数据: {}", result);
        return result;
    }


    /**
     * 查询订单是否支付成功
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            // 交易码
            String busCode = "6004";
            // 平台商户号
            String merchantNo = wxConfig.getString("merchantNo");
            // 商户订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            // 调用方编号
            String partnerNo = wxConfig.getString("partnerNo");
            // 签名值
            String sign = "";
            // 进行签名值运算
            SortedMap<Object, Object> finalpackage = new TreeMap<Object, Object>();
            finalpackage.put("busCode", busCode);
            finalpackage.put("merchantNo", merchantNo);
            finalpackage.put("outTradeNo", outTradeNo);
            finalpackage.put("partnerNo", partnerNo);
            sign = WxSign.createSign(finalpackage, wxConfig.getString("icbcKey"));
            // 查询地址
            String downPayApi = wxConfig.getString("orderStatusUrl");
            // 查询报文
            String paramMap = new JSONObject(finalpackage).toString();
            log.debug("榆林工行查询地址: {},查询报文: {}", downPayApi, paramMap);
            // 发送查询请求
            String response = HttpUtil.post(downPayApi, paramMap);
            log.debug("榆林工行查询返回数据: {}", response);
            JSONObject responseJson = new JSONObject(response);
            if (!"00".equals(responseJson.getString("returnCode")) && !"1".equals(responseJson.optString("transType"))) {
                throw new RuntimeException("查询失败,银行返回信息:" + response);
            }
            // 支付成功,组织返回数据
            result.put("result_code", "SUCCESS");
            result.put("trade_state", "SUCCESS");
            // 订单号
            result.put("transaction_id", responseJson.getString("orderNo"));
            // 交易日期 (yyyyMMddHHmmss)
            result.put("time_end", DateUtil.format(DateUtil.parse(responseJson.getString("payTime")), DatePattern.PURE_DATETIME_PATTERN));
            // 交易金额 (分)
            result.put("total_fee", responseJson.get("totalFee"));
        } catch (Exception e) {
            result.put("trade_state", "FAIL");
            log.debug("榆林工行查询订单异常", e);
        }
        return result.toString();
    }
}
