package com.aote.weixin.timer;

import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class MyQuartzJobBean extends QuartzJobBean {

	private static final Logger LOGGER = Logger.getLogger(MyQuartzJobBean.class);

	@Override
	protected void executeInternal(JobExecutionContext jobexecutioncontext) {
		TimerWork timerWork = getApplicationContext(jobexecutioncontext).getBean(TimerWork.class);
		JobDataMap map = jobexecutioncontext.getTrigger().getJobDataMap();
		timerWork.doBusiness(new JSONObject(map.getWrappedMap()));
	}

	private ApplicationContext getApplicationContext(final JobExecutionContext jobexecutioncontext) {
		try {
			return (ApplicationContext) jobexecutioncontext.getScheduler().getContext().get("applicationContextKey");
		} catch (SchedulerException e) {
			LOGGER.error("jobexecutioncontext.getScheduler().getContext() error!", e);
			throw new RuntimeException(e);
		}
	}
}
