package com.aote.util.image;

import cn.hutool.http.HttpRequest;
import com.aote.util.WechatApiUtil;
import com.aote.v4.compatibility.core.redis.RedisUtil;
import com.aote.weixin.Config;
import okhttp3.*;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

/**
 * @description:
 * @author: 唐梓烨
 * @time: 2024/4/11 13:46
 */
@Component
public class BiaDuTextRecognition {
    public static final String TokenApi = "https://aip.baidubce.com/oauth/2.0/token";
    public static final String BAIDU_OCR_URL = "https://aip.baidubce.com/rest/2.0/ocr/v1/meter";
    private static final String BAIDU_API_TOKEN_CACHE_KEY = "baiduApiToken@";
    private RedisUtil redisUtil = RedisUtil.getInstance();
    private static  String APP_ID = "60856291";
    private static  String CLIENT_ID = "qK71Tm3tDRm2GZKmD8MhBk6L";
    private static  String CLIENT_SECRET = "veeMp41wqWUwx524MlSHShZj3GI7UWfw";

    static Logger LOGGER = LoggerFactory.getLogger(BiaDuTextRecognition.class);

    static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder().build();

//    static {
//        LOGGER.debug("BiaDuTextRecognition 文字识别 static start");
//        CLIENT_ID = Config.wechatConfig.getString("CLIENT_ID");
//        CLIENT_SECRET = Config.wechatConfig.getString("CLIENT_SECRET");
//        LOGGER.debug("BiaDuTextRecognition 文字识别 static end");
//    }
    public JSONObject textRecognition(String value) throws IOException {
        MediaType mediaType = MediaType.parse("application/x-www-form-urlencoded");
        RequestBody body = RequestBody.create(mediaType, "image="+ value +"&probability=false&poly_location=false");
        Request request = new Request.Builder()
                .url("https://aip.baidubce.com/rest/2.0/ocr/v1/meter?access_token=" + getAuthToken(Config.wechatConfig.getString("CLIENT_ID"),Config.wechatConfig.getString("CLIENT_SECRET")))
                .method("POST", body)
                .addHeader("Content-Type", "application/x-www-form-urlencoded")
                .addHeader("Accept", "application/json")
                .build();
        Response response = HTTP_CLIENT.newCall(request).execute();
        return new JSONObject(response.body().string());
    }

    public JSONObject getAccessToken(String clientId, String clientSecret){
        try {
            String grantType = "client_credentials";
            JSONObject json = new JSONObject();
            json.put("grant_type", grantType);
            json.put("client_id", clientId);
            json.put("client_secret", clientSecret);
            // 将JSON对象转换为字符串
            String jsonStr = json.toString();
            // 构建查询参数
            String params = "?grant_type=" + grantType + "&client_id=" + clientId + "&client_secret=" + clientSecret;
            // 发送POST请求，并设置请求体为表单数据（对于OAuth 2.0的客户端凭证流程，通常请求体为空）
            String resultStr = HttpRequest.post(TokenApi +  params)
                    .header("Content-Type", "application/json")
                    .header("Accept", "application/json")
                    .body(jsonStr)
                    .execute().body();
            LOGGER.info("resultStr返回值信息：" + resultStr);
            // 如果需要，将响应内容解析为JSONObject
            JSONObject resultJson = new JSONObject(resultStr);
            return resultJson;
        } catch (Exception e){
            return new JSONObject().put("msg", "获取token失败");
        }
    }
    private static String getBaiduApiTokenRedisKey(String clientId) {
        return  BAIDU_API_TOKEN_CACHE_KEY + clientId;
    }

    public String getAuthToken(String clientId,String clientSecret){
        String key = getBaiduApiTokenRedisKey(clientId);
        String token = (String) redisUtil.get(key);
        // 在这里判断是否有accessToken
        if (token != null) {
            LOGGER.info(clientId + ":获取现有token");
            return token;
        } else {
            synchronized (WechatApiUtil.class) {
                AtomicReference<String> newAccessToken = new AtomicReference<>();
                redisUtil.lock(key, () -> {
                    // 再次尝试从缓存获取，避免集群多实例重复请求获取auth
                    String newToken = (String) redisUtil.get(key);
                    if (newToken != null) {
                        LOGGER.info(clientId + ":获取现有token");
                        newAccessToken.set(newToken);
                    }
                    LOGGER.info("百度Api：" + clientId + ":进行鉴权操作");
                    JSONObject content = new JSONObject();
                    content.put("grant_type", "client_credential");
                    content.put("client_id", clientId);
                    content.put("client_secret", clientSecret);
                    JSONObject result = getAccessToken(clientId,clientSecret);
                    LOGGER.info("获取token返回值是：{}",result);
                    if (result.has("error")) {
                        throw new RuntimeException(result.toString());
                    } else {
                        String accessToken = result.getString("access_token");
                        int expiresIn = result.getInt("expires_in");
                        redisUtil.set(key, accessToken, expiresIn - 180);
                        newAccessToken.set(accessToken);
                    }
                    return content;
                });
                return newAccessToken.get();
            }
        }
    }
}
